/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.ReclassMappingTableNative;
import com.supermap.analyst.spatialanalyst.ReclassSegment;
import com.supermap.analyst.spatialanalyst.ReclassSegmentType;
import com.supermap.analyst.spatialanalyst.ReclassType;
import com.supermap.data.InternalHandleDisposable;

public class ReclassMappingTable
extends InternalHandleDisposable {
    private int m_SegmentCount;
    private ReclassType m_ReclassType;
    private boolean m_bRetainMissingValue;
    private double m_ChangeMissingValueTo;
    private boolean m_bRetainNoValue;
    private double m_ChangeNoValueTo;

    public ReclassMappingTable() {
        long l = ReclassMappingTableNative.jni_New();
        this.setHandle(l, false);
        this.m_SegmentCount = 0;
        this.m_bRetainMissingValue = false;
        this.m_ChangeMissingValueTo = -9999.0;
        this.m_bRetainNoValue = true;
        this.m_ReclassType = ReclassType.RANGE;
    }

    public ReclassMappingTable(ReclassMappingTable reclassMappingTable) {
        long l = ReclassMappingTableNative.jni_New();
        this.setHandle(l, false);
        this.m_SegmentCount = reclassMappingTable.getSegmentCount();
        this.setSegments(reclassMappingTable.getSegments());
        this.setRetainMissingValue(reclassMappingTable.isRetainMissingValue());
        this.setChangeMissingValueTo(reclassMappingTable.getChangeMissingValueTo());
        this.setRetainNoValue(reclassMappingTable.isRetainNoValue());
        this.setReclassType(reclassMappingTable.getReclassType());
    }

    public String toXml() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        String string = ReclassMappingTableNative.jni_ToXML(this.getHandle());
        return string;
    }

    public boolean toXmlFile(String xmlFileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return ReclassMappingTableNative.jni_ToXmlFile(this.getHandle(), xmlFileName);
    }

    public boolean fromXml(String xmlString) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = ReclassMappingTableNative.jni_FromXml(this.getHandle(), xmlString);
        if (bl) {
            this.m_ReclassType = (ReclassType)InternalEnum.parseUGCValue(ReclassType.class, ReclassMappingTableNative.jni_GetReclassType(this.getHandle()));
            this.m_SegmentCount = ReclassMappingTableNative.jni_GetSegmentCount(this.getHandle());
            this.m_bRetainMissingValue = ReclassMappingTableNative.jni_GetRetainMissingValue(this.getHandle());
            this.m_ChangeMissingValueTo = ReclassMappingTableNative.jni_GetChangeMissingValueTo(this.getHandle());
            this.m_bRetainNoValue = ReclassMappingTableNative.jni_GetRetainNoValue(this.getHandle());
            this.m_ChangeNoValueTo = ReclassMappingTableNative.jni_GetChangeNoValueTo(this.getHandle());
        }
        return bl;
    }

    public boolean fromXmlFile(String xmlFileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = ReclassMappingTableNative.jni_FromXmlFile(this.getHandle(), xmlFileName);
        if (bl) {
            this.m_ReclassType = (ReclassType)InternalEnum.parseUGCValue(ReclassType.class, ReclassMappingTableNative.jni_GetReclassType(this.getHandle()));
            this.m_SegmentCount = ReclassMappingTableNative.jni_GetSegmentCount(this.getHandle());
            this.m_bRetainMissingValue = ReclassMappingTableNative.jni_GetRetainMissingValue(this.getHandle());
            this.m_ChangeMissingValueTo = ReclassMappingTableNative.jni_GetChangeMissingValueTo(this.getHandle());
            this.m_bRetainNoValue = ReclassMappingTableNative.jni_GetRetainNoValue(this.getHandle());
            this.m_ChangeNoValueTo = ReclassMappingTableNative.jni_GetChangeNoValueTo(this.getHandle());
        }
        return bl;
    }

    public int getSegmentCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_SegmentCount;
    }

    public ReclassSegment[] getSegments() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        ReclassSegment[] reclassSegmentArray = new ReclassSegment[this.m_SegmentCount];
        double[] dArray = new double[this.m_SegmentCount];
        double[] dArray2 = new double[this.m_SegmentCount];
        double[] dArray3 = new double[this.m_SegmentCount];
        int[] nArray = new int[this.m_SegmentCount];
        ReclassMappingTableNative.jni_GetSegments(this.getHandle(), dArray, dArray2, dArray3, nArray);
        for (int i = 0; i < dArray.length; ++i) {
            reclassSegmentArray[i] = new ReclassSegment();
            reclassSegmentArray[i].setStartValue(dArray[i]);
            reclassSegmentArray[i].setEndValue(dArray2[i]);
            reclassSegmentArray[i].setNewValue(dArray3[i]);
            if (0 == nArray[i]) {
                reclassSegmentArray[i].setSegmentType(ReclassSegmentType.OPENCLOSE);
                continue;
            }
            reclassSegmentArray[i].setSegmentType(ReclassSegmentType.CLOSEOPEN);
        }
        return reclassSegmentArray;
    }

    public void setSegments(ReclassSegment[] segments) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegments()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_SegmentCount = segments.length;
        double[] dArray = new double[this.m_SegmentCount];
        double[] dArray2 = new double[this.m_SegmentCount];
        double[] dArray3 = new double[this.m_SegmentCount];
        int[] nArray = new int[this.m_SegmentCount];
        for (int i = 0; i < this.m_SegmentCount; ++i) {
            dArray[i] = segments[i].getStartValue();
            dArray2[i] = segments[i].getEndValue();
            dArray3[i] = segments[i].getNewValue();
            nArray[i] = InternalEnum.getUGCValue(segments[i].getSegmentType());
        }
        ReclassMappingTableNative.jni_SetSegments(this.getHandle(), dArray, dArray2, dArray3, nArray);
    }

    public ReclassType getReclassType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getReclassType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_ReclassType;
    }

    public void setReclassType(ReclassType reclassType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setReclassType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(reclassType);
        ReclassMappingTableNative.jni_SetReclassType(this.getHandle(), n);
        this.m_ReclassType = reclassType;
    }

    public boolean isRetainMissingValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRetainMissingValue()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_bRetainMissingValue;
    }

    public void setRetainMissingValue(boolean retainMissingValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRetainMissingValue()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        ReclassMappingTableNative.jni_SetRetainMissingValue(this.getHandle(), retainMissingValue);
        this.m_bRetainMissingValue = retainMissingValue;
    }

    public double getChangeMissingValueTo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChangeMissingValueTo()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_ChangeMissingValueTo;
    }

    public void setChangeMissingValueTo(double changeMissingValueTo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChangeMissingValueTo()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        ReclassMappingTableNative.jni_SetChangeMissingValueTo(this.getHandle(), changeMissingValueTo);
        this.m_ChangeMissingValueTo = changeMissingValueTo;
    }

    public boolean isRetainNoValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRetainNoValue()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_bRetainNoValue;
    }

    public void setRetainNoValue(boolean retainNoValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRetainNoValue()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        ReclassMappingTableNative.jni_SetRetainNoValue(this.getHandle(), retainNoValue);
        this.m_bRetainNoValue = retainNoValue;
    }

    public double getChangeNoValueTo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChangeNoValueTo()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_ChangeNoValueTo;
    }

    public void setChangeNoValueTo(double changeNoValueTo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setChangeNoValueTo()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        ReclassMappingTableNative.jni_SetChangeNoValueTo(this.getHandle(), changeNoValueTo);
        this.m_ChangeNoValueTo = changeNoValueTo;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            ReclassMappingTableNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }
}

