/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Locale;

public class TestMac {
    public static void main(String[] args) throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getLocalHost();
        String g_IPAddress = address.getHostAddress();
        String g_HostName = address.getHostName().toString();
        byte[] mac = TestMac.getUsedMAC();
        String g_MacAddress = "";
        Formatter formatter = new Formatter();
        for (int i = 0; i < mac.length; ++i) {
            g_MacAddress = formatter.format(Locale.getDefault(), "%02X%s", mac[i], i < mac.length - 1 ? "-" : "").toString();
        }
        System.out.println(g_MacAddress);
    }

    private static byte[] getUsedMAC() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
        byte[] mac = null;
        while (ni.hasMoreElements()) {
            NetworkInterface netI = ni.nextElement();
            mac = netI.getHardwareAddress();
            if (!netI.isUp() || netI == null || mac == null || mac.length != 6) continue;
            break;
        }
        if (mac != null) {
            return mac;
        }
        InetAddress address = InetAddress.getLocalHost();
        NetworkInterface iface = NetworkInterface.getByInetAddress(address);
        mac = iface.getHardwareAddress();
        if (mac == null) {
            mac = iface.getInetAddresses().nextElement().getAddress();
        }
        return mac;
    }
}

