/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.ColorDictionary;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Datasource;
import com.supermap.data.Environment;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoTIM;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.Model;
import com.supermap.data.Plane;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.Skeleton;
import com.supermap.data.SkeletonID;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.threeddesigner.BorderType;
import com.supermap.realspace.threeddesigner.BufferParameter;
import com.supermap.realspace.threeddesigner.ChamferStyle;
import com.supermap.realspace.threeddesigner.ClippingType;
import com.supermap.realspace.threeddesigner.ConstraintType;
import com.supermap.realspace.threeddesigner.InternalDatasetVector;
import com.supermap.realspace.threeddesigner.InternalDatasets;
import com.supermap.realspace.threeddesigner.InternalGeometry;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalModel;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import com.supermap.realspace.threeddesigner.LinearExtrudeParameter;
import com.supermap.realspace.threeddesigner.ModelBuilder3DNative;
import com.supermap.realspace.threeddesigner.ModelClipType;
import com.supermap.realspace.threeddesigner.NormalComputeMode;
import com.supermap.realspace.threeddesigner.RotateExtrudeParameter;
import com.supermap.realspace.threeddesigner.ShadowVolumeSetting;
import com.supermap.realspace.threeddesigner.SunlightAnalysisPointResult;
import com.supermap.realspace.threeddesigner.SunlightAnalysisSetting;
import com.supermap.realspace.threeddesigner.TextureMapParameter;
import com.supermap.realspace.threeddesigner.ViewShedType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class ModelBuilder3D {
    private static transient Vector m_steppedListeners;
    private static License m_license;

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    public static boolean buildGeoBody(ArrayList<Geometry3D> geoBlocks, ArrayList<Point3Ds> ptLevels, boolean bLonLat, Geometry clipRegions) {
        int n;
        boolean bl = false;
        if (null == geoBlocks || null == ptLevels) {
            return bl;
        }
        long l = 0L;
        if (clipRegions != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegions);
        }
        geoBlocks.clear();
        long[] lArray = new long[geoBlocks.size()];
        Object[] objectArray = new Object[ptLevels.size()];
        for (n = 0; n < ptLevels.size(); ++n) {
            Point3Ds point3Ds = ptLevels.get(n);
            long[] lArray2 = new long[point3Ds.getCount()];
            for (int i = 0; i < point3Ds.getCount(); ++i) {
                GeoPoint3D geoPoint3D = new GeoPoint3D(point3Ds.getItem(i));
                lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoPoint3D);
            }
            objectArray[n] = lArray2;
        }
        lArray = ModelBuilder3DNative.jni_BuildGeoBody(objectArray, l, bLonLat);
        if (lArray != null) {
            bl = true;
            for (n = 0; n < lArray.length; ++n) {
                geoBlocks.add((Geometry3D)InternalGeometry.createInstance(lArray[n]));
            }
        }
        return bl;
    }

    public static GeoModel3D buildGeoBody(Point3Ds ptList, double[] maxHighList, double[] minHighList) {
        if (ptList == null || ptList.getCount() < 3 || maxHighList == null || minHighList == null || ptList.getCount() != maxHighList.length || maxHighList.length != minHighList.length) {
            String string = InternalResource.loadString("ptList or maxHighList or minHighList", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[ptList.getCount()];
        double[] dArray2 = new double[ptList.getCount()];
        double[] dArray3 = new double[ptList.getCount()];
        for (int i = 0; i < ptList.getCount(); ++i) {
            dArray[i] = ptList.getItem(i).getX();
            dArray2[i] = ptList.getItem(i).getY();
            dArray3[i] = ptList.getItem(i).getZ();
        }
        GeoModel3D geoModel3D = null;
        long l = ModelBuilder3DNative.jni_BuildGeoBody(dArray, dArray2, dArray3, maxHighList, minHighList);
        if (0L != l) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public static GeoModel3D buildTIN(Point3Ds ptList, boolean bLonLat, Geometry clipRegions) {
        if (null == ptList || ptList.getCount() < 3) {
            String string = InternalResource.loadString("ptList", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegions != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegions);
        }
        double[] dArray = new double[ptList.getCount()];
        double[] dArray2 = new double[ptList.getCount()];
        double[] dArray3 = new double[ptList.getCount()];
        for (int i = 0; i < ptList.getCount(); ++i) {
            dArray[i] = ptList.getItem(i).getX();
            dArray2[i] = ptList.getItem(i).getY();
            dArray3[i] = ptList.getItem(i).getZ();
        }
        GeoModel3D geoModel3D = null;
        long l2 = ModelBuilder3DNative.Jni_BuildTIN(dArray, dArray2, dArray3, bLonLat, l);
        if (0L != l2) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    @Deprecated
    public static boolean combineSkeletonByMaterial(Model modelSrc, Model modelResult) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_CombineSkeletonByMaterial(l, l2);
    }

    public static GeoModel3D convexHull(ArrayList<GeoPoint3D> geoPnts, boolean bLonLat) {
        if (null == geoPnts) {
            String string = InternalResource.loadString("geoPnts", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[geoPnts.size()];
        for (int i = 0; i < geoPnts.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoPnts.get(i));
        }
        GeoModel3D geoModel3D = null;
        long l = ModelBuilder3DNative.Jni_ConvexHull(lArray, bLonLat);
        if (0L != l) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public static GeoModel3D convexHull(Point3Ds pnts, boolean bLonLat) {
        if (null == pnts) {
            String string = InternalResource.loadString("pnts", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = pnts.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pnts.getItem(i).getX();
            dArray2[i] = pnts.getItem(i).getY();
            dArray3[i] = pnts.getItem(i).getZ();
        }
        long l = ModelBuilder3DNative.jni_ConvexHull(dArray, dArray2, dArray3, bLonLat);
        GeoModel3D geoModel3D = null;
        if (0L != l) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public static Model convexHull(Model modelSrc) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ModelBuilder3DNative.jni_ConvexHull(l);
        Model model = null;
        if (0L != l2) {
            model = InternalModel.createInstance(l2);
        }
        return model;
    }

    public static Model convexHull(Model modelSrc, SkeletonID id) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ModelBuilder3DNative.jni_ConvexHull(l, id.getLODIndex(), id.getSkeletonIndex());
        Model model = null;
        if (0L != l2) {
            model = InternalModel.createInstance(l2);
        }
        return model;
    }

    public static Model convexHullPerSkeleton(Model modelSrc) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ModelBuilder3DNative.jni_ConvexHullPerSkeleton(l);
        Model model = null;
        if (0L != l2) {
            model = InternalModel.createInstance(l2);
        }
        return model;
    }

    public static ArrayList<GeoModel3D> envelop(GeoModel3D geomodel, double dbZ) {
        if (null == geomodel) {
            String string = InternalResource.loadString("geomodel", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geomodel);
        if (0L == l) {
            String string = InternalResource.loadString("geomodel", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        ArrayList<GeoModel3D> arrayList = null;
        long[] lArray = ModelBuilder3DNative.jin_Envelop(l, dbZ);
        if (lArray != null) {
            arrayList = new ArrayList<GeoModel3D>();
            for (int i = 0; i < lArray.length; ++i) {
                arrayList.add((GeoModel3D)InternalGeometry.createInstance(lArray[i]));
            }
        }
        return arrayList;
    }

    public static ArrayList<GeoModel3D> envelop(GeoRegion3D geometry, double dbZ) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = geometry.convertToGeoModel3D(true);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel3D);
        ArrayList<GeoModel3D> arrayList = null;
        long[] lArray = ModelBuilder3DNative.jin_Envelop(l2, dbZ);
        if (lArray != null) {
            arrayList = new ArrayList<GeoModel3D>();
            for (int i = 0; i < lArray.length; ++i) {
                arrayList.add((GeoModel3D)InternalGeometry.createInstance(lArray[i]));
            }
        }
        return arrayList;
    }

    public static ArrayList<GeoRegion3D> extractBorder(GeoModel3D geoModel, BorderType borderType) {
        if (null == geoModel) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel);
        if (0L == l) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelBuilder3DNative.jin_ExtractBorder(l, borderType.value());
        ArrayList<GeoRegion3D> arrayList = null;
        if (lArray != null) {
            arrayList = new ArrayList<GeoRegion3D>();
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == 0L) continue;
                arrayList.add((GeoRegion3D)InternalGeometry.createInstance(lArray[i]));
            }
        }
        return arrayList;
    }

    @Deprecated
    public static GeoModel3D linearExtrude(Geometry geometry, boolean bLonLat, double height, double twist, double scaleX, double scaleY) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 2);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = ModelBuilder3DNative.jni_LinearExtrude(l, bLonLat, height, twist, scaleX, scaleY);
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    @Deprecated
    public static GeoModel3D linearExtrude(Geometry geometry, boolean bLonLat, double height, double twist, double scaleX, double scaleY, TextureMapParameter texParam) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 2);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (texParam != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)texParam);
        }
        GeoModel3D geoModel3D = null;
        long l3 = ModelBuilder3DNative.jni_LinearExtrude(l, bLonLat, height, twist, scaleX, scaleY, l2);
        if (l3 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l3);
        }
        return geoModel3D;
    }

    public static GeoModel3D linearExtrude(Geometry geometry, boolean bLonLat, LinearExtrudeParameter extParam, TextureMapParameter uvwParam) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == extParam) {
            String string = InternalResource.loadString("extParam", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extParam);
        if (0L == l2) {
            String string = InternalResource.loadString("extParam", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 2);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (uvwParam != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)uvwParam);
        }
        GeoModel3D geoModel3D = null;
        long l4 = ModelBuilder3DNative.jni_LinearExtrude(l, bLonLat, l2, l3);
        if (l4 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l4);
        }
        return geoModel3D;
    }

    public static GeoModel3D loft(Geometry geometry, GeoLine3D line, boolean bLonLat, int Chamfer, ChamferStyle style) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == line || line.isEmpty()) {
            String string = InternalResource.loadString("line", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line);
        if (0L == l2) {
            String string = InternalResource.loadString("line", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 3);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l3 = ModelBuilder3DNative.jni_Loft(l, l2, bLonLat, Chamfer, style.value());
        if (l3 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l3);
        }
        return geoModel3D;
    }

    public static GeoModel3D loft(Geometry geometry, GeoLine3D line, boolean bLonLat, int Chamfer, ChamferStyle style, TextureMapParameter texParam) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == line || line.isEmpty()) {
            String string = InternalResource.loadString("line", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line);
        if (0L == l2) {
            String string = InternalResource.loadString("line", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 3);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (texParam != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)texParam);
        }
        GeoModel3D geoModel3D = null;
        long l4 = ModelBuilder3DNative.jni_Loft(l, l2, bLonLat, Chamfer, style.value(), l3);
        if (l4 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l4);
        }
        return geoModel3D;
    }

    public static GeoRegion planeProjection(GeoModel3D model) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 4);
        if (!bl || model.isLonLat()) {
            String string = InternalResource.loadString("model", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = null;
        long l2 = ModelBuilder3DNative.jni_PlaneProjection(l);
        if (l2 != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l2);
        }
        return geoRegion;
    }

    public static GeoRegion3D planeProjection(GeoModel3D model, Plane plane) {
        if (null == model || plane == null) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)plane);
        if (0L == l2) {
            String string = InternalResource.loadString("plane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 4);
        if (!bl) {
            String string = InternalResource.loadString("model", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion3D geoRegion3D = null;
        long l3 = ModelBuilder3DNative.jni_PlaneProjection(l, l2);
        if (l3 != 0L) {
            geoRegion3D = (GeoRegion3D)InternalGeometry.createInstance(l3);
        }
        return geoRegion3D;
    }

    public static GeoRegion planeProjection2D(GeoModel3D model, Plane plane) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == plane) {
            String string = InternalResource.loadString("plane", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)plane);
        if (0L == l2) {
            String string = InternalResource.loadString("plane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 4);
        if (!bl) {
            String string = InternalResource.loadString("model", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = null;
        long l3 = ModelBuilder3DNative.jni_PlaneProjection2D(l, l2);
        if (l3 != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l3);
        }
        return geoRegion;
    }

    public static boolean reComputeNormal(Model modelSrc, Model modelResult, NormalComputeMode normalMode, double dAngle) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = ModelBuilder3DNative.jni_ReComputeNormal(l, l2, normalMode.value(), dAngle);
        return bl;
    }

    public static int removeDuplicateVertex2(Model modelSrc, Model modelResult) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = ModelBuilder3DNative.jni_RemoveDuplicateVertex2(l, l2);
        return n;
    }

    public static int removeDuplicateVertex2(Skeleton skeleton) {
        if (skeleton == null) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)skeleton);
        if (0L == l) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_removeSkeletonDuplicateVertex2(l);
    }

    @Deprecated
    public static int removeUnreferencedVertex(Model modelSrc, Model modelResult) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = ModelBuilder3DNative.jni_RemoveUnreferencedVertex(l, l2);
        return n;
    }

    public static GeoModel3D rotateExtrude(Geometry geometry, double angle) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 6);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = ModelBuilder3DNative.jni_RotateExtrude(l, angle);
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public static GeoModel3D rotateExtrude(Geometry geometry, RotateExtrudeParameter rotParam) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == rotParam) {
            String string = InternalResource.loadString("rotParam", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)rotParam);
        if (0L == l2) {
            String string = InternalResource.loadString("rotParam", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 6);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l3 = ModelBuilder3DNative.jni_RotateExtrudeParam(l, l2);
        if (l3 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l3);
        }
        return geoModel3D;
    }

    @Deprecated
    public static GeoRegion sectionProjection(GeoModel3D model) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 0);
        if (!bl || model.isLonLat()) {
            String string = InternalResource.loadString("model", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = null;
        long l2 = ModelBuilder3DNative.jni_SectionProjection2(l);
        if (0L != l2) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l2);
        }
        return geoRegion;
    }

    public static GeoRegion sectionProjection2D(GeoModel3D model, Plane plane) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == plane) {
            String string = InternalResource.loadString("plane", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)plane);
        if (0L == l2) {
            String string = InternalResource.loadString("plane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 0);
        if (!bl) {
            String string = InternalResource.loadString("model", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = null;
        long l3 = ModelBuilder3DNative.jni_SectionProjection2D(l, l2);
        if (0L != l3) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l3);
        }
        return geoRegion;
    }

    public static GeoRegion3D sectionProjection(GeoModel3D model, Plane plane) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == plane) {
            String string = InternalResource.loadString("plane", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)plane);
        if (0L == l2) {
            String string = InternalResource.loadString("plane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 0);
        if (!bl) {
            String string = InternalResource.loadString("model", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion3D geoRegion3D = null;
        long l3 = ModelBuilder3DNative.jni_SectionProjection(l, l2);
        if (0L != l3) {
            geoRegion3D = (GeoRegion3D)InternalGeometry.createInstance(l3);
        }
        return geoRegion3D;
    }

    public static ArrayList<GeoRegion3D> sectionProjection(ArrayList<GeoModel3D> modelList, Plane plane) {
        if (null == modelList || modelList.size() == 0) {
            String string = InternalResource.loadString("modelList", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[modelList.size()];
        for (int i = 0; i < lArray.length; ++i) {
            long l;
            lArray[i] = l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelList.get(i));
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)plane);
        if (0L == l) {
            String string = InternalResource.loadString("plane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray2 = ModelBuilder3DNative.jni_SectionProjections(lArray, l);
        ArrayList<GeoRegion3D> arrayList = null;
        if (lArray2 != null) {
            arrayList = new ArrayList<GeoRegion3D>();
            for (int i = 0; i < lArray2.length; ++i) {
                if (lArray2[i] != 0L) {
                    arrayList.add((GeoRegion3D)InternalGeometry.createInstance(lArray2[i]));
                    continue;
                }
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    public static ArrayList<GeoRegion3D> sectionProjection(GeoModel3D model, ArrayList<Plane> planeList) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == planeList || planeList.size() == 0) {
            String string = InternalResource.loadString("planeList", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[planeList.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)planeList.get(i));
        }
        long[] lArray2 = ModelBuilder3DNative.jni_SectionProjections2(l, lArray);
        ArrayList<GeoRegion3D> arrayList = null;
        if (lArray2 != null) {
            arrayList = new ArrayList<GeoRegion3D>();
            for (int i = 0; i < lArray2.length; ++i) {
                if (lArray2[i] != 0L) {
                    arrayList.add((GeoRegion3D)InternalGeometry.createInstance(lArray2[i]));
                    continue;
                }
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    public static GeoModel3D shadowVolume(GeoModel3D model, ShadowVolumeSetting param) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (param != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)param);
        }
        GeoModel3D geoModel3D = null;
        long l3 = ModelBuilder3DNative.jni_ShadowVolume(l, l2);
        if (l3 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l3);
        }
        return geoModel3D;
    }

    public static boolean simplify(Model modelSrc, Model modelResult, double dbRatio, boolean bConstrainBorder) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = ModelBuilder3DNative.jni_Simplify(l, l2, dbRatio, bConstrainBorder);
        return bl;
    }

    public static boolean simplify(Model modelSrc, Model modelResult, double dbRatio, double dbThreshold) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = ModelBuilder3DNative.jni_Simplify(l, l2, dbRatio, dbThreshold);
        return bl;
    }

    public static boolean simplify(Model modelSrc, Model modelResult, ArrayList<SkeletonID> listIDs, double[] listRatio, boolean bConstrainBorder) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listIDs == null) {
            String string = InternalResource.loadString("listIDs", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listRatio == null) {
            String string = InternalResource.loadString("listRatio", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listIDs.size() != listRatio.length) {
            String string = InternalResource.loadString("listIDs and listRatio", "ArgumentInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = new int[listIDs.size()];
        int[] nArray2 = new int[listIDs.size()];
        for (int i = 0; i < listIDs.size(); ++i) {
            SkeletonID skeletonID = listIDs.get(i);
            nArray[i] = skeletonID.getLODIndex();
            nArray2[i] = skeletonID.getSkeletonIndex();
        }
        bl = ModelBuilder3DNative.jni_Simplify(l, l2, nArray, nArray2, listRatio, bConstrainBorder);
        return bl;
    }

    public static boolean simplify(Model modelSrc, Model modelResult, ArrayList<SkeletonID> listIDs, double[] listRatio, double[] listThreshold) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listIDs == null) {
            String string = InternalResource.loadString("listIDs", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listRatio == null) {
            String string = InternalResource.loadString("listRatio", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (listIDs.size() != listRatio.length) {
            String string = InternalResource.loadString("listIDs and listRatio", "ArgumentInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = new int[listIDs.size()];
        int[] nArray2 = new int[listIDs.size()];
        for (int i = 0; i < listIDs.size(); ++i) {
            SkeletonID skeletonID = listIDs.get(i);
            nArray[i] = skeletonID.getLODIndex();
            nArray2[i] = skeletonID.getSkeletonIndex();
        }
        bl = ModelBuilder3DNative.jni_Simplify(l, l2, nArray, nArray2, listRatio, listThreshold);
        return bl;
    }

    public static int split(Model modelSrc, Model modelResult) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = ModelBuilder3DNative.jni_Split(l, l2);
        return n;
    }

    public static boolean splitSkeleton(Model modelSrc, Model modelResult, boolean bVertexPositionConsidered) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = ModelBuilder3DNative.jni_SplitSkeleton(l, l2, bVertexPositionConsidered);
        return bl;
    }

    public static GeoModel3D straightSkeleton(Geometry geometry, boolean bLonLat, double dAngle) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelBuilder3DNative.jni_IsSupported(l, 7);
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GlobalUnsupportedType", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = ModelBuilder3DNative.jni_StraightSkeleton(l, bLonLat, dAngle);
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public static boolean uvwMap(GeoModel3D model, TextureMapParameter texParam) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (texParam != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)texParam);
        }
        boolean bl = false;
        bl = ModelBuilder3DNative.jni_UVWMap(l, l2);
        return bl;
    }

    public static ArrayList<SunlightAnalysisPointResult> sunlightAnalysis(Geometry3D geometry, GeoModel3D geoModelDes, SunlightAnalysisSetting param, boolean bLatLon) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == geoModelDes) {
            String string = InternalResource.loadString("geoModelDes", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModelDes);
        if (0L == l2) {
            String string = InternalResource.loadString("geoModelDes", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == param) {
            String string = InternalResource.loadString("param", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)param);
        int[] nArray = new int[1];
        long l4 = ModelBuilder3DNative.jni_ShadowQuery(l, l2, l3, bLatLon, nArray);
        ArrayList<SunlightAnalysisPointResult> arrayList = new ArrayList<SunlightAnalysisPointResult>();
        int n = nArray[0];
        if (n > 0) {
            double[] dArray = new double[n];
            Object[] objectArray = new Object[n];
            Object[] objectArray2 = new Object[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            double[] dArray4 = new double[n];
            ModelBuilder3DNative.jni_GetShadowQueryPointResult(l4, dArray, objectArray, objectArray2, dArray2, dArray3, dArray4);
            for (int i = 0; i < n; ++i) {
                Map<Calendar, Calendar> map = ModelBuilder3D.getCalendarMap(objectArray[i], objectArray2[i]);
                Point3D point3D = new Point3D(dArray2[i], dArray3[i], dArray4[i]);
                arrayList.add(new SunlightAnalysisPointResult(dArray[i], point3D, map));
            }
        }
        return arrayList;
    }

    public static ArrayList<SunlightAnalysisPointResult> sunlightAnalysis(Point3Ds ptList, SunlightAnalysisSetting param, boolean bLatLon) {
        int n = ptList.getCount();
        if (null == ptList || ptList.getCount() == 0) {
            String string = InternalResource.loadString("ptList", "ArgumentInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == param) {
            String string = InternalResource.loadString("param", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)param);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = ptList.getItem(i).getX();
            dArray2[i] = ptList.getItem(i).getY();
            dArray3[i] = ptList.getItem(i).getZ();
        }
        int[] nArray = new int[1];
        long l2 = ModelBuilder3DNative.jni_ShadowQuery2(dArray, dArray2, dArray3, l, bLatLon, nArray);
        ArrayList<SunlightAnalysisPointResult> arrayList = new ArrayList<SunlightAnalysisPointResult>();
        int n2 = nArray[0];
        if (n2 > 0) {
            double[] dArray4 = new double[n2];
            Object[] objectArray = new Object[n2];
            Object[] objectArray2 = new Object[n2];
            double[] dArray5 = new double[n2];
            double[] dArray6 = new double[n2];
            double[] dArray7 = new double[n2];
            ModelBuilder3DNative.jni_GetShadowQueryPointResult(l2, dArray4, objectArray, objectArray2, dArray5, dArray6, dArray7);
            for (int i = 0; i < n2; ++i) {
                Map<Calendar, Calendar> map = ModelBuilder3D.getCalendarMap(objectArray[i], objectArray2[i]);
                Point3D point3D = new Point3D(dArray5[i], dArray6[i], dArray7[i]);
                arrayList.add(new SunlightAnalysisPointResult(dArray4[i], point3D, map));
            }
        }
        return arrayList;
    }

    public static int split(Model modelSrc, Model modelResult, double dThreshold) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_Split2(l, l2, dThreshold);
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ModelBuilder3D";
        boolean bl = InternalToolkitThreeDDesigner.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        ModelBuilder3D.fireStepped(steppedEvent);
        InternalToolkitThreeDDesigner.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    private static Calendar dateTimeStringToCalendar(String dateTime) {
        String[] stringArray = dateTime.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        return new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
    }

    private static Map<Calendar, Calendar> getCalendarMap(Object startTimes, Object endTimes) {
        HashMap<Calendar, Calendar> hashMap = new HashMap<Calendar, Calendar>();
        String[] stringArray = (String[])startTimes;
        String[] stringArray2 = (String[])endTimes;
        for (int i = 0; i < stringArray.length; ++i) {
            Calendar calendar = ModelBuilder3D.dateTimeStringToCalendar(stringArray[i]);
            Calendar calendar2 = ModelBuilder3D.dateTimeStringToCalendar(stringArray2[i]);
            hashMap.put(calendar, calendar2);
        }
        return hashMap;
    }

    public static GeoModel3D skylineSectorBody(GeoLine3D line3D, Point3D pntViewer, double dHeight, boolean bLatLon) {
        if (null == line3D) {
            String string = InternalResource.loadString("line3D", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)line3D);
        if (0L == l) {
            String string = InternalResource.loadString("line3D", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = ModelBuilder3DNative.jni_SkylineSectorBody(l, pntViewer.getX(), pntViewer.getY(), pntViewer.getZ(), dHeight, bLatLon);
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public static GeoModel3D viewShedBody(ArrayList<Point3Ds> point3Dlist, Point3D pntViewer, double dRadius, ViewShedType type, boolean bLatLon) {
        if (point3Dlist == null) {
            String string = InternalResource.loadString("point3Dlist", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = point3Dlist.size();
        int n2 = point3Dlist.get(0).getCount();
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n * n2];
        double[] dArray3 = new double[n * n2];
        for (int i = 0; i < point3Dlist.size(); ++i) {
            Point3Ds point3Ds = point3Dlist.get(i);
            for (int j = 0; j < point3Ds.getCount(); ++j) {
                Point3D point3D = point3Ds.getItem(j);
                dArray[i * n2 + j] = point3D.getX();
                dArray2[i * n2 + j] = point3D.getY();
                dArray3[i * n2 + j] = point3D.getZ();
            }
        }
        GeoModel3D geoModel3D = null;
        long l = ModelBuilder3DNative.jni_ViewShedBody(dArray, dArray2, dArray3, n, pntViewer.getX(), pntViewer.getY(), pntViewer.getZ(), dRadius, type.value(), bLatLon);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    @Deprecated
    public static GeoModel3D clip(GeoModel3D model, GeoRegion3D clipPlane, ModelClipType type) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == clipPlane) {
            String string = InternalResource.loadString("clipPlane", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipPlane);
        if (0L == l2) {
            String string = InternalResource.loadString("clipPlane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3D geoModel3D = null;
        long l3 = ModelBuilder3DNative.jni_Clip(l, l2, type.value());
        if (l3 != 0L) {
            geoModel3D = new GeoModel3D(model);
            geoModel3D.setModel(InternalModel.createInstance(l3));
        }
        return geoModel3D;
    }

    public static boolean clip(GeoModel3D model, ArrayList<Geometry> clipRegionList, ClippingType clippingType, ConstraintType constraintType) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipRegionList == null || clipRegionList.size() == 0) {
            return false;
        }
        long[] lArray = new long[clipRegionList.size()];
        for (int i = 0; i < clipRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegionList.get(i));
        }
        return ModelBuilder3DNative.jni_Clip2(l, lArray, clippingType.value(), constraintType.value());
    }

    public static Geometry createBuffer(Geometry geometry, boolean isLonLat, BufferParameter parameter) {
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (0L == l) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == parameter) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ModelBuilder3DNative.jni_CreateBuffer(l, isLonLat, parameter.m_dOffset, parameter.m_eJoinType.value());
        Geometry geometry2 = null;
        if (l2 != 0L) {
            geometry2 = InternalGeometry.createInstance(l2);
        }
        return geometry2;
    }

    public static boolean mergeSkeleton(Model modelSrc, Model modelResult, boolean bHasLOD) {
        if (null == modelSrc) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelSrc);
        if (0L == l) {
            String string = InternalResource.loadString("modelSrc", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == modelResult) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelResult);
        if (0L == l2) {
            String string = InternalResource.loadString("modelResult", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_MergeSkeleton(l, l2, bHasLOD);
    }

    public static boolean extractAttributeVoxelGrid(DatasetVector datasetVectorSrc, DatasetVolume datasetVolume, Datasource targetDatasourceDes, String strDatasetName, ColorDictionary colorDictTable, double subdivisionThreshold) {
        long l = 0L;
        if (colorDictTable != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictTable);
        }
        if (datasetVectorSrc == null) {
            String string = InternalResource.loadString("datasetVectorSrc", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorSrc);
        if (datasetVolume == null) {
            String string = InternalResource.loadString("datasetVolume", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVolume);
        if (targetDatasourceDes == null) {
            String string = InternalResource.loadString("targetDatasourceDes", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasourceDes);
        boolean bl = false;
        long l5 = ModelBuilder3DNative.jni_ExtractAttributeVoxelGrid(l2, l3, l4, strDatasetName, l, subdivisionThreshold);
        if (l5 != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l5, targetDatasourceDes);
            InternalDatasets.add(targetDatasourceDes.getDatasets(), (Dataset)datasetVector);
            bl = true;
        }
        return bl;
    }

    public static boolean removeDuplicateTriangle(Skeleton skeleton) {
        if (skeleton == null) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)skeleton);
        if (0L == l) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_RemoveDuplicateTriangle(l);
    }

    public static boolean correctTopology(Skeleton skeleton) {
        if (skeleton == null) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)skeleton);
        if (0L == l) {
            String string = InternalResource.loadString("skeleton", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_CorrectTopology(l);
    }

    private static boolean isWindows() {
        boolean bl = false;
        String string = System.getProperties().getProperty("os.name");
        if (string.startsWith("Windows")) {
            bl = true;
        }
        return bl;
    }

    public static boolean mirror(GeoModel3D model, Plane plane) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == plane) {
            String string = InternalResource.loadString("plane", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)plane);
        if (0L == l2) {
            String string = InternalResource.loadString("plane", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelBuilder3DNative.jni_Mirror(l, l2);
    }

    public static GeoTIM buildTIM(DatasetVector pDatasetVector, String strFieldName) {
        if (null == pDatasetVector) {
            String string = InternalResource.loadString("pDatasetVector", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pDatasetVector);
        if (0L == l) {
            String string = InternalResource.loadString("pDatasetVector", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        GeoTIM geoTIM = null;
        long l2 = ModelBuilder3DNative.jni_BuildTIM(l, strFieldName);
        if (l2 != 0L) {
            geoTIM = (GeoTIM)InternalGeometry.createInstance(l2);
        }
        return geoTIM;
    }

    public static GeoTIM buildTIM(HashMap<Point3D, Double> dicPoints, boolean bLatLon) {
        long l;
        GeoTIM geoTIM = null;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        if (dicPoints != null) {
            int n = dicPoints.size();
            dArray = new double[n];
            dArray2 = new double[n];
            dArray3 = new double[n];
            dArray4 = new double[n];
            Set<Map.Entry<Point3D, Double>> set = dicPoints.entrySet();
            Iterator<Map.Entry<Point3D, Double>> iterator = set.iterator();
            Map.Entry<Point3D, Double> entry = null;
            for (int i = 0; i < n; ++i) {
                entry = iterator.next();
                dArray[i] = entry.getKey().getX();
                dArray2[i] = entry.getKey().getY();
                dArray3[i] = entry.getKey().getZ();
                dArray4[i] = entry.getValue();
            }
        }
        if ((l = ModelBuilder3DNative.jni_BuildTIM(dArray, dArray2, dArray3, dArray4, bLatLon)) != 0L) {
            geoTIM = (GeoTIM)InternalGeometry.createInstance(l);
        }
        return geoTIM;
    }

    public static boolean mosaic(GeoModel3D model, ArrayList<Geometry> mosaicRegionList) {
        if (mosaicRegionList.size() == 0) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        long[] lArray = new long[mosaicRegionList.size()];
        for (int i = 0; i < mosaicRegionList.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)mosaicRegionList.get(i));
        }
        return ModelBuilder3DNative.jni_Mosaic(l, lArray);
    }

    public static boolean correctNonManifold(Skeleton skeleton, ArrayList<HashMap<Point3D, Point3D>> manifoldLines, ArrayList<Point3D> points) {
        Point3D point3D;
        int n;
        if (skeleton == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)skeleton);
        String[] stringArray = ModelBuilder3DNative.jni_CorrectNonManifold(l);
        if (stringArray[0].equals("FALSE")) {
            return false;
        }
        if (manifoldLines == null && points == null) {
            return true;
        }
        String[] stringArray2 = stringArray[1].split(",");
        String[] stringArray3 = stringArray[2].split(",");
        if (stringArray2.length > 2) {
            for (n = 0; n < stringArray2.length / 6; ++n) {
                point3D = new HashMap();
                Point3D point3D2 = new Point3D(Double.valueOf(stringArray2[6 * n]).doubleValue(), Double.valueOf(stringArray2[6 * n + 1]).doubleValue(), Double.valueOf(stringArray2[6 * n + 2]).doubleValue());
                Point3D point3D3 = new Point3D(Double.valueOf(stringArray2[6 * n + 3]).doubleValue(), Double.valueOf(stringArray2[6 * n + 4]).doubleValue(), Double.valueOf(stringArray2[6 * n + 5]).doubleValue());
                point3D.put(point3D2, point3D3);
                if (manifoldLines == null) continue;
                manifoldLines.add((HashMap<Point3D, Point3D>)point3D);
            }
        }
        if (stringArray3.length > 2) {
            for (n = 0; n < stringArray3.length / 3; ++n) {
                point3D = new Point3D(Double.valueOf(stringArray3[3 * n]).doubleValue(), Double.valueOf(stringArray3[3 * n + 1]).doubleValue(), Double.valueOf(stringArray3[3 * n + 2]).doubleValue());
                if (points == null) continue;
                points.add(point3D);
            }
        }
        return true;
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

