/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoStyle3D;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Theme3DUnique;
import com.supermap.realspace.ThemeUnique3DNative;

public class Theme3DUniqueItem {
    private String m_unique;
    private boolean m_isVisible;
    private boolean m_modellingStyleEnable;
    private String m_caption;
    private GeoStyle3D m_style;
    private Theme3DUnique m_themeUnique;
    private boolean isUserThemeUnique;

    public Theme3DUniqueItem() {
        this("", new GeoStyle3D(), "UntitledThemeUniqueItem");
        this.m_isVisible = true;
        this.m_modellingStyleEnable = false;
    }

    public Theme3DUniqueItem(String unique, GeoStyle3D style) {
        this(unique, style, "UntitledThemeUniqueItem");
    }

    public Theme3DUniqueItem(String unique, GeoStyle3D style, String caption) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (unique == null) {
            unique = "";
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_unique = unique;
        this.m_caption = caption;
        GeoStyle3D geoStyle3D = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle3D, false);
        this.m_style = geoStyle3D;
        this.isUserThemeUnique = false;
        this.setVisible(true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public Theme3DUniqueItem(Theme3DUniqueItem themeUnique3DItem) {
        this(themeUnique3DItem.getUnique(), themeUnique3DItem.getStyle(), themeUnique3DItem.getCaption());
    }

    Theme3DUniqueItem(Theme3DUnique themeUnique) {
        this.m_themeUnique = themeUnique;
        this.isUserThemeUnique = true;
    }

    public String getUnique() {
        String string = null;
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeUnique3DNative.jni_GetUniqueAt(l, n);
        } else {
            string = this.m_unique == null ? "" : this.m_unique;
        }
        return string;
    }

    public void setUnique(String value) {
        if (value == null) {
            value = "";
        }
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setUnique(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setUnique(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = ThemeUnique3DNative.jni_IsExist(l, value);
            if (bl) {
                String string = InternalResource.loadString("value", "ThemeUniqueItem3D_TheUniqueIsExist", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeUnique3DNative.jni_SetUniqueAt(l, n, value);
        }
        this.m_unique = value;
    }

    public boolean isVisible() {
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_isVisible = ThemeUnique3DNative.jni_GetIsVisible(l, n);
        }
        return this.m_isVisible;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeUnique3DNative.jni_SetIsVisible(l, n, value);
        }
        this.m_isVisible = value;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeUnique3DNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeUnique3DNative.jni_SetCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public GeoStyle3D getStyle() {
        if (this.isUserThemeUnique) {
            long l;
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_style == null && (l = ThemeUnique3DNative.jni_GetStyleAt(l2, n)) != 0L) {
                this.m_style = InternalGeoStyle3D.createInstance(l);
            }
        }
        return this.m_style;
    }

    public void setStyle(GeoStyle3D style) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeUnique) {
            n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStyle(GeoStyle3D style)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle3D style)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3D geoStyle3D = style.clone();
        long l3 = 0L;
        if (this.isUserThemeUnique) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
            ThemeUnique3DNative.jni_SetStyleAt(l, n, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle3D, false);
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
            if (this.m_style == null) {
                this.m_style = geoStyle3D;
            } else {
                InternalGeoStyle3D.changeHandle(this.m_style, l3);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
    }

    public boolean isModellingStyleEnable() {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeUnique) {
            n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("isModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("isModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            return ThemeUnique3DNative.jni_IsModellingStyleEnabled(l, n);
        }
        return this.m_modellingStyleEnable;
    }

    public void setModellingStyleEnable(boolean bValue) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeUnique) {
            n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeUnique3DNative.jni_SetModellingStyleEnabled(l, n, bValue);
        }
        this.m_modellingStyleEnable = bValue;
    }

    public String toString() {
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption =");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Unique = ");
        stringBuffer.append(this.getUnique());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Style = ");
        stringBuffer.append(this.getStyle().toString());
        stringBuffer.append("}");
        String string = new String(stringBuffer);
        return string;
    }

    void clearHandle() {
        if (this.m_style != null) {
            InternalGeoStyle3D.clearHandle(this.m_style);
            this.m_style = null;
        }
        this.m_themeUnique = null;
    }
}

