/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.SpliterRatioChangedEvent;
import com.supermap.realspace.SpliterRatioChangedListener;
import com.supermap.realspace.SplitterNative;
import com.supermap.realspace.SplitterOrientation;
import java.util.Vector;

public class Splitter
extends InternalHandle {
    transient Vector<SpliterRatioChangedListener> m_ratioChangedListeners;

    public Splitter(Scene scene, String name) {
        long l = SceneNative.jni_AddSplitter(InternalHandle.getHandle((com.supermap.data.InternalHandle)scene), name);
        this.setHandle(l);
        SplitterNative.jni_NewSelfEventHandle(this.getHandle(), this);
    }

    static void ratioChangedCallBack(Splitter splitter, float ratio) {
        if (splitter.getHandle() == 0L) {
            String string = InternalResource.loadString("Splitter", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SpliterRatioChangedEvent spliterRatioChangedEvent = new SpliterRatioChangedEvent((Object)splitter, ratio);
        splitter.fireRatioChanged(spliterRatioChangedEvent);
    }

    private void fireRatioChanged(SpliterRatioChangedEvent event) {
        if (this.m_ratioChangedListeners != null) {
            Vector<SpliterRatioChangedListener> vector = this.m_ratioChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).ratioChanged(event);
            }
        }
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SplitterNative.jni_IsVisible(this.getHandle());
    }

    public void setVisible(boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SplitterNative.jni_SetVisible(this.getHandle(), visible);
    }

    public float getSplitRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSplitRatio()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SplitterNative.jni_GetSplitRatio(this.getHandle());
    }

    public void setSplitRatio(float ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSplitRatio()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SplitterNative.jni_SetSplitRatio(this.getHandle(), ratio);
    }

    public void setOrientation(SplitterOrientation orientation) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrientation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(orientation);
        SplitterNative.jni_SetOrientation(this.getHandle(), n);
    }

    public SplitterOrientation getOrientation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOrientation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SplitterNative.jni_getOrientation(this.getHandle());
        return (SplitterOrientation)InternalEnum.parseUGCValue(SplitterOrientation.class, n);
    }

    public synchronized void addRatioChangedListener(SpliterRatioChangedListener l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRatioChangedListener()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_ratioChangedListeners == null) {
            this.m_ratioChangedListeners = new Vector();
        }
        if (!this.m_ratioChangedListeners.contains(l)) {
            this.m_ratioChangedListeners.add(l);
        }
    }

    public synchronized void removeRatioChangedListener(SpliterRatioChangedListener l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRatioChangedListener()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_ratioChangedListeners != null && this.m_ratioChangedListeners.contains(l)) {
            this.m_ratioChangedListeners.remove(l);
        }
    }
}

