/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.iobjects.process.ml.inference;

import java.io.File;
import java.util.Map;

final class MLToolkits {
    MLToolkits() {
    }

    static String getStrInputData(String inputDatapath, String inputDatasetName) {
        String[] inputDataPathSplit = inputDatapath.split("\\.");
        String inputDataFormat = inputDataPathSplit[inputDataPathSplit.length - 1].toUpperCase();
        if (inputDataFormat.equals("UDB") || inputDataFormat.equals("UDBX")) {
            return inputDatapath + File.separator + inputDatasetName;
        }
        return inputDatapath;
    }

    static String getPyClassName(String pyFileName) {
        String[] pyFileNameSplit = pyFileName.split("_");
        StringBuilder pyClassNameBuilder = null;
        for (int i = 0; i < pyFileNameSplit.length; ++i) {
            String body = pyFileNameSplit[i].substring(0, 1).toUpperCase() + pyFileNameSplit[i].substring(1);
            if (i == 0) {
                pyClassNameBuilder = new StringBuilder(body);
                continue;
            }
            pyClassNameBuilder.append(body);
        }
        return pyClassNameBuilder.toString();
    }

    static File getOperatorPyFile(String pyFileName) {
        String mlHome = System.getenv("IOPY_HOME");
        String operatorPyPath = mlHome + File.separator + "resources_ml" + File.separator + "process_operator" + File.separator + pyFileName + ".py";
        System.out.println(String.format("Python operator load from: %s", operatorPyPath));
        return new File(operatorPyPath);
    }

    static void getPythonError(Map<String, Object> result) {
        Object error = result.get("error");
        if (error != null) {
            System.out.println(String.format("Python operator error:\n%s", error.toString()));
        } else {
            System.out.println("Python operator has finished!");
        }
    }
}

