/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.VRPAnalystInfoNative;
import com.supermap.data.Point2D;
import java.util.Calendar;
import java.util.Date;

public class VehicleInfo {
    private long m_handle;
    private int m_ID;
    private double m_dLoadWeight;
    private double m_dCost;
    private boolean m_bSetSE;
    private Point2D m_pntSE;
    private int m_nSEID;
    private Date m_startTime;
    private Date m_endTime;
    private boolean m_bSetTime;
    private double[] m_arrLoadWeight;
    private double m_dAreaRatio;
    private double[] m_arrMinLoad;
    private double m_dPriority;

    public VehicleInfo() {
        this.m_dLoadWeight = -1.0;
        this.m_dCost = Double.MAX_VALUE;
        this.m_ID = -1;
        this.m_bSetSE = false;
        this.m_nSEID = -1;
        this.m_pntSE = new Point2D(0.0, 0.0);
        this.m_startTime = null;
        this.m_endTime = null;
        this.m_bSetTime = false;
        this.m_arrLoadWeight = null;
        this.m_dAreaRatio = 0.25;
        this.m_arrMinLoad = null;
        this.m_dPriority = 1.0;
    }

    public VehicleInfo(VehicleInfo info) {
        int n;
        this.m_dLoadWeight = info.m_dLoadWeight;
        this.m_dCost = info.m_dCost;
        this.m_ID = info.m_ID;
        this.m_bSetSE = info.m_bSetSE;
        this.m_nSEID = info.m_nSEID;
        this.m_pntSE = info.m_pntSE;
        this.m_startTime = info.m_startTime;
        this.m_endTime = info.m_endTime;
        this.m_bSetTime = info.m_bSetTime;
        this.m_arrLoadWeight = new double[info.m_arrLoadWeight.length];
        for (n = 0; n < info.m_arrLoadWeight.length; ++n) {
            this.m_arrLoadWeight[n] = info.m_arrLoadWeight[n];
        }
        this.m_dAreaRatio = info.m_dAreaRatio;
        if (info.m_arrMinLoad != null) {
            for (n = 0; n < info.m_arrMinLoad.length; ++n) {
                this.m_arrMinLoad[n] = info.m_arrMinLoad[n];
            }
        }
        this.m_dPriority = info.m_dPriority;
    }

    protected long getHandle() {
        Object object;
        int n = 0;
        int n2 = 0;
        if (this.m_startTime != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.m_startTime);
            n = ((Calendar)object).get(11) * 60 + ((Calendar)object).get(12);
        }
        if (this.m_endTime != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.m_endTime);
            n2 = ((Calendar)object).get(11) * 60 + ((Calendar)object).get(12);
        }
        if (this.m_bSetTime && n2 <= n) {
            object = InternalResource.loadString("VehicleInfo.Time", "EndTimeMustLargerThanStartTime", "networkanalyst_resources");
            throw new IllegalArgumentException((String)object);
        }
        this.m_handle = VRPAnalystInfoNative.jni_SetVehicleInfo(this.m_ID, this.m_arrLoadWeight, this.m_dCost, this.m_bSetSE, this.m_pntSE.getX(), this.m_pntSE.getY(), this.m_nSEID, n, n2, this.m_bSetTime, this.m_dAreaRatio, this.m_arrMinLoad, this.m_dPriority);
        return this.m_handle;
    }

    protected void setSE(boolean bSetSE) {
        this.m_bSetSE = bSetSE;
    }

    protected boolean getSE() {
        return this.m_bSetSE;
    }

    public int getVehicleID() {
        return this.m_ID;
    }

    public void setVehicleID(int value) {
        this.m_ID = value;
    }

    @Deprecated
    public double getLoadWeight() {
        return this.m_arrLoadWeight[0];
    }

    @Deprecated
    public void setLoadWeight(double value) {
        this.m_arrLoadWeight = new double[1];
        this.m_arrLoadWeight[0] = value;
    }

    public double[] getLoadWeights() {
        return this.m_arrLoadWeight;
    }

    public void setLoadWeights(double[] value) {
        this.m_arrLoadWeight = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.m_arrLoadWeight[i] = value[i];
        }
    }

    protected double[] getMinLoad() {
        return this.m_arrMinLoad;
    }

    protected void setMinLoad(double[] value) {
        this.m_arrMinLoad = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.m_arrMinLoad[i] = value[i];
        }
    }

    public double getCost() {
        return this.m_dCost;
    }

    public void setCost(double value) {
        if (value <= 0.0) {
            String string = InternalResource.loadString("Cost", "CostShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dCost = value;
    }

    public Point2D getSEPoint() {
        return this.m_pntSE;
    }

    public void setSEPoint(Point2D value) {
        this.m_pntSE = value;
        this.m_bSetSE = true;
    }

    public int getSEID() {
        return this.m_nSEID;
    }

    public void setSEID(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("SEID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSEID = value;
        this.m_bSetSE = true;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Date time) {
        this.m_startTime = time;
        this.m_bSetTime = true;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Date time) {
        this.m_endTime = time;
        this.m_bSetTime = true;
    }

    protected boolean isSetTime() {
        return this.m_bSetTime;
    }

    public double getAreaRatio() {
        return this.m_dAreaRatio;
    }

    public void setAreaRatio(double value) {
        this.m_dAreaRatio = value;
    }

    public double getPriority() {
        return this.m_dPriority;
    }

    public void setPriority(double value) {
        this.m_dPriority = value;
    }
}

