/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathInfo;
import com.supermap.analyst.networkanalyst.SSCPathAnalystNative;
import com.supermap.analyst.networkanalyst.SSCPathAnalystParameter;
import com.supermap.analyst.networkanalyst.SSCPathAnalystSetting;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Toolkit;

public class SSCPathAnalyst
extends InternalHandleDisposable {
    protected boolean m_bConnect = false;
    protected boolean m_bFind = false;
    private SSCPathAnalystSetting m_setting = null;

    public void dispose() {
        if (this.getHandle() != 0L) {
            SSCPathAnalystNative.jni_DeleteCH(this.getHandle());
            this.setHandle(0L);
        }
    }

    public void setAnalystSetting(SSCPathAnalystSetting setting) {
        if (setting == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)setting) == 0L) {
            String string = InternalResource.loadString("setting", "SSCPathAnalystSettingInitialized", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() != 0L) {
            SSCPathAnalystNative.jni_DeleteCH(this.getHandle());
            this.setHandle(0L);
        }
        this.m_bConnect = setting.load();
        if (!this.m_bConnect) {
            throw new RuntimeException(Toolkit.getLastError());
        }
        this.m_setting = setting;
        this.setHandle(SSCPathAnalystNative.jni_NewCH(InternalHandle.getHandle((com.supermap.data.InternalHandle)setting)), true);
    }

    public SSCPathAnalystSetting getAnalystSetting() {
        return this.m_setting;
    }

    public boolean findPath(SSCPathAnalystParameter parameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_bConnect && parameter.getStartPoint() != null && parameter.getEndPoint() != null) {
            int n;
            int n2 = 0;
            Point2Ds point2Ds = parameter.getMidpoints();
            if (point2Ds != null) {
                n2 = point2Ds.getCount();
            }
            Point2D point2D = parameter.getStartPoint();
            Point2D point2D2 = parameter.getEndPoint();
            double[] dArray = new double[n2 + 2];
            double[] dArray2 = new double[n2 + 2];
            dArray[0] = point2D.getX();
            dArray2[0] = point2D.getY();
            dArray[n2 + 1] = point2D2.getX();
            dArray2[n2 + 1] = point2D2.getY();
            for (n = 0; n < n2; ++n) {
                dArray[n + 1] = point2Ds.getItem(n).getX();
                dArray2[n + 1] = point2Ds.getItem(n).getY();
            }
            n = SSCPathAnalystNative.jni_PlanCH(this.getHandle(), dArray, dArray2, parameter.getRouteType().value(), parameter.isAlternative(), parameter.getRatio1(), parameter.getRatio2(), parameter.getRatio3()) ? 1 : 0;
            if (n != 0) {
                this.m_bFind = true;
                return true;
            }
        } else {
            if (!this.m_bConnect) {
                String string = InternalResource.loadString("connectData", "Global_ArgumentNull", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (parameter.getStartPoint() == null || parameter.getEndPoint() == null) {
                String string = InternalResource.loadString("StartPoint or EndPoint", "Global_ArgumentNull", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        return false;
    }

    boolean isAlternative() {
        if (this.getHandle() != 0L) {
            return SSCPathAnalystNative.jni_IsAlternative(this.getHandle());
        }
        return false;
    }

    public Point2Ds getPathPoints() {
        Point2Ds point2Ds = new Point2Ds();
        if (this.getHandle() != 0L && this.m_bFind) {
            double[] dArray = SSCPathAnalystNative.jni_GetPathPointCH(this.getHandle());
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D();
                point2D.setX(dArray[i++]);
                point2D.setY(dArray[i]);
                point2Ds.add(point2D);
            }
        }
        return point2Ds;
    }

    public double getPathLength() {
        double d = 0.0;
        if (this.getHandle() != 0L && this.m_bFind) {
            d = SSCPathAnalystNative.jni_GetPathLengthCH(this.getHandle());
        }
        return d;
    }

    public PathInfo[] getPathInfos() {
        PathInfo[] pathInfoArray = null;
        if (this.getHandle() != 0L && this.m_bFind) {
            long[] lArray = SSCPathAnalystNative.jni_GetPathInfosCH(this.getHandle());
            pathInfoArray = new PathInfo[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                PathInfo pathInfo;
                pathInfoArray[i] = pathInfo = new PathInfo(lArray[i]);
            }
        }
        return pathInfoArray;
    }

    public double getPathTime() {
        double d = 0.0;
        if (this.getHandle() != 0L) {
            d = SSCPathAnalystNative.jni_GetPathTimeCH(this.getHandle());
        }
        return d;
    }

    public Point2Ds getAlternativePathPoints() {
        Point2Ds point2Ds = new Point2Ds();
        if (this.getHandle() != 0L && this.m_bFind && this.isAlternative()) {
            double[] dArray = SSCPathAnalystNative.jni_GetAltPathPointCH(this.getHandle());
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D();
                point2D.setX(dArray[i++]);
                point2D.setY(dArray[i]);
                point2Ds.add(point2D);
            }
        }
        return point2Ds;
    }

    public double getAlternativePathLength() {
        double d = 0.0;
        if (this.getHandle() != 0L && this.m_bFind && this.isAlternative()) {
            d = SSCPathAnalystNative.jni_GetAltPathLengthCH(this.getHandle());
        }
        return d;
    }

    public PathInfo[] getAlternativePathInfos() {
        long[] lArray;
        PathInfo[] pathInfoArray = null;
        if (this.getHandle() != 0L && this.m_bFind && this.isAlternative() && (lArray = SSCPathAnalystNative.jni_GetAltPathInfosCH(this.getHandle())).length > 0) {
            pathInfoArray = new PathInfo[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                PathInfo pathInfo;
                pathInfoArray[i] = pathInfo = new PathInfo(lArray[i]);
            }
        }
        return pathInfoArray;
    }

    public double getAlternativePathTime() {
        double d = 0.0;
        if (this.getHandle() != 0L && this.m_bFind && this.isAlternative()) {
            d = SSCPathAnalystNative.jni_GetAltPathTimeCH(this.getHandle());
        }
        return d;
    }
}

