/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.benchmark;

import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.mapping.Map;
import com.supermap.mapping.benchmark.LogWriter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.CountDownLatch;

public class DefaultRunner
implements Runnable {
    public int timesPerThread;
    public Rectangle2D bounds;
    public String threadName;
    public String output = "./output";
    public Map map;
    public CountDownLatch finishedLatch;
    public String format;
    public int tileSize;

    public DefaultRunner(Workspace workspace, String mapName, int timesPerThread, Rectangle2D bounds, String threadName, String format, int tileSize, CountDownLatch finishedLatch) {
        this.timesPerThread = timesPerThread;
        this.bounds = bounds;
        this.threadName = threadName;
        this.tileSize = tileSize;
        this.finishedLatch = finishedLatch;
        this.format = format;
        this.initMap(workspace, mapName);
    }

    public void initMap(Workspace workspace, String mapName) {
        this.map = new Map(workspace);
        this.map.setImageSize(new Dimension(this.tileSize, this.tileSize));
        if (!this.map.open(mapName)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void run() {
        LogWriter logWriter = LogWriter.getInstance();
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.timesPerThread; ++i) {
            double d = this.bounds.getWidth() / (double)this.timesPerThread * (double)i + this.bounds.getLeft();
            double d2 = this.bounds.getHeight() / (double)this.timesPerThread * (double)i + this.bounds.getBottom();
            this.map.setCenter(new Point2D(d, d2));
            String string = this.output + "/" + this.threadName + i;
            long l2 = System.currentTimeMillis();
            if (this.format.equals("png")) {
                this.map.outputMapToPNG(string + ".png", true);
            } else if (this.format.equals("jpg")) {
                this.map.outputMapToJPG(string + ".jpg");
            } else {
                BufferedImage bufferedImage = this.map.outputMapToBitmap(true);
            }
            long l3 = System.currentTimeMillis() - l2;
            logWriter.writelog(String.format("%s x %f y %f scale %f output to %s cost %d", this.threadName, d, d2, this.map.getScale(), this.output, l3));
        }
        logWriter.writelog(this.threadName + " output finished, used " + (System.currentTimeMillis() - l) / (long)this.timesPerThread + " ms");
        logWriter.flush();
        this.finishedLatch.countDown();
    }
}

