/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.ThemeUnique;
import com.supermap.mapping.ThemeUniqueNative;

public class ThemeUniqueItem {
    private String m_unique = null;
    private boolean m_isVisible = true;
    private String m_caption = "UntitledThemeUniqueItem";
    private GeoStyle m_style = null;
    private ThemeUnique m_themeUnique = null;
    private boolean isUserThemeUnique = false;

    public ThemeUniqueItem() {
        GeoStyle geoStyle = new GeoStyle();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        this.isUserThemeUnique = false;
    }

    public ThemeUniqueItem(String unique, GeoStyle style) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (unique == null) {
            unique = "";
        }
        this.m_unique = unique;
        GeoStyle geoStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.isUserThemeUnique = false;
    }

    public ThemeUniqueItem(String unique, String caption, GeoStyle style) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (unique == null) {
            unique = "";
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_unique = unique;
        this.m_caption = caption;
        GeoStyle geoStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.isUserThemeUnique = false;
    }

    public ThemeUniqueItem(ThemeUniqueItem themeUniqueItem) {
        if (themeUniqueItem == null) {
            String string = InternalResource.loadString("themeUniqueItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeUniqueItem.isUserThemeUnique) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeUniqueItem.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("themeUniqueItem", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = themeUniqueItem.m_themeUnique.getUniqueItemsList().indexOf(themeUniqueItem);
            if (n == -1) {
                String string = InternalResource.loadString("themeUniqueItem", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        this.m_unique = themeUniqueItem.getUnique();
        this.m_isVisible = themeUniqueItem.isVisible();
        this.m_caption = themeUniqueItem.getCaption();
        GeoStyle geoStyle = themeUniqueItem.getStyle().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.isUserThemeUnique = false;
    }

    ThemeUniqueItem(ThemeUnique themeUnique) {
        this.m_themeUnique = themeUnique;
        this.isUserThemeUnique = true;
    }

    public String getUnique() {
        String string = null;
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeUniqueNative.jni_GetUniqueAt(l, n);
        } else {
            string = this.m_unique == null ? "" : this.m_unique;
        }
        return string;
    }

    public void setUnique(String value) {
        if (value == null) {
            value = "";
        }
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setUnique(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setUnique(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = ThemeUniqueNative.jni_IsExist(l, value);
            if (bl) {
                String string = InternalResource.loadString("value", "ThemeUniqueItem_TheUniqueIsExist", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeUniqueNative.jni_SetUniqueAt(l, n, value);
        }
        this.m_unique = value;
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            bl = ThemeUniqueNative.jni_GetIsVisible(l, n);
        } else {
            bl = this.m_isVisible;
        }
        return bl;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeUniqueNative.jni_SetIsVisible(l, n, value);
        }
        this.m_isVisible = value;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeUniqueNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeUniqueNative.jni_SetCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public GeoStyle getStyle() {
        if (this.isUserThemeUnique) {
            long l;
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_style == null && (l = ThemeUniqueNative.jni_GetStyleAt(l2, n)) != 0L) {
                this.m_style = InternalGeoStyle.createInstance(l);
            }
        }
        return this.m_style;
    }

    public void setStyle(GeoStyle style) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeUnique) {
            n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l3 = 0L;
        if (this.isUserThemeUnique) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
            ThemeUniqueNative.jni_SetStyleAt(l, n, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
            if (this.m_style == null) {
                this.m_style = geoStyle;
            } else {
                InternalGeoStyle.changeHandle(this.m_style, l3);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public String toString() {
        if (this.isUserThemeUnique) {
            int n = this.m_themeUnique.getUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption =");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Unique = ");
        stringBuffer.append(this.getUnique());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Style = ");
        stringBuffer.append(this.getStyle().toString());
        stringBuffer.append("}\n");
        String string = new String(stringBuffer);
        return string;
    }

    protected void finalize() {
        if (this.m_style != null && !this.isUserThemeUnique) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_style, true);
            this.m_style.dispose();
        }
    }

    void clearHandle() {
        if (this.m_style != null) {
            InternalGeoStyle.clearHandle(this.m_style);
            this.m_style = null;
        }
    }
}

