/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapPainter;
import com.supermap.mapping.Theme;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class MapPainterEx
extends MapPainter {
    private Dimension m_size;
    private Rectangle2D m_bounds;
    private BufferedImage m_bufferImage;

    MapPainterEx(Map map) {
        super(map, 0L);
        this.m_size = map.getImageSize();
        this.m_bounds = map.getViewBounds();
        this.m_prjCoordSys = map.getPrjCoordSys();
    }

    @Override
    public Graphics getGraphics() {
        if (this.m_graphics == null) {
            this.m_bufferImage = new BufferedImage(this.m_size.width, this.m_size.height, 6);
            this.m_graphics = this.m_bufferImage.getGraphics();
        }
        return this.m_graphics;
    }

    @Override
    public Image getImage() {
        return this.m_bufferImage;
    }

    @Override
    public Dimension getImageSize() {
        return this.m_size;
    }

    @Override
    public Rectangle2D getMapDrawingBounds() {
        return this.m_bounds;
    }

    @Override
    public PrjCoordSys getMapDrawingPrj() {
        return this.m_prjCoordSys;
    }

    @Override
    void realeaseGraphics() {
        if (this.m_graphics != null) {
            this.m_graphics.dispose();
            this.m_graphics = null;
        }
    }

    @Override
    public void drawGeometry(Geometry geometry) {
        throw new IllegalArgumentException();
    }

    @Override
    public void drawGeometry(Iterable<Geometry> geometries, GeoStyle style) {
    }

    @Override
    public void drawLabel(ArrayList<Geometry> geos, ArrayList<String> labels, Theme theme) {
    }

    @Override
    void copyBufferImageToUGC() {
    }

    @Override
    public void dispose() {
        this.clearHandle();
    }
}

