/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorDictionary;
import com.supermap.data.ColorSpaceType;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.mapping.ImageDisplayMode;
import com.supermap.mapping.ImageInterpolationMode;
import com.supermap.mapping.ImageStretchOption;
import com.supermap.mapping.InternalColors;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerMosaic;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.LayerType;
import com.supermap.mapping.Layers;
import java.awt.Color;

public class LayerSettingImage
extends LayerSetting {
    private Layer m_layer = null;
    private Layers m_layers = null;
    private boolean isUserLayer = false;
    private int m_opaqueRate = 100;
    private int m_contrast = 0;
    private int m_brightness = 0;
    private boolean m_isTransparentColorEnabled = false;
    private Color m_transparentColor = Color.black;
    private int[] m_displayBandIndexes;
    private ColorSpaceType m_colorSpaceType = ColorSpaceType.RGB;
    private String[] m_visibleSubLayers = null;
    private int m_transparentColorTolerance;
    private ImageStretchOption m_imageStretchOption = null;
    private ImageDisplayMode m_imageDisplayMode = ImageDisplayMode.STRETCHED;
    private Colors m_colorTable = null;
    private ImageInterpolationMode m_ImageInterpolationMode = ImageInterpolationMode.NEARESTNEIGHBOR;
    private Color m_specialValueColor = Color.white;
    private double m_specialValue = -9999.0;
    private boolean m_isSpecialValueTransparent = false;
    private boolean m_isSpecialValueReplace = false;
    private boolean m_isbackground = false;
    private double m_backgroundValue = 0.0;
    private Color m_backgroundColor = Color.white;
    private boolean m_backgroundTransparent = false;
    private ColorDictionary m_colorDict = null;

    public LayerSettingImage() {
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
        this.isUserLayer = false;
        this.m_colorDict = new ColorDictionary();
    }

    public LayerSettingImage(LayerSettingImage layerSettingImage) {
        long l;
        if (layerSettingImage == null) {
            String string = InternalResource.loadString("layerSettingImage", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerSettingImage.isUserLayer && (l = InternalHandle.getHandle(layerSettingImage.m_layer)) == 0L) {
            String string = InternalResource.loadString("layerSettingImage.Layer", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_brightness = layerSettingImage.getBrightness();
        this.m_contrast = layerSettingImage.getContrast();
        this.m_opaqueRate = layerSettingImage.getOpaqueRate();
        this.m_colorSpaceType = layerSettingImage.getDisplayColorSpace();
        this.m_displayBandIndexes = (int[])layerSettingImage.getDisplayBandIndexes().clone();
        this.m_transparentColorTolerance = layerSettingImage.getTransparentColorTolerance();
        this.m_imageStretchOption = layerSettingImage.getImageStretchOption();
        this.m_imageDisplayMode = layerSettingImage.getDisplayMode();
        Colors colors = new Colors(layerSettingImage.getColorTable());
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l2, false);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
        this.isUserLayer = false;
        this.m_colorDict = layerSettingImage.getColorDictionary();
    }

    LayerSettingImage(Layer layer, Layers layers) {
        this.m_layer = layer;
        this.m_layers = layers;
        this.isUserLayer = true;
        this.m_imageStretchOption = new ImageStretchOption(layer, layers);
        this.m_colorDict = new ColorDictionary();
    }

    public Colors getColorTable() {
        if (this.isUserLayer) {
            long l;
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_colorTable == null && (l = LayerNative.jni_GetColorTable(l2)) != 0L) {
                this.m_colorTable = InternalColors.createInstance(l, false);
            }
        }
        return this.m_colorTable;
    }

    public void setColorTable(Colors colorTable) {
        long l = 0L;
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (colorTable == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)colorTable) == 0L) {
            String string = InternalResource.loadString("colorTable", "LayerSettingGrid_InvalidColors", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors = new Colors(colorTable);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (this.isUserLayer) {
            LayerNative.jni_GetColorTable(l);
            LayerNative.jni_SetColorTable(l, l2);
        } else if (this.m_colorTable == null) {
            this.m_colorTable = InternalColors.createInstance(l2, false);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
            InternalColors.changeHandle(this.m_colorTable, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
    }

    public int getOpaqueRate() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getRasterOpaqueRate()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterOpaqueRate(l);
        }
        return this.m_opaqueRate;
    }

    public void setOpaqueRate(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setRasterOpaqueRate(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterOpaqueRate(l, value);
        }
        this.m_opaqueRate = value;
    }

    public int getContrast() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getContrast()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterContrast(l);
        }
        return this.m_contrast;
    }

    public void setContrast(int value) {
        if (value < -100 || value > 100) {
            String string = InternalResource.loadString("value", "LayerSettingImage_ContrastMustBeIn(-100~100)", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setContrast(byte value))", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterContrast(l, value);
        }
        this.m_contrast = value;
    }

    public int getBrightness() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBrightness()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterBrightness(l);
        }
        return this.m_brightness;
    }

    public void setBrightness(int value) {
        if (value < -100 || value > 100) {
            String string = InternalResource.loadString("value", "LayerSettingImage_BrightnessMustBeIn(-100~100)", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBrightness(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBrightness(l, value);
        }
        this.m_brightness = value;
    }

    @Deprecated
    public boolean isTransparent() {
        return this.isTransparentColorEnabled();
    }

    @Deprecated
    public void setTransparent(boolean value) {
        this.setTransparentColorEnabled(value);
    }

    public Color getTransparentColor() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetRasterBackTransparentColor(l);
            return new Color(n, true);
        }
        return this.m_transparentColor;
    }

    public void setTransparentColor(Color value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparentColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBackTransparentColor(l, value.getRGB());
        }
        this.m_transparentColor = new Color(value.getRGB(), true);
    }

    public int[] getDisplayBandIndexes() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayBandIndexes()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetDisplayBandIndexes(l);
        }
        return this.m_displayBandIndexes;
    }

    public void setDisplayBandIndexes(int[] bandIndexes) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (bandIndexes == null) {
                String string = InternalResource.loadString("", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = bandIndexes.length;
            if (this.m_layer.getSubLayerType() == LayerType.SUBLAYER_MOSAIC) {
                LayerMosaic layerMosaic = (LayerMosaic)this.m_layer;
                if (layerMosaic.getDatasetMosaic().getBandCount() <= 0) {
                    String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                    throw new IllegalStateException(string);
                }
            } else if (!(this.m_layer.getDataset() instanceof DatasetImage) || ((DatasetImage)this.m_layer.getDataset()).getBandCount() <= 1) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n2 = bandIndexes.length;
            ColorSpaceType colorSpaceType = this.getDisplayColorSpace();
            int n3 = colorSpaceType.value();
            LayerNative.jni_SetDisplayBandIndexes(l, bandIndexes);
        } else {
            this.m_displayBandIndexes = (int[])bandIndexes.clone();
        }
    }

    public ColorSpaceType getDisplayColorSpace() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayColorSpace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetDispalayColorSpaceType(l);
            return (ColorSpaceType)InternalEnum.parseUGCValue(ColorSpaceType.class, n);
        }
        return this.m_colorSpaceType;
    }

    public void setDisplayColorSpace(ColorSpaceType colorSpace) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayColorSpace(ColorSpaceType colorSpace)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_layer.getSubLayerType() == LayerType.SUBLAYER_MOSAIC) {
                LayerMosaic layerMosaic = (LayerMosaic)this.m_layer;
                if (layerMosaic.getDatasetMosaic().getBandCount() <= 0) {
                    String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                    throw new IllegalStateException(string);
                }
            } else if (!(this.m_layer.getDataset() instanceof DatasetImage) || ((DatasetImage)this.m_layer.getDataset()).getBandCount() <= 1) {
                String string = InternalResource.loadString("setDisplayColorSpace(ColorSpaceType colorSpace)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = 0;
            int n2 = colorSpace.value();
            switch (n2) {
                case 2: 
                case 4: {
                    n = 4;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n = 3;
                    break;
                }
            }
            int n3 = colorSpace.value();
            LayerNative.jni_SetDispalayColorSpaceType(l, n3);
            if (this.getDisplayBandIndexes() != null) {
                int[] nArray = this.getDisplayBandIndexes();
                if (nArray.length > n) {
                    int[] nArray2 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray2[i] = nArray[i];
                    }
                    this.setDisplayBandIndexes(nArray2);
                } else if (nArray.length < n) {
                    int[] nArray3 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray3[i] = i < nArray.length ? nArray[i] : (nArray.length > 1 ? nArray[nArray.length - 1] : 0);
                    }
                    this.setDisplayBandIndexes(nArray3);
                }
            }
        }
        this.m_colorSpaceType = colorSpace;
    }

    public ImageDisplayMode getDisplayMode() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayColorSpace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageDisplayMode(l);
            return (ImageDisplayMode)InternalEnum.parseUGCValue(ImageDisplayMode.class, n);
        }
        return this.m_imageDisplayMode;
    }

    public void setDisplayMode(ImageDisplayMode displayMode) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayMode(ImageDisplayMode displayMode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_layer.getSubLayerType() == LayerType.SUBLAYER_MOSAIC) {
                LayerMosaic layerMosaic = (LayerMosaic)this.m_layer;
                if (layerMosaic.getDatasetMosaic().getBandCount() <= 0) {
                    String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                    throw new IllegalStateException(string);
                }
            } else if (!(this.m_layer.getDataset() instanceof DatasetImage)) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = displayMode.value();
            LayerNative.jni_SetImageDisplayMode(l, n);
        }
        this.m_imageDisplayMode = displayMode;
    }

    public String[] getAllSubLayers() {
        String[] stringArray = null;
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = "";
            string = LayerNative.jni_getAllSubLayers(l);
            stringArray = string.split(",");
        }
        return stringArray;
    }

    public String[] getVisibleSubLayers() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = "";
            string = LayerNative.jni_getVisibleSubLayers(l);
            this.m_visibleSubLayers = string.split(",");
        }
        return this.m_visibleSubLayers;
    }

    public void setVisibleSubLayers(String[] subLayers) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = "";
            for (int i = 0; i < subLayers.length; ++i) {
                string = string + subLayers[i];
                string = string + ",";
            }
            LayerNative.jni_setVisibleSubLayers(l, string);
        }
        this.m_visibleSubLayers = subLayers;
    }

    @Override
    public LayerSettingType getType() {
        long l;
        if (this.isUserLayer && (l = InternalHandle.getHandle(this.m_layer)) == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerSettingType.IMAGE;
    }

    public int getTransparentColorTolerance() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetTransparentColorTolerance(l);
        }
        return this.m_transparentColorTolerance;
    }

    public void setTransparentColorTolerance(int value) {
        if (value < 0 || value > 255) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int value)", "LayerSettingImage_TransparentColorToleranceShouldBetween0And255", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setRasterOpaqueRate(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetTransparentColorTolerance(l, value);
        }
        this.m_transparentColorTolerance = value;
    }

    public ImageStretchOption getImageStretchOption() {
        if (this.isUserLayer) {
            Class<?> clazz;
            Dataset dataset;
            if (this.m_imageStretchOption == null && this.m_layer != null && this.m_layers != null && (dataset = this.m_layer.getDataset()) != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L && (clazz = dataset.getClass()).equals(DatasetImage.class)) {
                this.m_imageStretchOption = new ImageStretchOption(this.m_layer, this.m_layers);
            }
            return this.m_imageStretchOption;
        }
        if (this.m_imageStretchOption == null) {
            String string = InternalResource.loadString("getImageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_imageStretchOption;
    }

    public void setImageStretchOption(ImageStretchOption imageStretchOption) {
        if (this.m_layer == null || this.m_layers == null) {
            String string = InternalResource.loadString("setImageStretchOption(ImageStretchOption imageStretchOption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getImageStretchOption() == null) {
            String string = InternalResource.loadString("setImageStretchOption(ImageStretchOption imageStretchOption)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (imageStretchOption == null) {
            String string = InternalResource.loadString("imageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_imageStretchOption.setStretchType(imageStretchOption.getStretchType());
        this.m_imageStretchOption.setStandardDeviationStretchFactor(imageStretchOption.getStandardDeviationStretchFactor());
        this.m_imageStretchOption.setGaussianStretchRatioFactor(imageStretchOption.getGaussianStretchRatioFactor());
        this.m_imageStretchOption.setGaussianStretchMiddleFactor(imageStretchOption.isGaussianStretchMiddleFactor());
        this.m_imageStretchOption.setStandardHistograms(imageStretchOption.getStandardHistograms());
        this.m_imageStretchOption.setPercentClipStretchMaxPercent(imageStretchOption.getPercentClipStretchMaxPercent());
        this.m_imageStretchOption.setPercentClipStretchMinPercent(imageStretchOption.getPercentClipStretchMinPercent());
        this.m_imageStretchOption.setPercentClipRedBandMinValue(imageStretchOption.getPercentClipRedBandMinValue());
        this.m_imageStretchOption.setPercentClipRedBandMaxValue(imageStretchOption.getPercentClipRedBandMaxValue());
        this.m_imageStretchOption.setPercentClipGreenBandMinValue(imageStretchOption.getPercentClipGreenBandMinValue());
        this.m_imageStretchOption.setPercentClipGreenBandMaxValue(imageStretchOption.getPercentClipGreenBandMaxValue());
        this.m_imageStretchOption.setPercentClipBlueBandMinValue(imageStretchOption.getPercentClipBlueBandMinValue());
        this.m_imageStretchOption.setPercentClipBlueBandMaxValue(imageStretchOption.getPercentClipBlueBandMaxValue());
    }

    @Override
    void clearHandle() {
        this.m_layer = null;
        this.m_layers = null;
        if (this.m_colorDict != null) {
            this.m_colorDict.dispose();
            this.m_colorDict = null;
        }
    }

    public ImageInterpolationMode getImageInterpolationMode() {
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageInterpolationMode(l);
            this.m_ImageInterpolationMode = (ImageInterpolationMode)InternalEnum.parseUGCValue(ImageInterpolationMode.class, n);
        }
        return this.m_ImageInterpolationMode;
    }

    public void setImageInterpolationMode(ImageInterpolationMode value) {
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = InternalEnum.getUGCValue(value);
            LayerNative.jni_SetImageInterpolationMode(l, n);
        }
        this.m_ImageInterpolationMode = value;
    }

    public Color getSpecialValueColor() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageNoDataColor(l);
            return new Color(n, true);
        }
        return this.m_specialValueColor;
    }

    public void setSpecialValueColor(Color value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageNoDataColor(l, value.getRGB());
        }
        this.m_specialValueColor = new Color(value.getRGB(), true);
    }

    public double getSpecialValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageNoDataValue(l);
        }
        return this.m_specialValue;
    }

    public void setSpecialValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValue(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageNoDataValue(l, value);
        }
        this.m_specialValue = value;
    }

    public boolean isSpecialValueTransparent() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageNoDataTransparent(l);
        }
        return this.m_isSpecialValueTransparent;
    }

    public void setSpecialValueTransparent(boolean value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageNoDataTransparent(l, value);
        }
        this.m_isSpecialValueTransparent = value;
    }

    public Color getBackgroundColor() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBackgroundColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageBackgroundColor(l);
            return new Color(n, true);
        }
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(Color value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBackgroundColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackgroundColor(l, value.getRGB());
        }
        this.m_backgroundColor = new Color(value.getRGB(), true);
    }

    public double getBackgroundValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBackgroundValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double d = LayerNative.jni_GetImageBackground(l);
            return d;
        }
        return this.m_backgroundValue;
    }

    public void setBackgroundValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBackgroundValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackground(l, value);
        }
        this.m_backgroundValue = value;
    }

    public boolean isBackgroundTransparent() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isBackTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageBackgroundTransparent(l);
        }
        return this.m_backgroundTransparent;
    }

    public void setBackgroundTransparent(boolean value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBackgroundTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackgroundTransparent(l, value);
        }
        this.m_backgroundTransparent = value;
    }

    public boolean isImageBackgroundReplace() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isImageBackgroundReplace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageBackgroundReplace(l);
        }
        return this.m_isbackground;
    }

    public void setImageBackgroundReplace(boolean value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setImageBKColorReplace(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackgroundReplace(l, value);
        }
        this.m_isbackground = value;
    }

    public boolean isImageSpecialValueReplace() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isImageSpecialValueReplace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageNoDataReplace(l);
        }
        return this.m_isSpecialValueReplace;
    }

    public void setImageSpecialValueReplace(boolean value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setImageSpecialValueReplace(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageNoDataReplace(l, value);
        }
        this.m_isSpecialValueReplace = value;
    }

    public ColorDictionary getColorDictionary() {
        if (this.isUserLayer && (this.m_colorDict == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_colorDict) == 0L)) {
            String string = InternalResource.loadString("setImageSpecialValueReplace(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_colorDict;
    }

    public void setColorDictionary(ColorDictionary colorDictionary) {
        if (this.isUserLayer) {
            if (this.m_colorDict == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_colorDict) == 0L) {
                String string = InternalResource.loadString("setImageSpecialValueReplace(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (colorDictionary == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary) == 0L) {
                String string = InternalResource.loadString("setImageSpecialValueReplace(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_colorDict.clear();
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary);
            LayerNative.jni_SetColorDictTable(InternalHandle.getHandle(this.m_layer), l);
        }
        this.m_colorDict = new ColorDictionary(colorDictionary);
    }

    public boolean isTransparentColorEnabled() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterTransparentColorTransparent(l);
        }
        return this.m_isTransparentColorEnabled;
    }

    public void setTransparentColorEnabled(boolean value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterTransparentColorTransparent(l, value);
        }
        this.m_isTransparentColorEnabled = value;
    }
}

