/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorDictionary;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.mapping.ImageDisplayMode;
import com.supermap.mapping.ImageInterpolationMode;
import com.supermap.mapping.ImageStretchOption;
import com.supermap.mapping.InternalColorDict;
import com.supermap.mapping.InternalColors;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.Layers;
import java.awt.Color;

public class LayerSettingGrid
extends LayerSetting {
    private Colors m_colorTable = null;
    private ColorDictionary m_clrDict = null;
    private Layer m_layer = null;
    private Layers m_layers = null;
    boolean isOwnerLayer = false;
    boolean is_set = false;
    private int m_Brightness = 0;
    private int m_Contrast = 0;
    private int m_OpaqueRate = 100;
    private boolean m_isColorDictionaryAutoInterpolation = true;
    private ImageInterpolationMode m_ImageInterpolationMode = ImageInterpolationMode.NEARESTNEIGHBOR;
    private ImageStretchOption m_imageStretchOption = null;
    private ImageDisplayMode m_imageDisplayMode = ImageDisplayMode.STRETCHED;
    private double m_specialValue;
    private Color m_specialValueColor = Color.black;
    private boolean m_SpecialValueTransparent = false;
    private boolean m_transparentColorEnabled = false;
    private Color m_transparentColor = Color.black;
    private int m_transparentColorTolerance = 0;
    private boolean m_isBackgroundReplace = false;
    private double m_backgroundValue = 0.0;
    private Color m_backgroundReplaceColor = Color.white;
    private boolean m_backgroundTransparent = false;

    public LayerSettingGrid() {
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
        ColorDictionary colorDictionary = new ColorDictionary();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colorDictionary, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary);
        this.m_clrDict = InternalColorDict.createInstance(l2);
        this.isOwnerLayer = false;
    }

    public LayerSettingGrid(LayerSettingGrid layerSettingGrid) {
        if (layerSettingGrid == null) {
            String string = InternalResource.loadString("layerSettingGrid", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerSettingGrid.isOwnerLayer) {
            if (layerSettingGrid.m_layer == null) {
                String string = InternalResource.loadString("layerSettingGrid", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(layerSettingGrid.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("layerSettingGrid", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        Colors colors = new Colors(layerSettingGrid.getColorTable());
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
        ColorDictionary colorDictionary = new ColorDictionary(layerSettingGrid.getColorDictionary());
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colorDictionary, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary);
        this.m_clrDict = InternalColorDict.createInstance(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colorDictionary);
        this.m_specialValueColor = layerSettingGrid.getSpecialValueColor();
        this.m_specialValue = layerSettingGrid.getSpecialValue();
        this.is_set = layerSettingGrid.is_set;
        this.m_Brightness = layerSettingGrid.getBrightness();
        this.m_Contrast = layerSettingGrid.getContrast();
        this.m_OpaqueRate = layerSettingGrid.getOpaqueRate();
        this.m_SpecialValueTransparent = layerSettingGrid.isSpecialValueTransparent();
        this.isOwnerLayer = false;
        this.m_imageStretchOption = layerSettingGrid.getImageStretchOption();
        this.m_imageDisplayMode = layerSettingGrid.getDisplayMode();
        this.m_transparentColorTolerance = layerSettingGrid.getTransparentColorTolerance();
    }

    LayerSettingGrid(Layer layer, Layers layers) {
        this.m_layer = layer;
        this.m_layers = layers;
        this.isOwnerLayer = true;
        this.m_imageStretchOption = new ImageStretchOption(layer, layers);
    }

    @Override
    public LayerSettingType getType() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        return LayerSettingType.GRID;
    }

    public Colors getColorTable() {
        if (this.isOwnerLayer) {
            long l;
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_colorTable == null && (l = LayerNative.jni_GetColorTable(l2)) != 0L) {
                this.m_colorTable = InternalColors.createInstance(l, false);
            }
        }
        return this.m_colorTable;
    }

    public void setColorTable(Colors colorTable) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (colorTable == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)colorTable) == 0L) {
            String string = InternalResource.loadString("colorTable", "LayerSettingGrid_InvalidColors", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors = new Colors(colorTable);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (this.isOwnerLayer) {
            LayerNative.jni_GetColorTable(l);
            LayerNative.jni_SetColorTable(l, l2);
        } else if (this.m_colorTable == null) {
            this.m_colorTable = InternalColors.createInstance(l2, false);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
            InternalColors.changeHandle(this.m_colorTable, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
    }

    public ColorDictionary getColorDictionary() {
        if (this.isOwnerLayer) {
            long l;
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getColorDictionary()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getColorDictionary()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_clrDict == null && (l = LayerNative.jni_GetColorDictTable(l2)) != 0L) {
                this.m_clrDict = InternalColorDict.createInstance(l);
            }
        }
        return this.m_clrDict;
    }

    public void setColorDictionary(ColorDictionary clrDict) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setColorDictionary(ColorDict clrDict)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorDictionary(ColorDict clrDict)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (clrDict == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)clrDict) == 0L) {
            String string = InternalResource.loadString("setColorDictionary", "LayerSettingGrid_InvalidColorDictionary", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ColorDictionary colorDictionary = new ColorDictionary(clrDict);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary);
        if (this.isOwnerLayer) {
            LayerNative.jni_GetColorDictTable(l);
            LayerNative.jni_SetColorDictTable(l, l2);
        } else if (this.m_clrDict == null) {
            this.m_clrDict = InternalColorDict.createInstance(l2);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colorDictionary, false);
            InternalColorDict.changeHandle(this.m_clrDict, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colorDictionary);
    }

    public Color getSpecialValueColor() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetGridSpecialValueColor(l);
            return new Color(n, true);
        }
        return this.m_specialValueColor;
    }

    public void setSpecialValueColor(Color value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGridSpecialValueColor(l, value.getRGB());
        }
        this.m_specialValueColor = new Color(value.getRGB(), true);
    }

    public double getSpecialValue() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getSpecialValue()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValue()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_specialValue = LayerNative.jni_getGridSpecialValue(l);
        }
        return this.m_specialValue;
    }

    public void setSpecialValue(double value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setSpecialValue(double value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_setGridSpecialValue(l, value);
        }
        this.is_set = true;
        this.m_specialValue = value;
    }

    public int getBrightness() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getBrightness()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBrightness()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_Brightness = LayerNative.jni_GetBrightness(l);
        }
        return this.m_Brightness;
    }

    public void setBrightness(int brightness) {
        if (brightness < -100 || brightness > 100) {
            String string = InternalResource.loadString("brightness", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setBrightness(int brightness)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBrightness(int brightness)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_setBrightness(l, brightness);
        }
        this.m_Brightness = brightness;
    }

    public int getContrast() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getContrast()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getContrast()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_Contrast = LayerNative.jni_GetContrast(l);
        }
        return this.m_Contrast;
    }

    public void setContrast(int contrast) {
        if (contrast < -100 || contrast > 100) {
            String string = InternalResource.loadString("contrast", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setContrast(int contrast)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setContrast(int contrast)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_setContrast(l, contrast);
        }
        this.m_Contrast = contrast;
    }

    public int getOpaqueRate() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_OpaqueRate = LayerNative.jni_GridGetOpaqueRate(l);
        }
        return this.m_OpaqueRate;
    }

    public void setOpaqueRate(int opaqueRate) {
        if (opaqueRate < 0 || opaqueRate > 100) {
            String string = InternalResource.loadString("contrast", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setOpaqueRate(int opaqueRate)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setOpaqueRate(int opaqueRate)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGridOpaqueRate(l, opaqueRate);
        }
        this.m_OpaqueRate = opaqueRate;
    }

    public boolean isSpecialValueTransparent() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("isSpecialValueTransparent()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isSpecialValueTransparent()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_SpecialValueTransparent = LayerNative.jni_GetRasterIsBackTransparent(l);
        }
        return this.m_SpecialValueTransparent;
    }

    public void setSpecialValueTransparent(boolean specialValueTransparent) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setSpecialValueTransparent(boolean specialValueTransparent)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueTransparent(boolean specialValueTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBackTransparent(l, specialValueTransparent);
        }
        this.m_SpecialValueTransparent = specialValueTransparent;
    }

    public boolean isColorDictionaryAutoInterpolation() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("isColorDictionaryAutoInterpolation()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isColorDictionaryAutoInterpolation()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_isColorDictionaryAutoInterpolation = LayerNative.jni_IsColorDictionaryAutoInterpolation(l);
        }
        return this.m_isColorDictionaryAutoInterpolation;
    }

    public void setColorDictionaryAutoInterpolation(boolean isColorDictionaryAutoInterpolation) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setColorDictionaryAutoInterpolation(boolean specialValueTransparent)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorDictionaryAutoInterpolation(boolean specialValueTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetColorDictionaryAutoInterpolation(l, isColorDictionaryAutoInterpolation);
        }
        this.m_isColorDictionaryAutoInterpolation = isColorDictionaryAutoInterpolation;
    }

    protected void finalize() {
        if (this.m_layer == null && this.m_colorTable != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_colorTable, true);
            this.m_colorTable.dispose();
        }
        if (this.m_layer == null && this.m_clrDict != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_clrDict, true);
            this.m_clrDict.dispose();
        }
    }

    @Override
    void clearHandle() {
        if (this.m_colorTable != null) {
            InternalColors.clearHandle(this.m_colorTable);
            this.m_colorTable = null;
        }
        if (this.m_clrDict != null) {
            InternalColorDict.clearHandle(this.m_clrDict);
            this.m_clrDict = null;
        }
        this.m_layer = null;
        this.m_layers = null;
    }

    public ImageInterpolationMode getImageInterpolationMode() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageInterpolationMode(l);
            this.m_ImageInterpolationMode = (ImageInterpolationMode)InternalEnum.parseUGCValue(ImageInterpolationMode.class, n);
        }
        return this.m_ImageInterpolationMode;
    }

    public void setImageInterpolationMode(ImageInterpolationMode value) {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setImageInterpolationMode()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = InternalEnum.getUGCValue(value);
            LayerNative.jni_SetImageInterpolationMode(l, n);
        }
        this.m_ImageInterpolationMode = value;
    }

    public ImageStretchOption getImageStretchOption() {
        if (this.isOwnerLayer) {
            Class<?> clazz;
            Dataset dataset;
            if (this.m_imageStretchOption == null && this.m_layer != null && this.m_layers != null && (dataset = this.m_layer.getDataset()) != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L && (clazz = dataset.getClass()).equals(DatasetGrid.class)) {
                this.m_imageStretchOption = new ImageStretchOption(this.m_layer, this.m_layers);
            }
            return this.m_imageStretchOption;
        }
        if (this.m_imageStretchOption == null) {
            String string = InternalResource.loadString("getImageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_imageStretchOption;
    }

    public void setImageStretchOption(ImageStretchOption imageStretchOption) {
        if (this.m_layer == null || this.m_layers == null) {
            String string = InternalResource.loadString("setImageStretchOption(ImageStretchOption imageStretchOption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getImageStretchOption() == null) {
            String string = InternalResource.loadString("setImageStretchOption(ImageStretchOption imageStretchOption)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (imageStretchOption == null) {
            String string = InternalResource.loadString("imageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_imageStretchOption.setStretchType(imageStretchOption.getStretchType());
        this.m_imageStretchOption.setStandardDeviationStretchFactor(imageStretchOption.getStandardDeviationStretchFactor());
        this.m_imageStretchOption.setGaussianStretchRatioFactor(imageStretchOption.getGaussianStretchRatioFactor());
        this.m_imageStretchOption.setGaussianStretchMiddleFactor(imageStretchOption.isGaussianStretchMiddleFactor());
        this.m_imageStretchOption.setStandardHistograms(imageStretchOption.getStandardHistograms());
        this.m_imageStretchOption.setPercentClipStretchMaxPercent(imageStretchOption.getPercentClipStretchMaxPercent());
        this.m_imageStretchOption.setPercentClipStretchMinPercent(imageStretchOption.getPercentClipStretchMinPercent());
        this.m_imageStretchOption.setPercentClipRedBandMinValue(imageStretchOption.getPercentClipRedBandMinValue());
        this.m_imageStretchOption.setPercentClipRedBandMaxValue(imageStretchOption.getPercentClipRedBandMaxValue());
        this.m_imageStretchOption.setPercentClipGreenBandMinValue(imageStretchOption.getPercentClipGreenBandMinValue());
        this.m_imageStretchOption.setPercentClipGreenBandMaxValue(imageStretchOption.getPercentClipGreenBandMaxValue());
        this.m_imageStretchOption.setPercentClipBlueBandMinValue(imageStretchOption.getPercentClipBlueBandMinValue());
        this.m_imageStretchOption.setPercentClipBlueBandMaxValue(imageStretchOption.getPercentClipBlueBandMaxValue());
    }

    public ImageDisplayMode getDisplayMode() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageDisplayMode(l);
            return (ImageDisplayMode)InternalEnum.parseUGCValue(ImageDisplayMode.class, n);
        }
        return this.m_imageDisplayMode;
    }

    public void setDisplayMode(ImageDisplayMode displayMode) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayMode(ImageDisplayMode displayMode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (!(this.m_layer.getDataset() instanceof DatasetGrid)) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = displayMode.value();
            LayerNative.jni_SetImageDisplayMode(l, n);
        }
        this.m_imageDisplayMode = displayMode;
    }

    public Color getTransparentColor() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetRasterBackTransparentColor(l);
            return new Color(n, true);
        }
        return this.m_transparentColor;
    }

    public void setTransparentColor(Color value) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparentColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBackTransparentColor(l, value.getRGB());
        }
        this.m_transparentColor = new Color(value.getRGB(), true);
    }

    public int getTransparentColorTolerance() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetTransparentColorTolerance(l);
        }
        return this.m_transparentColorTolerance;
    }

    public void setTransparentColorTolerance(int value) {
        if (value < 0 || value > 255) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int value)", "LayerSettingImage_TransparentColorToleranceShouldBetween0And255", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setRasterOpaqueRate(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetTransparentColorTolerance(l, value);
        }
        this.m_transparentColorTolerance = value;
    }

    public boolean isTransparentColorEnabled() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterTransparentColorTransparent(l);
        }
        return this.m_transparentColorEnabled;
    }

    public void setTransparentColorEnabled(boolean value) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterTransparentColorTransparent(l, value);
        }
        this.m_transparentColorEnabled = value;
    }

    public double getBackgroundValue() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBackgroundValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double d = LayerNative.jni_GetImageBackground(l);
            return d;
        }
        return this.m_backgroundValue;
    }

    public void setBackgroundValue(double value) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBackgroundValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackground(l, value);
        }
        this.m_backgroundValue = value;
    }

    public boolean isBackgroundTransparent() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isBackTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageBackgroundTransparent(l);
        }
        return this.m_backgroundTransparent;
    }

    public void setBackgroundTransparent(boolean value) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBackgroundTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackgroundTransparent(l, value);
        }
        this.m_backgroundTransparent = value;
    }

    public boolean isBackgroundReplace() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isBackgroundReplace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetImageBackgroundReplace(l);
        }
        return this.m_isBackgroundReplace;
    }

    public void setBackgroundReplace(boolean value) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setImageBKColorReplace(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackgroundReplace(l, value);
        }
        this.m_isBackgroundReplace = value;
    }

    public Color getBackgroundColor() {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBackgroundColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageBackgroundColor(l);
            return new Color(n, true);
        }
        return this.m_backgroundReplaceColor;
    }

    public void setBackgroundColor(Color value) {
        if (this.isOwnerLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBackgroundColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetImageBackgroundColor(l, value.getRGB());
        }
        this.m_backgroundReplaceColor = new Color(value.getRGB(), true);
    }
}

