/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.mapping.ImageStretchType;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerMosaic;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerType;
import com.supermap.mapping.Layers;
import java.util.ArrayList;

public class ImageStretchOption {
    private Layer m_layer = null;
    private Layers m_layers = null;
    private boolean isUserLayer = false;
    ImageStretchType m_imageStretchType;
    double m_standardDeviationStretchFactor;
    double m_gaussianStretchRatioFactor;
    boolean m_gaussianStretchIsMidFactor;
    double m_percentClipStretchMaxPercent;
    double m_percentClipStretchMinPercent;
    double m_percentClipRedBandMaxValue;
    double m_percentClipRedBandMinValue;
    double m_percentClipGreenBandMaxValue;
    double m_percentClipGreenBandMinValue;
    double m_percentClipBlueBandMaxValue;
    double m_percentClipBlueBandMinValue;
    ArrayList<ArrayList<Integer>> m_arrHistogramStandard;

    public ImageStretchOption() {
        this.isUserLayer = false;
        this.m_imageStretchType = ImageStretchType.MINIMUMMAXIMUM;
        this.m_standardDeviationStretchFactor = 2.0;
        this.m_gaussianStretchRatioFactor = 2.0;
        this.m_gaussianStretchIsMidFactor = true;
        this.m_percentClipStretchMaxPercent = 0.98;
        this.m_percentClipStretchMinPercent = 0.02;
        this.m_percentClipRedBandMaxValue = 3.4028234663852886E38;
        this.m_percentClipRedBandMinValue = -3.4028234663852886E38;
        this.m_percentClipGreenBandMaxValue = 3.4028234663852886E38;
        this.m_percentClipGreenBandMinValue = -3.4028234663852886E38;
        this.m_percentClipBlueBandMaxValue = 3.4028234663852886E38;
        this.m_percentClipBlueBandMinValue = -3.4028234663852886E38;
        this.m_arrHistogramStandard = new ArrayList();
    }

    ImageStretchOption(Layer layer, Layers layers) {
        this.m_layer = layer;
        this.m_layers = layers;
        this.isUserLayer = true;
        this.m_standardDeviationStretchFactor = 2.0;
        this.m_gaussianStretchRatioFactor = 2.0;
        this.m_gaussianStretchIsMidFactor = true;
        this.m_percentClipStretchMaxPercent = 0.98;
        this.m_percentClipStretchMinPercent = 0.02;
        this.m_percentClipRedBandMaxValue = 3.4028234663852886E38;
        this.m_percentClipRedBandMinValue = -3.4028234663852886E38;
        this.m_percentClipGreenBandMaxValue = 3.4028234663852886E38;
        this.m_percentClipGreenBandMinValue = -3.4028234663852886E38;
        this.m_percentClipBlueBandMaxValue = 3.4028234663852886E38;
        this.m_percentClipBlueBandMinValue = -3.4028234663852886E38;
        this.m_arrHistogramStandard = new ArrayList();
    }

    public ImageStretchOption(ImageStretchOption imageStretchOption) {
        if (imageStretchOption == null) {
            String string = InternalResource.loadString("imageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (imageStretchOption.isUserLayer) {
            this.m_layer = imageStretchOption.m_layer;
            this.m_layers = imageStretchOption.m_layers;
            this.isUserLayer = true;
        } else {
            this.m_standardDeviationStretchFactor = imageStretchOption.m_gaussianStretchRatioFactor;
            this.m_gaussianStretchRatioFactor = imageStretchOption.m_gaussianStretchRatioFactor;
            this.m_gaussianStretchIsMidFactor = imageStretchOption.m_gaussianStretchIsMidFactor;
            this.m_percentClipStretchMaxPercent = imageStretchOption.m_percentClipStretchMaxPercent;
            this.m_percentClipStretchMinPercent = imageStretchOption.m_percentClipStretchMinPercent;
            this.m_percentClipRedBandMaxValue = imageStretchOption.m_percentClipRedBandMaxValue;
            this.m_percentClipRedBandMinValue = imageStretchOption.m_percentClipRedBandMinValue;
            this.m_percentClipGreenBandMaxValue = imageStretchOption.m_percentClipGreenBandMaxValue;
            this.m_percentClipGreenBandMinValue = imageStretchOption.m_percentClipGreenBandMinValue;
            this.m_percentClipBlueBandMaxValue = imageStretchOption.m_percentClipBlueBandMaxValue;
            this.m_percentClipBlueBandMinValue = imageStretchOption.m_percentClipBlueBandMinValue;
            int n = imageStretchOption.m_arrHistogramStandard.size();
            this.m_arrHistogramStandard = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                ArrayList<Integer> arrayList = imageStretchOption.m_arrHistogramStandard.get(i);
                int n2 = arrayList.size();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n2);
                for (int j = 0; j < n2; ++j) {
                    arrayList2.set(j, arrayList.get(j));
                }
                this.m_arrHistogramStandard.set(i, arrayList2);
            }
        }
    }

    public ImageStretchType getStretchType() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getStretchType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ImageStretchType imageStretchType = ImageStretchType.NONE;
            int n = LayerNative.jni_GetImageStretchType(l);
            switch (n) {
                case 0: {
                    imageStretchType = ImageStretchType.NONE;
                    break;
                }
                case 1: {
                    imageStretchType = ImageStretchType.STANDARDDEVIATION;
                    break;
                }
                case 2: {
                    imageStretchType = ImageStretchType.MINIMUMMAXIMUM;
                    break;
                }
                case 3: {
                    imageStretchType = ImageStretchType.HISTOGRAMEQUALIZATION;
                    break;
                }
                case 4: {
                    imageStretchType = ImageStretchType.HISTOGRAMSPECIFICATION;
                    break;
                }
                case 5: {
                    imageStretchType = ImageStretchType.GAUSSIAN;
                    break;
                }
                case 6: {
                    imageStretchType = ImageStretchType.PERCENTCLIP;
                    break;
                }
                default: {
                    String string = InternalResource.loadString("getStretchType()", "GlobalArgument_OutOfBounds", "mapping_resources");
                    throw new IllegalStateException(string);
                }
            }
            return imageStretchType;
        }
        return this.m_imageStretchType;
    }

    public void setStretchType(ImageStretchType stretchType) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setStretchType(ImageStretchType stretchType)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_layer.getSubLayerType() == LayerType.SUBLAYER_MOSAIC) {
                LayerMosaic layerMosaic = (LayerMosaic)this.m_layer;
                if (layerMosaic.getDatasetMosaic().getBandCount() <= 0) {
                    String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                    throw new IllegalStateException(string);
                }
            } else if (!(this.m_layer.getDataset() instanceof DatasetImage) && !(this.m_layer.getDataset() instanceof DatasetGrid)) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = 0;
            if (stretchType == ImageStretchType.NONE) {
                n = 0;
            } else if (stretchType == ImageStretchType.STANDARDDEVIATION) {
                n = 1;
            } else if (stretchType == ImageStretchType.MINIMUMMAXIMUM) {
                n = 2;
            } else if (stretchType == ImageStretchType.HISTOGRAMEQUALIZATION) {
                n = 3;
            } else if (stretchType == ImageStretchType.HISTOGRAMSPECIFICATION) {
                n = 4;
            } else if (stretchType == ImageStretchType.GAUSSIAN) {
                n = 5;
            } else if (stretchType == ImageStretchType.PERCENTCLIP) {
                n = 6;
            }
            LayerNative.jni_SetImageStretchType(l, n);
        }
        this.m_imageStretchType = stretchType;
    }

    public double getStandardDeviationStretchFactor() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getStandardDeviationStretchFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetStandardDeviationStretchFactor(l);
        }
        return this.m_standardDeviationStretchFactor;
    }

    public void setStandardDeviationStretchFactor(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("setStandardDeviationStretchFactor(double value)", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setStandardDeviationStretchFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetStandardDeviationStretchFactor(l, value);
        }
        this.m_standardDeviationStretchFactor = value;
    }

    public void setGaussianStretchRatioFactor(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("setGaussianStretchRatioFactor(double value)", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setGaussianStretchRatioFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGaussianStretchRatioFactor(l, value);
        }
        this.m_gaussianStretchRatioFactor = value;
    }

    public void setGaussianStretchMiddleFactor(boolean value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setGaussianStretchIsMidFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGaussianStretchIsMidFactor(l, value);
        }
        this.m_gaussianStretchIsMidFactor = value;
    }

    public double getGaussianStretchRatioFactor() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getGaussianStretchRatioFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetGaussianStretchRatioFactor(l);
        }
        return this.m_gaussianStretchRatioFactor;
    }

    public boolean isGaussianStretchMiddleFactor() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getGaussianStretchIsMidFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetGaussianStretchIsMidFactor(l);
        }
        return this.m_gaussianStretchIsMidFactor;
    }

    public ArrayList<ArrayList<Integer>> getStandardHistograms() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getArrStandardHistogram()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_arrHistogramStandard.clear();
            int n = LayerNative.jni_GetStandardHistSize(l);
            for (int i = 0; i < n; ++i) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int[] nArray = LayerNative.jni_GetStandardHistCount(l, i);
                int n2 = nArray.length;
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(nArray[j]);
                }
                this.m_arrHistogramStandard.add(arrayList);
            }
            return this.m_arrHistogramStandard;
        }
        return this.m_arrHistogramStandard;
    }

    public void setStandardHistograms(ArrayList<ArrayList<Integer>> value) {
        if (value == null) {
            String string = InternalResource.loadString("setStandardHistograms(ArrayList<ArrayList<Integer>> value)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = value.size();
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setStandardHistograms(ArrayList<ArrayList<Integer>> value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetStandardHistSize(l, n);
            ArrayList<Object> arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                arrayList = value.get(i);
                int n2 = arrayList.size();
                int[] nArray = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArray[j] = (Integer)arrayList.get(j);
                }
                LayerNative.jni_SetStandardHistCount(l, i, nArray);
            }
        }
        this.m_arrHistogramStandard = value;
    }

    public ArrayList<Double> getStandardHistMinValues() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getStandardHistMinValues()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = LayerNative.jni_GetStandardHistMinValues(l);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(dArray[i]);
            }
        }
        return arrayList;
    }

    public ArrayList<Double> getStandardHistMaxValues() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getStandardHistMaxValues()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = LayerNative.jni_GetStandardHistMaxValues(l);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(dArray[i]);
            }
        }
        return arrayList;
    }

    public double getPercentClipStretchMaxPercent() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipStretchMaxPercent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipStretchMaxPercent(l);
        }
        return this.m_percentClipStretchMaxPercent;
    }

    public void setPercentClipStretchMaxPercent(double value) {
        if (value < 0.0 || value > 1.0) {
            String string = InternalResource.loadString("setPercentClipStretchMaxPercent(double value)", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipStretchMaxPercent(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipStretchMaxPercent(l, value);
        }
        this.m_percentClipStretchMaxPercent = value;
    }

    public double getPercentClipStretchMinPercent() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipStretchMinPercent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipStretchMinPercent(l);
        }
        return this.m_percentClipStretchMinPercent;
    }

    public void setPercentClipStretchMinPercent(double value) {
        if (value < 0.0 || value > 1.0) {
            String string = InternalResource.loadString("setPercentClipStretchMinPercent(double value)", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipStretchMinPercent(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipStretchMinPercent(l, value);
        }
        this.m_percentClipStretchMinPercent = value;
    }

    public double getPercentClipRedBandMaxValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipRedBandMaxValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipRedBandMaxValue(l);
        }
        return this.m_percentClipRedBandMaxValue;
    }

    public void setPercentClipRedBandMaxValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipRedBandMaxPercent(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipRedBandMaxValue(l, value);
        }
        this.m_percentClipRedBandMaxValue = value;
    }

    public double getPercentClipRedBandMinValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipRedBandMinValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipRedBandMinValue(l);
        }
        return this.m_percentClipRedBandMinValue;
    }

    public void setPercentClipRedBandMinValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipRedBandMinValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipRedBandMinValue(l, value);
        }
        this.m_percentClipRedBandMinValue = value;
    }

    public double getPercentClipGreenBandMaxValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipGreenBandMaxValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipGreenBandMaxValue(l);
        }
        return this.m_percentClipGreenBandMaxValue;
    }

    public void setPercentClipGreenBandMaxValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipGreenBandMaxValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipGreenBandMaxValue(l, value);
        }
        this.m_percentClipGreenBandMaxValue = value;
    }

    public double getPercentClipGreenBandMinValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipGreenBandMinValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipGreenBandMinValue(l);
        }
        return this.m_percentClipGreenBandMinValue;
    }

    public void setPercentClipGreenBandMinValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipGreenBandMinValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipGreenBandMinValue(l, value);
        }
        this.m_percentClipGreenBandMinValue = value;
    }

    public double getPercentClipBlueBandMaxValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipBlueBandMaxValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipBlueBandMaxValue(l);
        }
        return this.m_percentClipBlueBandMaxValue;
    }

    public void setPercentClipBlueBandMaxValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipBlueBandMaxValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipBlueBandMaxValue(l, value);
        }
        this.m_percentClipBlueBandMaxValue = value;
    }

    public double getPercentClipBlueBandMinValue() {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getPercentClipBlueBandMinValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetPercentClipBlueBandMinValue(l);
        }
        return this.m_percentClipBlueBandMinValue;
    }

    public void setPercentClipBlueBandMinValue(double value) {
        if (this.isUserLayer) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setPercentClipBlueBandMinPercent(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetPercentClipBlueBandMinValue(l, value);
        }
        this.m_percentClipBlueBandMinValue = value;
    }
}

