/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart;

import com.supermap.chart.ChartQueryParameter;
import com.supermap.chart.ChartQueryResult;
import com.supermap.chart.InternalResource;
import com.supermap.chart.S57DatasetGroupExtInfo;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import java.util.Vector;

public class ChartQuery {
    private ChartQuery() {
    }

    public static ChartQueryResult[] query(DatasetGroup[] datasetGroups, ChartQueryParameter[] queryParameters, CursorType cursorType) {
        if (datasetGroups == null) {
            String string = InternalResource.loadString("datasetGroups", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        if (queryParameters == null) {
            String string = InternalResource.loadString("queryParameters", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        int n = datasetGroups.length;
        int n2 = queryParameters.length;
        if (n == 0) {
            String string = InternalResource.loadString("datasetGroups", "Length_CannotBeZero", "conversion_resources");
            throw new NullPointerException(string);
        }
        if (n2 == 0) {
            String string = InternalResource.loadString("queryParameters", "Length_CannotBeZero", "conversion_resources");
            throw new NullPointerException(string);
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<Recordset> vector2 = new Vector<Recordset>();
        for (int i = 0; i < n; ++i) {
            Object object;
            DatasetGroup datasetGroup = datasetGroups[i];
            S57DatasetGroupExtInfo s57DatasetGroupExtInfo = new S57DatasetGroupExtInfo(datasetGroup);
            for (int j = 0; j < n2; ++j) {
                Recordset recordset;
                DatasetVector datasetVector;
                object = queryParameters[j];
                int n3 = ((ChartQueryParameter)object).getFeatureInfo().getCode();
                String string = ((ChartQueryParameter)object).getAttributeFilter();
                if (((ChartQueryParameter)object).isQueryPoint() && (datasetVector = (DatasetVector)s57DatasetGroupExtInfo.getFeatureDataset(n3, DatasetType.POINT)) != null && (recordset = datasetVector.query(string, cursorType)).getRecordCount() > 0) {
                    vector2.add(recordset);
                }
                if (((ChartQueryParameter)object).isQueryLine() && (datasetVector = (DatasetVector)s57DatasetGroupExtInfo.getFeatureDataset(n3, DatasetType.LINE)) != null && (recordset = datasetVector.query(string, cursorType)).getRecordCount() > 0) {
                    vector2.add(recordset);
                }
                if (!((ChartQueryParameter)object).isQueryRegion() || (datasetVector = (DatasetVector)s57DatasetGroupExtInfo.getFeatureDataset(n3, DatasetType.REGION)) == null || (recordset = datasetVector.query(string, cursorType)).getRecordCount() <= 0) continue;
                vector2.add(recordset);
            }
            if (vector2.size() > 0) {
                Recordset[] recordsetArray = new Recordset[vector2.size()];
                vector2.toArray(recordsetArray);
                object = new ChartQueryResult(datasetGroup.getName(), recordsetArray);
                vector.add(object);
            }
            vector2.clear();
            s57DatasetGroupExtInfo.dispose();
        }
        ChartQueryResult[] chartQueryResultArray = new ChartQueryResult[vector.size()];
        vector.toArray(chartQueryResultArray);
        return chartQueryResultArray;
    }

    public static ChartQueryResult[] query(DatasetGroup[] datasetGroups, Rectangle2D bounds, ChartQueryParameter[] queryParameters, CursorType cursorType) {
        if (datasetGroups == null) {
            String string = InternalResource.loadString("datasetGroups", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        if (queryParameters == null) {
            String string = InternalResource.loadString("queryParameters", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        int n = datasetGroups.length;
        int n2 = queryParameters.length;
        if (n == 0) {
            String string = InternalResource.loadString("datasetGroups", "Length_CannotBeZero", "conversion_resources");
            throw new NullPointerException(string);
        }
        if (n2 == 0) {
            String string = InternalResource.loadString("queryParameters", "Length_CannotBeZero", "conversion_resources");
            throw new NullPointerException(string);
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<Recordset> vector2 = new Vector<Recordset>();
        for (int i = 0; i < n; ++i) {
            Object object;
            DatasetGroup datasetGroup = datasetGroups[i];
            S57DatasetGroupExtInfo s57DatasetGroupExtInfo = new S57DatasetGroupExtInfo(datasetGroup);
            Rectangle2D rectangle2D = s57DatasetGroupExtInfo.getVectorEdgeDataset().getBounds();
            if (!bounds.hasIntersection(rectangle2D)) {
                s57DatasetGroupExtInfo.dispose();
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                Recordset recordset;
                DatasetVector datasetVector;
                object = queryParameters[j];
                int n3 = ((ChartQueryParameter)object).getFeatureInfo().getCode();
                String string = ((ChartQueryParameter)object).getAttributeFilter();
                if (((ChartQueryParameter)object).isQueryPoint() && (datasetVector = (DatasetVector)s57DatasetGroupExtInfo.getFeatureDataset(n3, DatasetType.POINT)) != null && (recordset = datasetVector.query(bounds, string, cursorType)).getRecordCount() > 0) {
                    vector2.add(recordset);
                }
                if (((ChartQueryParameter)object).isQueryLine() && (datasetVector = (DatasetVector)s57DatasetGroupExtInfo.getFeatureDataset(n3, DatasetType.LINE)) != null && (recordset = datasetVector.query(bounds, string, cursorType)).getRecordCount() > 0) {
                    vector2.add(recordset);
                }
                if (!((ChartQueryParameter)object).isQueryRegion() || (datasetVector = (DatasetVector)s57DatasetGroupExtInfo.getFeatureDataset(n3, DatasetType.REGION)) == null || (recordset = datasetVector.query(bounds, string, cursorType)).getRecordCount() <= 0) continue;
                vector2.add(recordset);
            }
            if (vector2.size() > 0) {
                Recordset[] recordsetArray = new Recordset[vector2.size()];
                vector2.toArray(recordsetArray);
                object = new ChartQueryResult(datasetGroup.getName(), recordsetArray);
                vector.add(object);
            }
            vector2.clear();
            s57DatasetGroupExtInfo.dispose();
        }
        ChartQueryResult[] chartQueryResultArray = new ChartQueryResult[vector.size()];
        vector.toArray(chartQueryResultArray);
        return chartQueryResultArray;
    }
}

