/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.layout.InternalGeoStyle;
import com.supermap.layout.InternalHandleDisposable;
import com.supermap.layout.InternalResource;
import com.supermap.layout.SelectionNative;

public class LayoutSelection
extends com.supermap.data.InternalHandleDisposable {
    private GeoStyle m_geoStyle;

    public LayoutSelection() {
        long l = SelectionNative.jni_New();
        this.setHandle(l, true);
    }

    public LayoutSelection(LayoutSelection layoutSelection) {
        if (layoutSelection == null) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (layoutSelection.getHandle() == 0L) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SelectionNative.jni_Clone(layoutSelection.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)layoutSelection));
    }

    LayoutSelection(long handle) {
        this.setHandle(handle, false);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return SelectionNative.jni_GetCount(this.getHandle());
    }

    public int get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_GetItem(this.getHandle(), index);
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoStyle == null && (l = SelectionNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_geoStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_geoStyle;
    }

    public void setStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geoStyle.clone());
        SelectionNative.jni_SetStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public int add(int geometryID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(int geometryID)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geometryID <= 0) {
            String string = InternalResource.loadString("geometryID", "Selection_TheArgumentOfGeometryIDShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_Add(this.getHandle(), geometryID);
    }

    public int addRange(int[] geometryIDs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geometryIDs == null) {
            String string = InternalResource.loadString("geometryIDs", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geometryIDs.length;
        for (int i = 0; i < n; ++i) {
            if (geometryIDs[i] > 0) continue;
            String string = InternalResource.loadString("geometryIDs", "Selection_TheArgumentOfGeometryIDShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_AddRange(this.getHandle(), geometryIDs);
    }

    public boolean remove(int geometryID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int geometryID)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = SelectionNative.jni_IndexOf(this.getHandle(), geometryID);
        if (n == -1) {
            String string = InternalResource.loadString("geometryID", "Selection_TheGeometryIDIsNotInSelection", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_Remove(this.getHandle(), n);
    }

    public int removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "Selection_TheArgumentOfCountIsInvalid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_RemoveRange(this.getHandle(), index, count);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        SelectionNative.jni_Clear(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "layout_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SelectionNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this.m_geoStyle != null) {
            InternalGeoStyle.clearHandle(this.m_geoStyle);
            this.m_geoStyle = null;
        }
        this.setHandle(0L);
    }
}

