/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.GridStatisticsMode;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.PixelFormat;

public class ZonalStatisticsAnalystParameter {
    private Dataset m_ZonalDataset;
    private Dataset m_ValueDataset;
    private Datasource m_TargetDatasource;
    private GridStatisticsMode m_StatisticsMode;
    private PixelFormat m_PixelFormat;
    private String m_ZonalFieldName;
    private String m_TargetDatasetName;
    private String m_TargetTableName;
    private boolean m_isIgnoreNoValue;

    public ZonalStatisticsAnalystParameter() {
        this.m_ZonalDataset = null;
        this.m_ValueDataset = null;
        this.m_isIgnoreNoValue = true;
        this.m_PixelFormat = PixelFormat.SINGLE;
        this.m_StatisticsMode = GridStatisticsMode.SUM;
        this.m_ZonalFieldName = "SmID";
        this.m_TargetDatasetName = "";
        this.m_TargetTableName = "";
        this.m_TargetDatasource = null;
    }

    public ZonalStatisticsAnalystParameter(ZonalStatisticsAnalystParameter zonalStatisticsAnalystParameter) {
        this.m_ZonalDataset = zonalStatisticsAnalystParameter.m_ZonalDataset;
        this.m_ValueDataset = zonalStatisticsAnalystParameter.m_ValueDataset;
        this.m_TargetDatasource = zonalStatisticsAnalystParameter.m_TargetDatasource;
        this.m_StatisticsMode = zonalStatisticsAnalystParameter.m_StatisticsMode;
        this.m_PixelFormat = zonalStatisticsAnalystParameter.m_PixelFormat;
        this.m_ZonalFieldName = zonalStatisticsAnalystParameter.m_ZonalFieldName;
        this.m_TargetDatasetName = zonalStatisticsAnalystParameter.m_TargetDatasetName;
        this.m_TargetTableName = zonalStatisticsAnalystParameter.m_TargetTableName;
        this.m_isIgnoreNoValue = zonalStatisticsAnalystParameter.m_isIgnoreNoValue;
    }

    public Dataset getZonalDataset() {
        return this.m_ZonalDataset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setZonalDataset(Dataset zonalDataset) {
        if (zonalDataset.getType() == DatasetType.REGION) {
            this.m_ZonalDataset = zonalDataset;
            return;
        }
        if (zonalDataset.getType() != DatasetType.GRID) {
            String string = InternalResource.loadString("Only support REGION or GRID", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = (DatasetGrid)zonalDataset;
        if (datasetGrid.getPixelFormat() != PixelFormat.UBIT1 && datasetGrid.getPixelFormat() != PixelFormat.UBIT4 && datasetGrid.getPixelFormat() != PixelFormat.UBIT8 && datasetGrid.getPixelFormat() != PixelFormat.UBIT16) {
            String string = InternalResource.loadString("Only support UBIT1 or UBIT4 or UBIT8 or UBIT16", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_ZonalDataset = zonalDataset;
    }

    public Dataset getValueDataset() {
        return this.m_ValueDataset;
    }

    public void setValueDataset(Dataset valueDataset) {
        this.m_ValueDataset = valueDataset;
    }

    public Datasource getTargetDatasource() {
        return this.m_TargetDatasource;
    }

    public void setTargetDatasource(Datasource targetDatasource) {
        this.m_TargetDatasource = targetDatasource;
    }

    public GridStatisticsMode getStatisticsMode() {
        return this.m_StatisticsMode;
    }

    public void setStatisticsMode(GridStatisticsMode value) {
        this.m_StatisticsMode = value;
    }

    @Deprecated
    public PixelFormat getPixelFormat() {
        return this.m_PixelFormat;
    }

    @Deprecated
    public void setPixelFormat(PixelFormat pixelFormat) {
        this.m_PixelFormat = pixelFormat;
    }

    public String getZonalFieldName() {
        return this.m_ZonalFieldName;
    }

    public void setZonalFieldName(String zonalFieldName) {
        this.m_ZonalFieldName = zonalFieldName;
    }

    public String getTargetDatasetName() {
        return this.m_TargetDatasetName;
    }

    public void setTargetDatasetName(String outputDatasetName) {
        this.m_TargetDatasetName = outputDatasetName;
    }

    public String getTargetTableName() {
        return this.m_TargetTableName;
    }

    public void setTargetTableName(String outputTableName) {
        this.m_TargetTableName = outputTableName;
    }

    public boolean isIgnoreNoValue() {
        return this.m_isIgnoreNoValue;
    }

    public void setIgnoreNoValue(boolean isIgnoreNoValue) {
        this.m_isIgnoreNoValue = isIgnoreNoValue;
    }
}

