/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.InterpolationAnalystNative;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Vector;

public class Interpolator {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static GridAnalystSetting m_gridAnalystSetting;

    private Interpolator() {
        m_gridAnalystSetting = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid interpolate(InterpolationParameter parameter, DatasetVector interpolatedPoint, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        if (!interpolatedPoint.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = interpolatedPoint.getRecordset(false, CursorType.STATIC);
        DatasetGrid datasetGrid = Interpolator.interpolate(parameter, recordset, zValueFieldName, zValueScale, targetDatasource, targetDatasetName, pixelFormat);
        recordset.dispose();
        return datasetGrid;
    }

    public static DatasetGrid interpolate(InterpolationParameter parameter, Recordset interpolatedPointRecordset, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        Interpolator.verifyLicense();
        if (interpolatedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)interpolatedPointRecordset) == 0L) {
            String string = InternalResource.loadString("interpolatedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetVector datasetVector = interpolatedPointRecordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
            String string = InternalResource.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (interpolatedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfo fieldInfo = interpolatedPointRecordset.getFieldInfos().get(zValueFieldName);
        if (fieldInfo == null || fieldInfo.getType() != FieldType.DOUBLE && fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64 && fieldInfo.getType() != FieldType.SINGLE) {
            String string = InternalResource.loadString("zValueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_gridAnalystSetting == null || m_gridAnalystSetting.getOutputDatasource() == null) {
                String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            targetDatasource = m_gridAnalystSetting.getOutputDatasource();
        }
        if (targetDatasetName == null) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (m_gridAnalystSetting != null && m_gridAnalystSetting.getGridOutputNamePrefix() != null) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = parameter.getBounds().isEmpty();
        if (bl) {
            if (m_gridAnalystSetting != null && !m_gridAnalystSetting.getBounds().isEmpty()) {
                parameter.setBounds(m_gridAnalystSetting.getBounds());
            } else {
                parameter.setBounds(datasetVector.getBounds());
            }
        }
        boolean bl2 = false;
        double d = parameter.getResolution();
        if (Toolkit.isZero((double)parameter.getResolution()) || parameter.getResolution() < 0.0) {
            bl2 = true;
            if (m_gridAnalystSetting != null && !Toolkit.isZero((double)m_gridAnalystSetting.getCellSize())) {
                parameter.setResolution(m_gridAnalystSetting.getCellSize());
            } else {
                double d2 = Math.min(parameter.getBounds().getHeight(), parameter.getBounds().getWidth());
                parameter.setResolution(d2 / 500.0);
            }
        }
        boolean bl3 = false;
        if (m_gridAnalystSetting != null) {
            bl3 = m_gridAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)interpolatedPointRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = InterpolationAnalystNative.jni_Interpolate(l, l2, zValueFieldName, zValueScale, l3, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat), bl3);
        if (bl) {
            parameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            parameter.setResolution(d);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)interpolatedPointRecordset);
        return datasetGrid;
    }

    public static DatasetGrid interpolate(InterpolationParameter paramerter, Point2D[] points, double[] values, PrjCoordSys prjCoordSys, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
            String string = InternalResource.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.length < 1) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (values.length < 1) {
            String string = InternalResource.loadString("values", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.length != values.length) {
            String string = InternalResource.loadString("points values", "PointsCount_MustEqual_ValuesCount", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasetName == null) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (zValueScale == 0.0) {
            String string = InternalResource.loadString("zValueScale", "CanNotBeZero", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (prjCoordSys == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys) == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[points.length];
        double[] dArray2 = new double[points.length];
        for (int i = 0; i < values.length; ++i) {
            dArray[i] = points[i].x;
            dArray2[i] = points[i].y;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)paramerter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        long l4 = InterpolationAnalystNative.jni_Interpolate2(l, dArray, dArray2, values, l3, zValueScale, l2, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat), true);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l3);
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Interpolate";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        Interpolator.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

