/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.EdgeMatchAttributeMethod;
import com.supermap.analyst.spatialanalyst.EdgeMatchMode;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import java.util.ArrayList;

public class EdgeMatchParameter {
    private EdgeMatchMode m_edgeMatchMode;
    private boolean m_bIsUnion;
    private double m_dTolerance;
    private GeoLine m_edgeMatchLine;
    private Datasource m_outputDatasource;
    private String m_outputDatasetLinkName;
    private EdgeMatchAttributeMethod m_edgeMatchAttMethod;
    private ArrayList m_sourceFields;
    private ArrayList m_targetFields;

    public EdgeMatchParameter() {
        this.m_edgeMatchMode = EdgeMatchMode.THEMIDPOINT;
        this.m_bIsUnion = false;
        this.m_dTolerance = 0.0;
        this.m_edgeMatchLine = null;
        this.m_outputDatasource = null;
        this.m_outputDatasetLinkName = null;
        this.m_edgeMatchAttMethod = EdgeMatchAttributeMethod.THENOTNULL;
    }

    public EdgeMatchParameter(EdgeMatchParameter parameter) {
        this.setEdgeMatchMode(parameter.getEdgeMatchMode());
        this.setUnion(parameter.isUnion());
        this.setTolerance(parameter.getTolerance());
        this.setEdgeMatchLine(parameter.getEdgeMatchLine());
        this.setOutputDatasource(parameter.getOutputDatasource());
        this.setOutputDatasetLinkName(parameter.getOutputDatasetLinkName());
        this.setEdgeMatchAttributeMethod(parameter.getEdgeMatchAttributeMethod());
        this.setSourceFieldNames(parameter.getSourceFieldNames());
        this.setTargetFieldNames(parameter.getTargetFieldNames());
    }

    public boolean isUnion() {
        return this.m_bIsUnion;
    }

    public void setUnion(boolean value) {
        this.m_bIsUnion = value;
    }

    public EdgeMatchMode getEdgeMatchMode() {
        return this.m_edgeMatchMode;
    }

    public void setEdgeMatchMode(EdgeMatchMode value) {
        this.m_edgeMatchMode = value;
    }

    public double getTolerance() {
        return this.m_dTolerance;
    }

    public void setTolerance(double value) {
        this.m_dTolerance = value;
    }

    public GeoLine getEdgeMatchLine() {
        return this.m_edgeMatchLine;
    }

    public void setEdgeMatchLine(GeoLine value) {
        this.m_edgeMatchLine = value;
    }

    public Datasource getOutputDatasource() {
        return this.m_outputDatasource;
    }

    public void setOutputDatasource(Datasource value) {
        this.m_outputDatasource = value;
    }

    public String getOutputDatasetLinkName() {
        return this.m_outputDatasetLinkName;
    }

    public void setOutputDatasetLinkName(String value) {
        this.m_outputDatasetLinkName = value;
    }

    public EdgeMatchAttributeMethod getEdgeMatchAttributeMethod() {
        return this.m_edgeMatchAttMethod;
    }

    public void setEdgeMatchAttributeMethod(EdgeMatchAttributeMethod value) {
        this.m_edgeMatchAttMethod = value;
    }

    public String[] getSourceFieldNames() {
        if (this.m_sourceFields == null) {
            return null;
        }
        int n = this.m_sourceFields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_sourceFields.get(i).toString();
        }
        return stringArray;
    }

    public void setSourceFieldNames(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_sourceFields != null) {
            this.m_sourceFields.clear();
        } else {
            this.m_sourceFields = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.m_sourceFields.add(value[n]);
        }
    }

    public String[] getTargetFieldNames() {
        if (this.m_targetFields == null) {
            return null;
        }
        int n = this.m_targetFields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_targetFields.get(i).toString();
        }
        return stringArray;
    }

    public void setTargetFieldNames(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_targetFields != null) {
            this.m_targetFields.clear();
        } else {
            this.m_targetFields = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.m_targetFields.add(value[n]);
        }
    }
}

