/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionProportionBParameter
extends SamplingFunctionParameter {
    private double m_dProportion = 0.0;
    private double m_dRelativeError = 0.0;
    private double m_dSignificanceLevel = 0.0;

    private SamplingFunctionProportionBParameter() {
    }

    public SamplingFunctionProportionBParameter(double dProportion, double dRelativeError, double dSignificanceLevel) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONPROPORTIONB;
        this.setProportion(dProportion);
        this.setRelativeError(dRelativeError);
        this.setSignificanceLevel(dSignificanceLevel);
    }

    public double getProportion() {
        return this.m_dProportion;
    }

    public void setProportion(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("Proportion", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dProportion = value;
    }

    public double getRelativeError() {
        return this.m_dRelativeError;
    }

    public void setRelativeError(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("RelativeError", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dRelativeError = value;
    }

    public double getSignificanceLevel() {
        return this.m_dSignificanceLevel;
    }

    public void setSignificanceLevel(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("SignificanceLevel", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dSignificanceLevel = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setProportion1(handle, this.m_dProportion);
        SamplingParameterNative.jni_setRelativeError(handle, this.m_dRelativeError);
        SamplingParameterNative.jni_setSignificanceLevel(handle, this.m_dSignificanceLevel);
    }
}

