/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.AllocationAnalystResultNative;
import com.supermap.analyst.networkanalyst.DemandResult;
import com.supermap.analyst.networkanalyst.InternalGeometry;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.data.GeoLineM;

public class AllocationAnalystResult
extends InternalHandleDisposable {
    private DemandResult[] m_demandResult = null;
    private GeoLineM[] m_routes = null;
    private int[][] m_nodes = null;
    private int[][] m_edges = null;

    AllocationAnalystResult(long handle) {
        this.setHandle(handle, true);
    }

    public DemandResult[] getDemandResults() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetDemandResults()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = AllocationAnalystResultNative.jni_GetDemandResults(this.getHandle());
        if (this.m_demandResult == null) {
            if (lArray.length > 0) {
                this.m_demandResult = new DemandResult[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    this.m_demandResult[i] = new DemandResult(lArray[i]);
                }
            } else {
                this.m_demandResult = new DemandResult[0];
            }
        }
        return this.m_demandResult;
    }

    public GeoLineM[] getRoutes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoutes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = AllocationAnalystResultNative.jni_GetRoutes(this.getHandle());
        if (this.m_routes == null) {
            if (lArray.length > 0) {
                this.m_routes = new GeoLineM[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    this.m_routes[i] = (GeoLineM)InternalGeometry.createInstance(lArray[i]);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_routes[i], false);
                }
            } else {
                this.m_routes = new GeoLineM[0];
            }
        }
        return this.m_routes;
    }

    public int[][] getNodes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNodes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_nodes == null) {
            int n = AllocationAnalystResultNative.jni_GetNodeCount(this.getHandle());
            if (n > 0) {
                this.m_nodes = new int[n][];
                int[] nArray = new int[n];
                AllocationAnalystResultNative.jni_GetNodeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_nodes[i] = new int[nArray[i]];
                }
                AllocationAnalystResultNative.jni_GetNodes(this.getHandle(), (Object[])this.m_nodes);
            } else {
                this.m_nodes = new int[0][0];
            }
        }
        return this.m_nodes;
    }

    public int[][] getEdges() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEdges()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_edges == null) {
            int n = AllocationAnalystResultNative.jni_GetEdgeCount(this.getHandle());
            if (n > 0) {
                this.m_edges = new int[n][];
                int[] nArray = new int[n];
                AllocationAnalystResultNative.jni_GetEdgeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_edges[i] = new int[nArray[i]];
                }
                AllocationAnalystResultNative.jni_GetEdges(this.getHandle(), (Object[])this.m_edges);
            } else {
                this.m_edges = new int[0][0];
            }
        }
        return this.m_edges;
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            AllocationAnalystResultNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

