/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetTopologyNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalResource;

public class TopologyDatasetRelationItem {
    private DatasetTopology m_datasetTopology;
    private DatasetVector m_datasetVector;
    private int m_precisionOrder;
    private int m_index;
    private boolean isUserItem = false;

    public TopologyDatasetRelationItem(DatasetVector dataset) {
        this.m_datasetVector = dataset;
        this.m_precisionOrder = 1;
        this.isUserItem = false;
    }

    public TopologyDatasetRelationItem(DatasetVector dataset, int precisionOrder) {
        if (precisionOrder < 1 || precisionOrder > 5) {
            String string = InternalResource.loadString("precisionOrder", "TopologyDatasetRelationItem_PrecisionOrderOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasetVector = dataset;
        this.m_precisionOrder = precisionOrder;
        this.isUserItem = false;
    }

    TopologyDatasetRelationItem(DatasetTopology datasetTopology, int index) {
        long l = datasetTopology.getHandle();
        this.m_datasetTopology = datasetTopology;
        this.m_index = index;
        String string = DatasetTopologyNative.jni_GetDatasetVector(l, this.m_index);
        Dataset dataset = datasetTopology.getDatasource().getDatasets().get(string);
        if (dataset != null) {
            this.m_datasetVector = (DatasetVector)dataset;
        }
        this.m_precisionOrder = DatasetTopologyNative.jni_GetPrecisionOrder(l, this.m_index);
        this.isUserItem = true;
    }

    public DatasetVector getDataset() {
        if (this.isUserItem && (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L)) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasetVector;
    }

    public int getPrecisionOrder() {
        if (this.isUserItem && (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L)) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_precisionOrder;
    }

    public void setPrecisionOrder(int value) {
        if (this.isUserItem) {
            if (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L) {
                String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            long l = this.m_datasetTopology.getHandle();
            DatasetTopologyNative.jni_SetPrecisionOrder(l, this.m_index, value);
        }
        if (value < 1 || value > 5) {
            String string = InternalResource.loadString("value", "TopologyDatasetRelationItem_PrecisionOrderOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_precisionOrder = value;
    }
}

