/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBox;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material3D;
import com.supermap.data.Material3DPBR;
import com.supermap.data.MaterialType;
import com.supermap.data.Model;
import com.supermap.data.ModelEntityManager;
import com.supermap.data.Point3D;
import com.supermap.data.SkeletonNative;
import java.awt.Color;
import java.util.ArrayList;

public class Skeleton
extends InternalHandleDisposable {
    private Material3D m_pMaterial3D;
    private boolean m_isSkeDisposable;
    private long[] m_pPacks = new long[3];

    protected Skeleton(long srcHandle, ModelEntityManager pEM) {
        long l = SkeletonNative.jni_New(srcHandle);
        this.setHandle(l, false);
        this.m_isSkeDisposable = true;
        long l2 = SkeletonNative.jni_GetMaterial_pEM(srcHandle, pEM.getHandle());
        this.m_pMaterial3D = new Material3D(l2, pEM);
    }

    protected Skeleton(long srcHandle, Model model) {
        long l = SkeletonNative.jni_New(srcHandle);
        this.setHandle(l, false);
        this.m_isSkeDisposable = true;
        String string = SkeletonNative.jni_GetMaterialName(srcHandle);
        this.m_pMaterial3D = model.getMaterial(string);
    }

    public Skeleton() {
        this.m_pMaterial3D = new Material3D();
        long l = SkeletonNative.jni_New();
        SkeletonNative.jni_SetMaterialName(l, this.m_pMaterial3D.getName());
        this.setHandle(l, true);
        this.m_isSkeDisposable = true;
        this.m_pPacks[0] = 0L;
        this.m_pPacks[1] = 0L;
        this.m_pPacks[2] = 0L;
    }

    public Skeleton(String name) {
        this.m_pMaterial3D = new Material3D();
        long l = SkeletonNative.jni_New(name);
        SkeletonNative.jni_SetMaterialName(l, this.m_pMaterial3D.getName());
        this.setHandle(l, true);
        this.m_isSkeDisposable = true;
        this.m_pPacks[0] = 0L;
        this.m_pPacks[1] = 0L;
        this.m_pPacks[2] = 0L;
    }

    public Skeleton(Skeleton skeletonSrc) {
        long l = InternalHandle.getHandle(skeletonSrc);
        long l2 = SkeletonNative.jni_New(l);
        this.setHandle(l2, true);
        this.m_isSkeDisposable = true;
        this.m_pMaterial3D = new Material3D(skeletonSrc.getMaterial());
    }

    @Override
    public void dispose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.m_isSkeDisposable) {
            SkeletonNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this.m_pMaterial3D.ClearHandle();
        for (int i = 0; i < this.m_pPacks.length; ++i) {
            this.m_pPacks[i] = 0L;
        }
        this.m_pPacks = null;
    }

    public boolean isClosed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_IsClosed(this.getHandle());
    }

    public boolean setVertices(double[] Vertices) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (Vertices == null) {
            String string = InternalResource.loadString("Vertices", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_SetVertices(this.getHandle(), Vertices, this.m_pPacks);
    }

    public boolean setVertices(float[] Vertices) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (Vertices == null) {
            String string = InternalResource.loadString("Vertices", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_SetVertices2(this.getHandle(), Vertices, this.m_pPacks);
    }

    public boolean isSameWith(Skeleton skeletonCompared) {
        if (skeletonCompared == null) {
            String string = InternalResource.loadString("skeletonCompared", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_IsSameWith(this.getHandle(), skeletonCompared.getHandle());
    }

    public boolean check() {
        String string;
        String string2 = SkeletonNative.jni_GetMaterialName(this.getHandle());
        if (!string2.equals(string = this.m_pMaterial3D.getName())) {
            return false;
        }
        return this.m_pMaterial3D.check();
    }

    public BoundingBox getBoundingBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        SkeletonNative.jni_GetBoundingBox(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        Point3D point3D2 = new Point3D(dArray[3], dArray[4], dArray[5]);
        BoundingBox boundingBox = new BoundingBox(point3D, point3D2);
        return boundingBox;
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SkeletonNative.jni_SetName(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_GetName(this.getHandle());
    }

    public void setMaterial(Material3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        SkeletonNative.jni_SetMaterialName(this.getHandle(), value.getName());
        if (this.m_pMaterial3D != null) {
            this.m_pMaterial3D.dispose();
            this.m_pMaterial3D = null;
        }
        this.m_pMaterial3D = value.getMaterialType() == MaterialType.COMMON ? new Material3D(value) : new Material3DPBR((Material3DPBR)value);
    }

    public Material3D getMaterial() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pMaterial3D.getMaterialType() == MaterialType.COMMON) {
            return new Material3D(this.m_pMaterial3D);
        }
        return new Material3DPBR((Material3DPBR)this.m_pMaterial3D);
    }

    public int[] getIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_GetIndexes(this.getHandle(), false);
    }

    public void setIndexes(int[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pPacks[0] == 0L && this.m_pPacks[1] == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        SkeletonNative.jni_SetIndexes(this.getHandle(), value, false, false, this.m_pPacks, this.m_pMaterial3D.getHandle());
    }

    public float[] getNormals() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_GetNormals(this.getHandle());
    }

    public void setNormals(float[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pPacks[0] == 0L && this.m_pPacks[1] == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        SkeletonNative.jni_SetNormals(value, this.m_pPacks);
    }

    public ArrayList<float[]> getTextureCoords() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        Object[] objectArray = SkeletonNative.jni_GetTextureCoords(this.getHandle());
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                float[] fArray = (float[])objectArray[i];
                if (fArray == null) continue;
                arrayList.add(fArray);
            }
        }
        return arrayList;
    }

    public void setTextureCoords(ArrayList<float[]> listValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (listValues == null) {
            String string = InternalResource.loadString("listValues", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        for (int i = 0; i < listValues.size(); ++i) {
            float[] fArray = listValues.get(i);
            if (fArray == null) {
                String string = InternalResource.loadString("vlues", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            SkeletonNative.jni_SetTextureCoord(i, fArray, this.m_pPacks);
        }
    }

    public int[] getTextureIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_GetIndexes(this.getHandle(), true);
    }

    public void setTextureIndexes(int[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pPacks[0] == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SkeletonNative.jni_SetIndexes(this.getHandle(), value, true, true, this.m_pPacks, this.m_pMaterial3D.getHandle());
    }

    public int[] getVertexIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_GetIndexes(this.getHandle(), false);
    }

    public void setVertexIndexes(int[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pPacks[0] == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SkeletonNative.jni_SetIndexes(this.getHandle(), value, true, false, this.m_pPacks, this.m_pMaterial3D.getHandle());
    }

    public double[] getVertices() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SkeletonNative.jni_GetVertices(this.getHandle());
    }

    public Color[] getVertexColors() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = SkeletonNative.jni_GetVertexColors(this.getHandle());
        Color[] colorArray = new Color[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            int[] nArray = (int[])objectArray[i];
            colorArray[i] = new Color(nArray[1], nArray[2], nArray[3], nArray[0]);
        }
        return colorArray;
    }

    public void setVertexColors(Color[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skeleton", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            int[] nArray = new int[]{value[i].getAlpha(), value[i].getRed(), value[i].getGreen(), value[i].getBlue()};
            objectArray[i] = nArray;
        }
        SkeletonNative.jni_SetVertexColors(this.getHandle(), objectArray);
    }
}

