/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AttributeStatisticsType;
import com.supermap.data.Charset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.Feature;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalVariant;
import com.supermap.data.QueryParameter;
import com.supermap.data.RecordsetNative;
import com.supermap.data.Rectangle2D;
import com.supermap.data.RepresentationElement;
import com.supermap.data.RepresentationType;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.SpatialRelationType;
import com.supermap.data.StatisticMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class Recordset
extends InternalHandleDisposable {
    private DatasetVector m_datasetVector = null;
    private Object m_spatialQueryObject = null;
    private SpatialQueryMode m_queryMode = SpatialQueryMode.NONE;
    private BatchEditor m_batchEdit = null;
    private boolean m_begin = false;
    protected int m_fieldCount;
    private boolean m_isQueryCursorTypeStatic;
    protected FieldInfos m_fieldInfos;
    private boolean[] m_flag = new boolean[]{false};
    transient Vector m_steppedListeners;
    protected long m_selfEventHandle;

    protected Recordset() {
    }

    Recordset(long handle, DatasetVector datasetVector) {
        this.setHandle(handle, true);
        this.m_datasetVector = datasetVector;
        this.m_isQueryCursorTypeStatic = RecordsetNative.jni_IsCursorTypeStatic(this.getHandle());
        this.m_fieldInfos = new FieldInfos(RecordsetNative.jni_GetFieldInfos(this.getHandle()));
        this.m_fieldCount = this.m_fieldInfos.getCount();
    }

    public Rectangle2D getBounds() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        RecordsetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public DatasetVector getDataset() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasetVector;
    }

    public QueryParameter getQueryParameter() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = RecordsetNative.jni_GetQueryParameter(this.getHandle());
        QueryParameter queryParameter = new QueryParameter(l, this.m_spatialQueryObject, this.m_queryMode);
        queryParameter.setIsDisposable(true);
        return queryParameter;
    }

    public FieldInfos getFieldInfos() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this.m_fieldInfos);
    }

    public int getFieldCount() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_fieldCount = RecordsetNative.jni_GetFieldCount(this.getHandle());
        return this.m_fieldCount;
    }

    public boolean isClosed() {
        boolean bl = false;
        bl = this.m_datasetVector != null ? this.getHandle() == 0L || this.m_datasetVector.getHandle() == 0L || !this.m_datasetVector.isOpen() : true;
        if (bl) {
            this.setHandle(0L);
        }
        return bl;
    }

    public boolean isBOF() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsBOF(this.getHandle());
    }

    public boolean isEOF() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEOF(this.getHandle());
    }

    public boolean isEmpty() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEmpty(this.getHandle());
    }

    public boolean isReadOnly() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_isQueryCursorTypeStatic || this.m_datasetVector.isReadOnly();
    }

    public int getRecordCount() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetRecordCount(this.getHandle());
    }

    public boolean addNew(Geometry geometry) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        boolean bl = false;
        if (!this.m_begin) {
            if (geometry2 == null) {
                if (this.m_datasetVector.getType() == DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), 0L);
                }
            } else {
                long l = geometry2.getHandle();
                if (l == 0L) {
                    String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this.m_datasetVector.getType() != DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), l);
                }
            }
        } else if (geometry2 == null) {
            if (this.m_datasetVector.getType() == DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), 0L);
            }
        } else {
            long l = geometry2.getHandle();
            if (l == 0L) {
                String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_datasetVector.getType() != DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), l);
            }
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean addNew(Geometry geometry, Map<String, Object> map) {
        long l;
        int n;
        if (map == null) {
            return this.addNew(geometry);
        }
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        Object[] objectArray = map.keySet().toArray();
        int n2 = objectArray.length;
        Charset charset = Environment.getCurrentCharset();
        String[] stringArray = new String[n2];
        long[] lArray = new long[n2];
        InternalVariant[] internalVariantArray = new InternalVariant[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                Environment.setCurrentCharset(this.getDataset().getCharset());
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
                Environment.setCurrentCharset(charset);
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        if (!this.m_begin) {
            if (geometry2 == null) {
                if (this.m_datasetVector.getType() == DatasetType.TABULAR) {
                    n = RecordsetNative.jni_AddNew2(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
                }
            } else {
                l = geometry2.getHandle();
                if (l == 0L) {
                    String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this.m_datasetVector.getType() != DatasetType.TABULAR) {
                    n = RecordsetNative.jni_AddNew2(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
                }
            }
        } else if (geometry2 == null) {
            if (this.m_datasetVector.getType() == DatasetType.TABULAR) {
                n = RecordsetNative.jni_AddNew3(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
            }
        } else {
            l = geometry2.getHandle();
            if (l == 0L) {
                String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_datasetVector.getType() != DatasetType.TABULAR) {
                n = RecordsetNative.jni_AddNew3(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
            }
        }
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public boolean edit() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Edit(this.getHandle());
    }

    public boolean update() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_begin) {
            String string = InternalResource.loadString("", "Recordset_BatchEditorIsBeginning", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = RecordsetNative.jni_Update(this.getHandle());
        return bl;
    }

    public boolean cancelUpdate() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_CancelUpdate(this.getHandle());
    }

    public void close() {
        if (!this.isClosed()) {
            RecordsetNative.jni_Close(this.getHandle());
            this.clearHandle();
            if (this.m_fieldInfos != null) {
                this.m_fieldInfos.setIsDisposable(true);
                this.m_fieldInfos.dispose();
                this.m_fieldInfos = null;
            }
        }
    }

    public boolean delete() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Delete(this.getHandle());
    }

    public boolean deleteAll() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_DeleteAll(this.getHandle());
    }

    private void checkExceptionForGetFieldValueByIndex(int index) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_fieldCount) {
            String string = InternalResource.loadString("" + index, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public Object getFieldValue(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        FieldType fieldType = this.m_fieldInfos.get(index).getType();
        if (fieldType.equals(FieldType.INT32)) {
            Integer n = this.getInt32(index);
            if (this.m_flag[0]) {
                return null;
            }
            return n;
        }
        if (fieldType.equals(FieldType.INT64)) {
            Long l = this.getInt64(index);
            if (this.m_flag[0]) {
                return null;
            }
            return l;
        }
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16(index);
            if (this.m_flag[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals(FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(index);
            if (this.m_flag[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Short s = this.getByte(index);
            if (this.m_flag[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime(index);
            if (this.m_flag[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d = this.getDouble(index);
            if (this.m_flag[0]) {
                return null;
            }
            return d;
        }
        if (fieldType.equals(FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(index);
            if (this.m_flag[0]) {
                return null;
            }
            return byArray;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f = Float.valueOf(this.getSingle(index));
            if (this.m_flag[0]) {
                return null;
            }
            return f;
        }
        if (fieldType.equals(FieldType.TEXT) || fieldType.equals(FieldType.WTEXT)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public int getInt32(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        int n = RecordsetNative.jni_GetFieldValueIntByIndex(this.getHandle(), index, this.m_flag);
        return n;
    }

    public int getInt32(String name) {
        return this.getInt32(this.m_fieldInfos.indexOf(name));
    }

    public short getInt16(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        short s = RecordsetNative.jni_GetFieldValueShortByIndex(this.getHandle(), index, this.m_flag);
        return s;
    }

    public short getInt16(String name) {
        return this.getInt16(this.m_fieldInfos.indexOf(name));
    }

    public long getInt64(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        long l = RecordsetNative.jni_GetFieldValueLongByIndex(this.getHandle(), index, this.m_flag);
        return l;
    }

    public long getInt64(String name) {
        return this.getInt64(this.m_fieldInfos.indexOf(name));
    }

    public boolean getBoolean(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean bl = RecordsetNative.jni_GetFieldValueBooleanByIndex(this.getHandle(), index, this.m_flag);
        return bl;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(this.m_fieldInfos.indexOf(name));
    }

    public String getString(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        String string = RecordsetNative.jni_GetFieldValueTextByIndex(this.getHandle(), index, this.m_flag);
        return string;
    }

    public String getString(String name) {
        return this.getString(this.m_fieldInfos.indexOf(name));
    }

    public String getJsonB(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        String string = RecordsetNative.jni_GetFieldValueJsonBByIndex(this.getHandle(), index, this.m_flag);
        return string;
    }

    public String getJsonB(String name) {
        return this.getJsonB(this.m_fieldInfos.indexOf(name));
    }

    public Date getDateTime(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        Date date = this.getFieldValueDateTimeByIndex(index, this.m_flag);
        return date;
    }

    public Date getDateTime(String name) {
        int n = this.m_fieldInfos.indexOf(name);
        return this.getDateTime(n);
    }

    Date getFieldValueDateTimeByIndex(int index, boolean[] m_flag) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = RecordsetNative.jni_GetFieldValueDateByIndex(this.getHandle(), index, m_flag);
        if (string == null) {
            return null;
        }
        Date date = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public double getDouble(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        double d = RecordsetNative.jni_GetFieldValueDoubleByIndex(this.getHandle(), index, this.m_flag);
        return d;
    }

    public double getDouble(String name) {
        int n = this.m_fieldInfos.indexOf(name);
        return this.getDouble(n);
    }

    public float getSingle(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        float f = RecordsetNative.jni_GetFieldValueFloatByIndex(this.getHandle(), index, this.m_flag);
        return f;
    }

    public float getSingle(String name) {
        int n = this.m_fieldInfos.indexOf(name);
        return this.getSingle(n);
    }

    public short getByte(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        short s = RecordsetNative.jni_GetFieldValueByteByIndex(this.getHandle(), index, this.m_flag);
        return (short)(s & 0xFF);
    }

    public short getByte(String name) {
        int n = this.m_fieldInfos.indexOf(name);
        return this.getByte(n);
    }

    public byte[] getLongBinary(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        byte[] byArray = RecordsetNative.jni_GetFieldValueLongBinaryByIndex(this.getHandle(), index, this.m_flag);
        return byArray;
    }

    public byte[] getLongBinary(String name) {
        int n = this.m_fieldInfos.indexOf(name);
        return this.getLongBinary(n);
    }

    private void checkExceptionForGetFieldValueByName(String name) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public Object getFieldValue(String name) {
        this.checkExceptionForGetFieldValueByName(name);
        int n = this.m_fieldInfos.indexOf(name);
        if (n < 0) {
            String string = InternalResource.loadString(name, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.getFieldValue(n);
    }

    public Geometry getGeometry() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = RecordsetNative.jni_GetGeometry(this.getHandle());
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance2(l, this.getDataset().getDatasource().getWorkspace());
        if (null != geometry) {
            geometry.setIsDisposable(true);
        }
        return geometry;
    }

    public int getID() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetID(this.getHandle());
    }

    public int getCurrentIndex() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetCurrentIndex(this.getHandle());
    }

    public boolean move(int count) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Move(this.getHandle(), count);
    }

    public boolean moveFirst() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveFirst(this.getHandle());
    }

    public boolean moveLast() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveLast(this.getHandle());
    }

    public boolean moveNext() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveNext(this.getHandle());
    }

    public boolean movePrev() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MovePrev(this.getHandle());
    }

    public boolean moveTo(int position) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveTo(this.getHandle(), position);
    }

    public boolean refresh() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Refresh(this.getHandle());
    }

    public boolean seekID(int id) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = id < 0 ? false : RecordsetNative.jni_SeekID(this.getHandle(), id);
        return bl;
    }

    private void checkExcepitonForSetFieldValueByIndex(int index) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_fieldCount) {
            String string = InternalResource.loadString("" + index, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public boolean setFieldValue(int index, Object value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        FieldInfo fieldInfo = this.m_fieldInfos.get(index);
        if (fieldInfo.isSystemField()) {
            String string = InternalResource.loadString("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        FieldType fieldType = fieldInfo.getType();
        if (value == null) {
            bl = this.setFieldValueNull(index);
        } else {
            String string = value.toString();
            if (fieldType.equals(FieldType.BOOLEAN)) {
                bl = this.setBoolean(index, (boolean)((Boolean)value));
            } else if (fieldType.equals(FieldType.BYTE)) {
                bl = this.setByte(index, (short)((Byte)value).byteValue());
            } else if (fieldType.equals(FieldType.CHAR)) {
                bl = this.setFieldValueChar(index, (String)value);
            } else if (fieldType.equals(FieldType.DATETIME)) {
                Date date = null;
                if (value instanceof String) {
                    String string2;
                    Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                    if (pattern.matcher(string2 = (String)value).matches()) {
                        String string3 = System.getProperty("os.name").toLowerCase();
                        if (string3.equals("aix")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date = simpleDateFormat.parse(string2);
                            }
                            catch (ParseException parseException) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    date = simpleDateFormat.parse(string2);
                                }
                                catch (ParseException parseException2) {}
                            }
                        } else {
                            try {
                                date = DateFormat.getDateInstance().parse(string2);
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                } else {
                    date = (Date)value;
                }
                bl = this.setDateTime(index, date);
            } else {
                bl = fieldType.equals(FieldType.DOUBLE) ? (string.length() == 0 ? this.setDouble(index, 0.0) : this.setDouble(index, (double)Double.valueOf(string))) : (fieldType.equals(FieldType.INT16) ? (string.length() == 0 ? this.setDouble(index, 0.0) : this.setInt16(index, (short)Short.valueOf(string))) : (fieldType.equals(FieldType.INT32) ? (string.length() == 0 ? this.setDouble(index, 0.0) : this.setInt32(index, (int)Integer.valueOf(string))) : (fieldType.equals(FieldType.INT64) ? (string.length() == 0 ? this.setDouble(index, 0.0) : this.setInt64(index, (long)Long.valueOf(string))) : (fieldType.equals(FieldType.LONGBINARY) ? (string.length() == 0 ? this.setDouble(index, 0.0) : this.setLongBinary(index, (byte[])value)) : (fieldType.equals(FieldType.SINGLE) ? (string.length() == 0 ? this.setDouble(index, 0.0) : this.setSingle(index, Float.valueOf(string).floatValue())) : (fieldType.equals(FieldType.TEXT) || fieldType.equals(FieldType.WTEXT) ? (string.length() == 0 && !fieldInfo.isZeroLengthAllowed() ? false : this.setString(index, String.valueOf(string))) : false))))));
            }
        }
        return bl;
    }

    private void checkExceptionForSetFieldValueByName(String name) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public boolean setFieldValue(String name, Object value) {
        FieldInfo fieldInfo = this.m_fieldInfos.get(name);
        if (fieldInfo == null) {
            String string = InternalResource.loadString(name, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (fieldInfo.isSystemField()) {
            String string = InternalResource.loadString("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        FieldType fieldType = fieldInfo.getType();
        if (value == null) {
            bl = this.setFieldValueNull(name);
        } else {
            String string = value.toString();
            if (fieldType.equals(FieldType.BOOLEAN)) {
                bl = this.setBoolean(name, (boolean)((Boolean)value));
            } else if (fieldType.equals(FieldType.BYTE)) {
                bl = this.setByte(name, (short)((Byte)value).byteValue());
            } else if (fieldType.equals(FieldType.CHAR)) {
                bl = this.setFieldValueChar(name, (String)value);
            } else if (fieldType.equals(FieldType.DATETIME)) {
                Date date = null;
                if (value instanceof String) {
                    String string2;
                    Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                    if (pattern.matcher(string2 = (String)value).matches()) {
                        String string3 = System.getProperty("os.name").toLowerCase();
                        if (string3.equals("aix")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date = simpleDateFormat.parse(string2);
                            }
                            catch (ParseException parseException) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    date = simpleDateFormat.parse(string2);
                                }
                                catch (ParseException parseException2) {}
                            }
                        } else {
                            try {
                                date = DateFormat.getDateInstance().parse(string2);
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                } else {
                    date = (Date)value;
                }
                bl = this.setDateTime(name, date);
            } else {
                bl = fieldType.equals(FieldType.DOUBLE) ? (string.length() == 0 ? this.setDouble(name, 0.0) : this.setDouble(name, (double)Double.valueOf(string))) : (fieldType.equals(FieldType.INT16) ? (string.length() == 0 ? this.setDouble(name, 0.0) : this.setInt16(name, (short)Short.valueOf(string))) : (fieldType.equals(FieldType.INT32) ? (string.length() == 0 ? this.setDouble(name, 0.0) : this.setInt32(name, (int)Integer.valueOf(string))) : (fieldType.equals(FieldType.INT64) ? (string.length() == 0 ? this.setDouble(name, 0.0) : this.setInt64(name, (long)Long.valueOf(string))) : (fieldType.equals(FieldType.LONGBINARY) ? (string.length() == 0 ? this.setDouble(name, 0.0) : this.setLongBinary(name, (byte[])value)) : (fieldType.equals(FieldType.SINGLE) ? (string.length() == 0 ? this.setDouble(name, 0.0) : this.setSingle(name, Float.valueOf(string).floatValue())) : (fieldType.equals(FieldType.TEXT) || fieldType.equals(FieldType.WTEXT) ? (string.length() == 0 && !fieldInfo.isZeroLengthAllowed() ? false : this.setString(name, String.valueOf(string))) : false))))));
            }
        }
        return bl;
    }

    public boolean setByte(int index, short value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        return RecordsetNative.jni_setFieldValueByteByIndex(this.getHandle(), index, value);
    }

    public boolean setByte(String name, short value) {
        this.checkExceptionForSetFieldValueByName(name);
        if (value < 0 || value > 255) {
            throw new IllegalStateException("ValueOutOfRange");
        }
        return RecordsetNative.jni_setFieldValueByteByName(this.getHandle(), name, value);
    }

    public boolean setInt32(String name, int value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), name, value);
    }

    public boolean setInt32(int index, int value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        return RecordsetNative.jni_setFieldValueIntByIndex(this.getHandle(), index, value);
    }

    public boolean setInt16(String name, short value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), name, value);
    }

    public boolean setInt16(int index, short value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        return RecordsetNative.jni_setFieldValueShortByIndex2(this.getHandle(), index, value);
    }

    public boolean setInt64(String name, long value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), name, value);
    }

    public boolean setInt64(int index, long value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        String string = this.m_fieldInfos.get(index).getName();
        return RecordsetNative.jni_setFieldValueLongByIndex(this.getHandle(), index, value);
    }

    public boolean setDouble(String name, double value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), name, value);
    }

    public boolean setDouble(int index, double value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        return RecordsetNative.jni_setFieldValueDoubleByIndex(this.getHandle(), index, value);
    }

    public boolean setSingle(String name, float value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), name, value);
    }

    public boolean setSingle(int index, float value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        return RecordsetNative.jni_setFieldValueFloatByIndex(this.getHandle(), index, value);
    }

    public boolean setBoolean(String name, boolean value) {
        this.checkExceptionForGetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), name, value);
    }

    public boolean setBoolean(int index, boolean value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        return RecordsetNative.jni_setFieldValueBooleanByIndex(this.getHandle(), index, value);
    }

    private boolean setFieldValueChar(String name, String value) {
        return RecordsetNative.jni_setFieldValueCharByName(this.getHandle(), name, value);
    }

    private boolean setFieldValueChar(int index, String value) {
        return RecordsetNative.jni_setFieldValueCharByIndex(this.getHandle(), index, value);
    }

    public boolean setString(String name, String value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), name, value);
    }

    public boolean setString(int index, String value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        String string = this.m_fieldInfos.get(index).getName();
        return RecordsetNative.jni_setFieldValueTextByIndex(this.getHandle(), index, value);
    }

    public boolean setJsonB(String name, String value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueJsonBByName(this.getHandle(), name, value);
    }

    public boolean setJsonB(int index, String value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        String string = this.m_fieldInfos.get(index).getName();
        return RecordsetNative.jni_setFieldValueJsonBByName(this.getHandle(), string, value);
    }

    public boolean setLongBinary(String name, byte[] value) {
        this.checkExceptionForSetFieldValueByName(name);
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), name, value);
    }

    public boolean setLongBinary(int index, byte[] value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        String string = this.m_fieldInfos.get(index).getName();
        return RecordsetNative.jni_setFieldValueLongBinaryByIndex(this.getHandle(), index, value);
    }

    public boolean setDateTime(String name, Date value) {
        this.checkExceptionForSetFieldValueByName(name);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(value);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return RecordsetNative.jni_setFieldValueDateTimeByName(this.getHandle(), name, n, n2, n3, n4, n5, n6);
    }

    public boolean setDateTime(int index, Date value) {
        this.checkExcepitonForSetFieldValueByIndex(index);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(value);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return RecordsetNative.jni_setFieldValueDateTimeByIndex(this.getHandle(), index, n, n2, n3, n4, n5, n6);
    }

    public boolean setFieldValueNull(int index) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_fieldCount) {
            String string = InternalResource.loadString("" + index, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.m_fieldInfos.get(index).isSystemField()) {
            String string = InternalResource.loadString("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(index).isRequired()) {
            String string = InternalResource.loadString("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_SetFieldValueNullByIndex(this.getHandle(), index);
    }

    public boolean setFieldValueNull(String name) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), name);
        if (n < 0) {
            String string = InternalResource.loadString(name, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(n).isSystemField()) {
            String string = InternalResource.loadString("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(n).isRequired()) {
            String string = InternalResource.loadString("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_SetFieldValueNullByName(this.getHandle(), name);
    }

    public boolean setGeometry(Geometry geometry) {
        GeometryType geometryType;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType = this.getDataset().getType();
        if (!Recordset.checkDatasetAndGeometryType(datasetType, geometryType = geometry.getType())) {
            String string = InternalResource.loadString("geometry", "Recordset_DatasetTypeAndGeometryTypeIsDifferent", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RecordsetNative.jni_SetGeometry(this.getHandle(), geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public double statistic(int fieldIndex, StatisticMode mode) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldIndex < 0 || fieldIndex >= this.m_fieldCount) {
            String string = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        FieldType fieldType = this.m_fieldInfos.get(fieldIndex).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string = InternalResource.loadString("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_StatisticByIndex(this.getHandle(), fieldIndex, mode.getUGCValue());
    }

    public double statistic(String fieldName, StatisticMode mode) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldName == null || fieldName.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), fieldName);
        if (n < 0) {
            String string = InternalResource.loadString(fieldName, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        FieldType fieldType = this.m_fieldInfos.get(n).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT64 && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string = InternalResource.loadString("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_StatisticByName(this.getHandle(), fieldName, mode.getUGCValue());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
        }
    }

    public BatchEditor getBatch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetBatchEdit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_batchEdit == null) {
            this.m_batchEdit = new BatchEditor(this.getHandle());
        }
        return this.m_batchEdit;
    }

    void setQueryParameter(QueryParameter queryParameter) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getHandle() == 0L) {
            String string = InternalResource.loadString("queryParameter", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getSpatialQueryObject() != null) {
            this.m_spatialQueryObject = queryParameter.getSpatialQueryObject();
            this.m_queryMode = queryParameter.getSpatialQueryMode();
        }
        RecordsetNative.jni_SetQueryParameter(this.getHandle(), queryParameter.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(queryParameter);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        this.m_datasetVector = null;
        this.m_queryMode = null;
        this.m_spatialQueryObject = null;
    }

    protected static Recordset createInstance(long handle, DatasetVector datasetVector) {
        return new Recordset(handle, datasetVector);
    }

    static boolean checkDatasetAndGeometryType(DatasetType datasetType, GeometryType geometryType) {
        boolean bl = false;
        if (datasetType != null && geometryType != null) {
            if (datasetType == DatasetType.CAD) {
                bl = true;
            }
            if (datasetType == DatasetType.POINT && geometryType == GeometryType.GEOPOINT || (datasetType == DatasetType.LINE || datasetType == DatasetType.NETWORK) && geometryType == GeometryType.GEOLINE || datasetType == DatasetType.PARAMETRICLINE && geometryType == GeometryType.GEOPARAMETRICLINE || datasetType == DatasetType.PARAMETRICREGION && geometryType == GeometryType.GEOPARAMETRICREGION || datasetType == DatasetType.PARAMETRICPOINT && geometryType == GeometryType.GEOPARAMETRICPOINT || datasetType == DatasetType.PARAMETRICTEXT && geometryType == GeometryType.GEOPARAMETRICTEXT || datasetType == DatasetType.REGION && geometryType == GeometryType.GEOREGION || datasetType == DatasetType.VIDEO && geometryType == GeometryType.GEOREGION || datasetType == DatasetType.TEXT && geometryType == GeometryType.GEOTEXT || datasetType == DatasetType.LINEM && geometryType == GeometryType.GEOLINEM || datasetType == DatasetType.POINT3D && geometryType == GeometryType.GEOPOINT3D || datasetType == DatasetType.NETWORK3D && geometryType == GeometryType.GEOLINE3D || datasetType == DatasetType.NETWORK && geometryType == GeometryType.GEOLINE || datasetType == DatasetType.REGION3D && geometryType == GeometryType.GEOREGION3D || datasetType == DatasetType.MODEL && geometryType == GeometryType.GEOMODEL3D || datasetType == DatasetType.POINTEPS && geometryType == GeometryType.GEOPOINTEPS || datasetType == DatasetType.LINEEPS && geometryType == GeometryType.GEOLINEEPS || datasetType == DatasetType.REGIONEPS && geometryType == GeometryType.GEOREGIONEPS || datasetType == DatasetType.TEXTEPS && geometryType == GeometryType.GEOTEXTEPS || datasetType == DatasetType.LINE3D && geometryType == GeometryType.GEOLINE3D) {
                bl = true;
            }
        }
        return bl;
    }

    public RepresentationElement getRepresentationElement(String representationField) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (representationField == null || representationField.trim().length() == 0) {
            String string = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), representationField);
        if (n < 0) {
            String string = InternalResource.loadString(representationField, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[5];
        boolean bl = RecordsetNative.jni_GetRepresentationElement(this.getHandle(), representationField, lArray);
        if (bl) {
            RepresentationElement representationElement = new RepresentationElement();
            representationElement.setType((RepresentationType)Enum.parseUGCValue(RepresentationType.class, (int)lArray[0]));
            if (lArray[2] != 0L) {
                representationElement.setGeometry(Geometry.createInstance(lArray[2]).clone());
            }
            if (lArray[4] != 0L) {
                InternalVariant internalVariant = InternalVariant.createInstance(lArray[4]);
                Object object = internalVariant.toObject();
                internalVariant.dispose();
                internalVariant = null;
                representationElement.setCustomValue(object);
            }
            return representationElement;
        }
        return null;
    }

    public boolean setRepresentationElement(String representationField, RepresentationElement element) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (representationField == null || representationField.trim().length() == 0) {
            String string = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), representationField);
        if (n < 0) {
            String string = InternalResource.loadString(representationField, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(n).isSystemField()) {
            String string = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = InternalResource.loadString("element", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        return this.setRepresentationElement(representationField, element.getGeometry(), element.getType(), element.getCustomValue());
    }

    public boolean setRepresentationElement(String representationField, GeoStyle style, Object customValue) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (representationField == null || representationField.trim().length() == 0) {
            String string = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), representationField);
        if (n < 0) {
            String string = InternalResource.loadString(representationField, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(n).isSystemField()) {
            String string = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (customValue == null) {
            bl = style == null ? RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), representationField, 0L, 0L) : RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), representationField, style.getHandle(), 0L);
        } else {
            if (!InternalVariant.isSupportedInstance(customValue)) {
                String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
            InternalVariant internalVariant = new InternalVariant(customValue);
            bl = style == null ? RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), representationField, 0L, internalVariant.getHandle()) : RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), representationField, style.getHandle(), internalVariant.getHandle());
        }
        return bl;
    }

    public boolean setRepresentationElement(String representationField, TextStyle style, Object customValue) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (representationField == null || representationField.trim().length() == 0) {
            String string = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), representationField);
        if (n < 0) {
            String string = InternalResource.loadString(representationField, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(n).isSystemField()) {
            String string = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (customValue == null) {
            bl = style == null ? RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), representationField, 0L, 0L) : RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), representationField, style.getHandle(), 0L);
        } else {
            if (!InternalVariant.isSupportedInstance(customValue)) {
                String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
            InternalVariant internalVariant = new InternalVariant(customValue);
            bl = style == null ? RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), representationField, 0L, internalVariant.getHandle()) : RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), representationField, style.getHandle(), internalVariant.getHandle());
        }
        return bl;
    }

    public boolean setRepresentationElement(String representationField, Geometry geometry, RepresentationType type, Object customValue) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (representationField == null || representationField.trim().length() == 0) {
            String string = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry != null && geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), representationField);
        if (n < 0) {
            String string = InternalResource.loadString(representationField, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fieldInfos.get(n).isSystemField()) {
            String string = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (type.equals(RepresentationType.STYLE)) {
            if (geometry != null) {
                bl = geometry.getType().equals(GeometryType.GEOTEXT) ? this.setRepresentationElement(representationField, ((GeoText)geometry).getTextStyle(), customValue) : this.setRepresentationElement(representationField, geometry.getStyle(), customValue);
            }
        } else if (customValue == null) {
            bl = geometry == null ? RecordsetNative.jni_SetRepresentationElement(this.getHandle(), representationField, 0L, type.getUGCValue(), 0L) : RecordsetNative.jni_SetRepresentationElement(this.getHandle(), representationField, geometry.getHandle(), type.getUGCValue(), 0L);
        } else {
            if (!InternalVariant.isSupportedInstance(customValue)) {
                String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
            InternalVariant internalVariant = new InternalVariant(customValue);
            bl = geometry == null ? RecordsetNative.jni_SetRepresentationElement(this.getHandle(), representationField, 0L, type.getUGCValue(), internalVariant.getHandle()) : RecordsetNative.jni_SetRepresentationElement(this.getHandle(), representationField, geometry.getHandle(), type.getUGCValue(), internalVariant.getHandle());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public boolean wasNull() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_flag[0];
    }

    public boolean setValues(Map<String, Object> map) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_begin) {
            int n2 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n3 = this.m_fieldInfos.indexOf(string);
                if (n3 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n3, object);
                ++n2;
            }
            return n2 > 0;
        }
        Object[] objectArray = map.keySet().toArray();
        int n4 = objectArray.length;
        Charset charset = Environment.getCurrentCharset();
        String[] stringArray = new String[n4];
        long[] lArray = new long[n4];
        InternalVariant[] internalVariantArray = new InternalVariant[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                Environment.setCurrentCharset(this.getDataset().getCharset());
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
                Environment.setCurrentCharset(charset);
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        return n != 0;
    }

    public boolean setValues(Map<String, Object> map, Geometry geometry) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_begin) {
            this.setGeometry(geometry);
            int n2 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n3 = this.m_fieldInfos.indexOf(string);
                if (n3 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n3, object);
                ++n2;
            }
            return n2 > 0;
        }
        if (!this.m_datasetVector.getDatasource().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Geometry geometry2 = geometry;
        long l = 0L;
        if (geometry2 != null) {
            l = geometry2.getHandle();
        }
        Charset charset = Environment.getCurrentCharset();
        Object[] objectArray = map.keySet().toArray();
        int n4 = objectArray.length;
        String[] stringArray = new String[n4];
        long[] lArray = new long[n4];
        InternalVariant[] internalVariantArray = new InternalVariant[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                Environment.setCurrentCharset(this.getDataset().getCharset());
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
                Environment.setCurrentCharset(charset);
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), l, true, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public boolean setValues(Object[] values) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (values.length != this.m_fieldCount) {
            String string = InternalResource.loadString("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_begin) {
            for (int i = 0; i < values.length; ++i) {
                boolean bl;
                if (this.m_fieldInfos.get(i).isSystemField() || (bl = this.setFieldValue(i, values[i]))) continue;
                return false;
            }
            return true;
        }
        if (!this.m_datasetVector.getDatasource().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Charset charset = Environment.getCurrentCharset();
        String[] stringArray = new String[values.length];
        long[] lArray = new long[values.length];
        InternalVariant[] internalVariantArray = new InternalVariant[values.length];
        for (n = 0; n < values.length; ++n) {
            if (this.m_fieldInfos.get(n).isSystemField()) continue;
            stringArray[n] = this.m_fieldInfos.get(n).getName();
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            Environment.setCurrentCharset(this.getDataset().getCharset());
            internalVariantArray[n] = new InternalVariant(values[n]);
            Environment.setCurrentCharset(charset);
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        return n != 0;
    }

    public boolean setValues(Object[] values, Geometry geometry) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (values.length != this.m_fieldCount) {
            String string = InternalResource.loadString("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_begin) {
            this.setGeometry(geometry);
            for (int i = 0; i < values.length; ++i) {
                boolean bl;
                if (this.m_fieldInfos.get(i).isSystemField() || (bl = this.setFieldValue(i, values[i]))) continue;
                return false;
            }
            return true;
        }
        if (!this.m_datasetVector.getDatasource().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Charset charset = Environment.getCurrentCharset();
        Geometry geometry2 = geometry;
        long l = geometry2.getHandle();
        String[] stringArray = new String[values.length];
        long[] lArray = new long[values.length];
        InternalVariant[] internalVariantArray = new InternalVariant[values.length];
        for (n = 0; n < values.length; ++n) {
            if (this.m_fieldInfos.get(n).isSystemField()) continue;
            stringArray[n] = this.m_fieldInfos.get(n).getName();
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            Environment.setCurrentCharset(this.getDataset().getCharset());
            internalVariantArray[n] = new InternalVariant(values[n]);
            Environment.setCurrentCharset(charset);
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), l, true, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public Object[] getValues() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = new Object[this.m_fieldCount];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getFieldValue(i);
        }
        return objectArray;
    }

    public boolean setObject(int index, Object value) {
        return this.setFieldValue(index, value);
    }

    public boolean setObject(String name, Object value) {
        return this.setFieldValue(name, value);
    }

    public Object getObject(int index) {
        return this.getFieldValue(index);
    }

    public Object getObject(String name) {
        return this.getFieldValue(name);
    }

    public Feature getFeature() {
        long l = RecordsetNative.jni_GetFeature(this.getHandle());
        if (0L == l) {
            throw new OutOfMemoryError("OutOfMemory");
        }
        Feature feature = new Feature(l);
        return feature;
    }

    public Map<Integer, Feature> getAllFeatures() {
        HashMap<Integer, Feature> hashMap = new HashMap<Integer, Feature>(this.getRecordCount());
        this.moveFirst();
        while (!this.isEOF()) {
            Feature feature = this.getFeature();
            hashMap.put(feature.getID(), feature);
            this.moveNext();
        }
        return hashMap;
    }

    public boolean updateFields(DatasetVector sourceDataset, SpatialRelationType spatialRelationType, String[] sourceFields, String[] targetFields, AttributeStatisticsType attributeStatisticsType, boolean isBorderInside, String errorName, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetFields == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_UpdateFields1(this.getHandle(), sourceDataset.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), sourceFields, targetFields, isBorderInside, errorName, isShowProgress, this.m_selfEventHandle);
    }

    public boolean updateFields(Recordset sourceRecordset, SpatialRelationType spatialRelationType, String[] sourceFields, String[] targetFields, AttributeStatisticsType attributeStatisticsType, boolean isBorderInside, String errorName, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset.getDataset().getType() != DatasetType.POINT && sourceRecordset.getDataset().getType() != DatasetType.LINE && sourceRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceFields == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetFields == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_UpdateFields2(this.getHandle(), sourceRecordset.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), sourceFields, targetFields, isBorderInside, errorName, isShowProgress, this.m_selfEventHandle);
    }

    public int[] getIDsByGeoRelation(DatasetVector sourceDataset, SpatialRelationType spatialRelationType, boolean isBorderInside, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_GetIDsByGeoRelation1(this.getHandle(), sourceDataset.getHandle(), spatialRelationType.value(), isBorderInside, isShowProgress, this.m_selfEventHandle);
    }

    public int[] getIDsByGeoRelation(Recordset sourceRecordset, SpatialRelationType spatialRelationType, boolean isBorderInside, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset.getDataset().getType() != DatasetType.POINT && sourceRecordset.getDataset().getType() != DatasetType.LINE && sourceRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_GetIDsByGeoRelation2(this.getHandle(), sourceRecordset.getHandle(), spatialRelationType.value(), isBorderInside, isShowProgress, this.m_selfEventHandle);
    }

    public int[] getIDsByGeoRelation(Geometry[] sourceGeometries, SpatialRelationType spatialRelationType, boolean isBorderInside, boolean isShowProgress) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries.length == 0) {
            String string = InternalResource.loadString("sourceGeometries.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries[0] == null) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = sourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long[] lArray = new long[sourceGeometries.length];
        for (int i = 0; i < sourceGeometries.length; ++i) {
            Geometry geometry = sourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Geometry_Type_Must_Be_Same", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geometry.getHandle();
            hashSet.add(geometry.getID());
        }
        if (hashSet.size() != sourceGeometries.length) {
            String string = InternalResource.loadString("sourceGeometries", "Geometry_Type_Must_Be_Same", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        int[] nArray = RecordsetNative.jni_GetIDsByGeoRelation3(this.getHandle(), lArray, spatialRelationType.value(), isBorderInside, isShowProgress, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return nArray;
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public boolean toDatasetVectorWithSmID(String strName, DatasetType datasetType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = datasetType.value();
        return RecordsetNative.jni_ToDatasetVectorWithSmID(this.getHandle(), strName, n);
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(Recordset source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent(source, percent, remainTime, title, message, null, bl);
            source.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(source);
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            RecordsetNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public class BatchEditor {
        private int m_maxRecordCount = 1024;
        long handle = 0L;

        private BatchEditor(long handle) {
            this.handle = handle;
        }

        public void begin() {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("Begin()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_setMaxRecordCount(this.handle, this.m_maxRecordCount);
            boolean bl2 = RecordsetNative.jni_begin(this.handle, true);
            Recordset.this.m_begin = true;
        }

        public void update() {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("Update()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_Update1(this.handle);
            if (bl) {
                Recordset.this.m_begin = false;
                RecordsetNative.jni_begin(this.handle, false);
            }
        }

        public void cancel() {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("Cancel()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_CancelUpdate1(this.handle);
            if (bl) {
                Recordset.this.m_begin = false;
                RecordsetNative.jni_begin(this.handle, false);
            }
        }

        public void setMaxRecordCount(int value) {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("SetMaxRecordCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (value < 0) {
                String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "data_resources");
                throw new IllegalStateException(string);
            }
            if (Recordset.this.m_begin) {
                String string = InternalResource.loadString("SetMaxRecordCount(int value)", "SetMaxRecordCount_Must_BeforeBegin", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_maxRecordCount = value;
        }

        public int getMaxRecordCount() {
            return this.m_maxRecordCount;
        }
    }
}

