/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetMosaicNative;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalResource;
import com.supermap.data.MosaicPixelValues;
import com.supermap.data.MosaicToolkitNative;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.PyramidResampleType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TiffCompressType;
import java.awt.Point;
import java.io.File;
import java.util.HashMap;

public class MosaicToolkit {
    public static HashMap<Integer, String> getAllFiles(DatasetMosaic datasetMosaic, Boolean containsOverviews) {
        MosaicToolkit.checkExceptionDatasetMosaic(datasetMosaic);
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, null, 0L);
    }

    public static HashMap<Integer, String> getFilesByBounds(DatasetMosaic datasetMosaic, Rectangle2D extractBounds, Boolean containsOverviews) {
        MosaicToolkit.checkExceptionDatasetMosaic(datasetMosaic);
        if (extractBounds.isEmpty()) {
            String string = InternalResource.loadString("extractBounds", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{extractBounds.getLeft(), extractBounds.getBottom(), extractBounds.getRight(), extractBounds.getTop()};
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, dArray, 0L);
    }

    public static HashMap<Integer, String> getFilesByGeoRegion(DatasetMosaic datasetMosaic, GeoRegion extractRegion, Boolean containsOverviews) {
        MosaicToolkit.checkExceptionDatasetMosaic(datasetMosaic);
        if (extractRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_GetMosaicFilePaths(datasetMosaic.getHandle(), containsOverviews, null, extractRegion.getHandle());
    }

    public static boolean hasPyramid(String filePath) {
        MosaicToolkit.checkExceptionFilePath(filePath);
        File file = new File(filePath);
        if (file.isDirectory()) {
            String string = InternalResource.loadString("filePath", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            return false;
        }
        return MosaicToolkitNative.jni_HasPyramid(filePath);
    }

    public static boolean buildPyramid(String filePath, PyramidResampleType type) {
        return MosaicToolkit.buildPyramid(filePath, type, TiffCompressType.LZW);
    }

    public static boolean buildPyramid(String filePath, PyramidResampleType type, TiffCompressType compressType) {
        MosaicToolkit.checkExceptionFilePath(filePath);
        File file = new File(filePath);
        if (file.isDirectory()) {
            String string = InternalResource.loadString("filePath", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_BuildPyramid(filePath, type.getUGCValue(), compressType.getUGCValue());
    }

    public static MosaicPixelValues getValue(DatasetMosaic datasetMosaic, Point2D point2D) {
        MosaicToolkit.checkExceptionDatasetMosaic(datasetMosaic);
        double[] dArray = new double[]{point2D.x, point2D.y};
        double[] dArray2 = new double[15];
        MosaicPixelValues mosaicPixelValues = new MosaicPixelValues();
        mosaicPixelValues.m_filePath = MosaicToolkitNative.jni_GetValue(datasetMosaic.getHandle(), dArray, dArray2);
        if (mosaicPixelValues.m_filePath != null && mosaicPixelValues.m_filePath.length() > 1) {
            mosaicPixelValues.m_footPrintID = (int)dArray2[0];
            int n = (int)dArray2[1];
            mosaicPixelValues.m_pixelFormat = (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
            mosaicPixelValues.m_location = new Point((int)dArray2[2], (int)dArray2[3]);
            mosaicPixelValues.m_bandCount = (int)dArray2[4];
            mosaicPixelValues.m_dBandValues = new double[mosaicPixelValues.m_bandCount];
            for (int i = 0; i < mosaicPixelValues.m_bandCount; ++i) {
                mosaicPixelValues.m_dBandValues[i] = dArray2[i + 5];
            }
            return mosaicPixelValues;
        }
        return null;
    }

    public static String getFileInfo(String filePath) {
        if (filePath == null || filePath.length() < 1) {
            return null;
        }
        return MosaicToolkitNative.jni_GetFileInfo(filePath);
    }

    public static String checkMosaicFile(String filePath, boolean outputJsonOrXML) {
        MosaicToolkit.checkExceptionFilePath(filePath);
        return MosaicToolkitNative.jni_CheckMosaicFile(filePath, outputJsonOrXML);
    }

    public static String checkDatasetMosaic(DatasetMosaic datasetMosaic, boolean outputJsonOrXML) {
        MosaicToolkit.checkExceptionDatasetMosaic(datasetMosaic);
        return MosaicToolkitNative.jni_CheckDatasetMosaic(datasetMosaic.getHandle(), outputJsonOrXML);
    }

    private static void checkExceptionDatasetMosaic(DatasetMosaic datasetMosaic) {
        if (datasetMosaic == null) {
            String string = InternalResource.loadString("datasetMosaic", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetMosaic", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    private static void checkExceptionFilePath(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            String string = InternalResource.loadString("filePath", "Global_StringIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public static int defineOverview(DatasetMosaic datasetMosaic, String path, int maxWidth, int maxHeight, int ratio, boolean hasNoValue, double noValue, String defineFolder) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.length() < 1) {
            String string = InternalResource.loadString("path", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxWidth <= 0) {
            String string = InternalResource.loadString("maxWidth", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxHeight <= 0) {
            String string = InternalResource.loadString("maxHeight", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (ratio <= 0) {
            String string = InternalResource.loadString("ratio", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        return DatasetMosaicNative.jni_DefineOverview(datasetMosaic.getHandle(), path, maxWidth, maxHeight, ratio, hasNoValue, noValue, defineFolder);
    }

    public static int createOverviewFile(String defineFile) {
        if (defineFile == null || defineFile.trim().length() < 1) {
            String string = InternalResource.loadString("defineFile", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(defineFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("defineFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetMosaicNative.jni_CreateOverviewFile(0L, defineFile);
    }

    public static boolean createCOGCopy(String srcFile, String destFile, int resampleType, int nCompressType) {
        File file = new File(srcFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("srcFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (destFile == null || destFile.trim().length() < 1) {
            String string = InternalResource.loadString("destFile", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleType < 0) {
            String string = InternalResource.loadString("resampleType", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (nCompressType < 0) {
            String string = InternalResource.loadString("nCompressType", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_CreateCOG(srcFile, destFile, resampleType, nCompressType);
    }

    public static boolean isValidCOG(String srcFile) {
        File file = new File(srcFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("srcFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_ValidateCOGFile(srcFile);
    }

    public static String testDataAccessSpeed(DatasetMosaic datasetMosaic, int tileCount, int pyramidLevel) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (tileCount < 0) {
            String string = InternalResource.loadString("tileCount", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_testFileAccessSpeed(datasetMosaic.getHandle(), tileCount, pyramidLevel);
    }

    public static String testSingleFileAccessSpeed(String srcFile, int testCount, int pyramidLevel) {
        File file = new File(srcFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("srcFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (testCount < 0) {
            String string = InternalResource.loadString("tileCount", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MosaicToolkitNative.jni_testSingleFileAccessSpeed(srcFile, testCount, pyramidLevel);
    }

    public static boolean refreshMetadata(DatasetMosaic datasetMosaic) {
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("defineOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MosaicToolkitNative.jni_RefreshMetadata(datasetMosaic.getHandle());
    }

    static {
        Environment.LoadWrapJ();
    }
}

