/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DotShowMode;
import com.supermap.data.GeoGraphicObjectNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry3D;
import com.supermap.data.GraphicObjectType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MarkPos;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.SubSymbol;
import com.supermap.data.SurroundLineType;
import com.supermap.data.TextStyle;
import java.awt.Color;

public class GeoGraphicObject
extends Geometry3D {
    public GeoGraphicObject() {
        long l = GeoGraphicObjectNative.jni_New();
        this.setHandle(l, true);
    }

    GeoGraphicObject(long handle) {
        this.setHandle(handle, false);
    }

    public GeoGraphicObject(GeoGraphicObject graphicObject) {
        if (graphicObject == null) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (graphicObject.getHandle() == 0L) {
            String string = InternalResource.loadString("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoGraphicObjectNative.jni_Clone(graphicObject.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(graphicObject);
    }

    public GeoGraphicObject(int libID, int Code) {
        long l = GeoGraphicObjectNative.jni_New();
        this.setHandle(l, true);
        this.setLibID(libID);
        this.setCode(Code);
    }

    @Override
    public GeoGraphicObject clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoGraphicObject(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoGraphicObjectNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public Rectangle2D getGOBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGOBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        GeoGraphicObjectNative.jni_GetGOBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public int getArrowHeadType() {
        return GeoGraphicObjectNative.jni_GetArrowHeadType(this.getHandle());
    }

    public void setArrowHeadType(int type) {
        GeoGraphicObjectNative.jni_SetArrowHeadType(this.getHandle(), type);
    }

    public int getArrowTailType() {
        return GeoGraphicObjectNative.jni_GetArrowTailType(this.getHandle());
    }

    public void setArrowTailType(int type) {
        GeoGraphicObjectNative.jni_SetArrowTailType(this.getHandle(), type);
    }

    public int getArrowBodyType() {
        return GeoGraphicObjectNative.jni_GetArrowBodyType(this.getHandle());
    }

    public void setArrowBodyType(int type) {
        GeoGraphicObjectNative.jni_SetArrowBodyType(this.getHandle(), type);
    }

    public TextStyle getTextStyle2D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoGraphicObjectNative.jni_GetTextStyle2D(this.getHandle());
        if (l == 0L) {
            return null;
        }
        TextStyle textStyle = new TextStyle(l);
        return textStyle;
    }

    public void setTextStyle2D(TextStyle textStyle2D) {
        if (textStyle2D == null) {
            GeoGraphicObjectNative.jni_SetTextStyle2D(this.getHandle(), 0L);
        } else {
            if (textStyle2D.getHandle() == 0L) {
                String string = InternalResource.loadString("textStyle2D", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            TextStyle textStyle = textStyle2D.clone();
            GeoGraphicObjectNative.jni_SetTextStyle2D(this.getHandle(), textStyle.getHandle());
            textStyle.dispose();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle2D);
    }

    public TextStyle getTextStyle3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoGraphicObjectNative.jni_GetTextStyle3D(this.getHandle());
        if (l == 0L) {
            return null;
        }
        TextStyle textStyle = new TextStyle(l);
        return textStyle;
    }

    public void setTextStyle3D(TextStyle textStyle3D) {
        if (textStyle3D == null) {
            GeoGraphicObjectNative.jni_SetTextStyle3D(this.getHandle(), 0L);
        } else {
            if (textStyle3D.getHandle() == 0L) {
                String string = InternalResource.loadString("textStyle3D", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            TextStyle textStyle = textStyle3D.clone();
            GeoGraphicObjectNative.jni_SetTextStyle3D(this.getHandle(), textStyle.getHandle());
            textStyle.dispose();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle3D);
    }

    public Point3D getScale2D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetScale2D(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setScale2D(Point3D scale2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetScale2D(this.getHandle(), scale2D.getX(), scale2D.getY(), scale2D.getZ());
    }

    public Point3D getRotate2D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotate2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetRotate2D(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setRotate2D(Point3D rotate2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotate2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetRotate2D(this.getHandle(), rotate2D.getX(), rotate2D.getY(), rotate2D.getZ());
    }

    public Point3D getRotate3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotate2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetRotate3D(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setRotate3D(Point3D rotate3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotate2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetRotate3D(this.getHandle(), rotate3D.getX(), rotate3D.getY(), rotate3D.getZ());
    }

    public Point3D getVectorScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVectorScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetVectorScale(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setVectorScale(Point3D vectorScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVectorScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetVectorScale(this.getHandle(), vectorScale.getX(), vectorScale.getY(), vectorScale.getZ());
    }

    public Point3D getVectorRotate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVectorRotate()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetVectorRotate(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setVectorRotate(Point3D vectorRotate) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVectorRotate()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetVectorRotate(this.getHandle(), vectorRotate.getX(), vectorRotate.getY(), vectorRotate.getZ());
    }

    public Point3D getModelScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModelScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetModelScale(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setModelScale(Point3D modelScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModelScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetModelScale(this.getHandle(), modelScale.getX(), modelScale.getY(), modelScale.getZ());
    }

    public Point3D getModelRotate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModelRotate()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoGraphicObjectNative.jni_GetModelRotate(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setModelRotate(Point3D modelRotate) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModelRotate()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetModelRotate(this.getHandle(), modelRotate.getX(), modelRotate.getY(), modelRotate.getZ());
    }

    public void setScale3D(double x) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetScale3D(this.getHandle(), x);
    }

    public double getScale3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetScale3D(this.getHandle());
    }

    public int getLibID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetLibId(this.getHandle());
    }

    public void setLibID(int libId) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibId()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetLibId(this.getHandle(), libId);
    }

    public int getCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetCode(this.getHandle());
    }

    public void setCode(int code) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetCode(this.getHandle(), code);
    }

    public GraphicObjectType getSymbolType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbol3DType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetSymbolType(this.getHandle());
        GraphicObjectType graphicObjectType = new GraphicObjectType(n, n);
        return graphicObjectType;
    }

    public String getSymbolName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetSymbolName(this.getHandle());
    }

    public DotShowMode getShowMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShowMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetShowMode(this.getHandle());
        DotShowMode dotShowMode = new DotShowMode(n, n);
        return dotShowMode;
    }

    public void setShowMode(DotShowMode showMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShowMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetShowMode(this.getHandle(), showMode.value());
    }

    public boolean getNegativeImage() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNegativeImage()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetNegativeImage(this.getHandle());
    }

    public void setNegativeImage(boolean negativeImage) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNegativeImage()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetNegativeImage(this.getHandle(), negativeImage);
    }

    public int getSymbolRank() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolRank()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetSymbolRank(this.getHandle());
    }

    public void setSymbolRank(int symbolRank) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolRank()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSymbolRank(this.getHandle(), symbolRank);
    }

    public boolean getScaleByMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleByMap()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetScaleByMap(this.getHandle());
    }

    public void setScaleByMap(boolean scaleByMap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleByMap()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetScaleByMap(this.getHandle(), scaleByMap);
    }

    public boolean getLimitWidthHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLimitWidthHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetLimitWidthHeight(this.getHandle());
    }

    public void setLimitWidthHeight(boolean limitWidthHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLimitWidthHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetLimitWidthHeight(this.getHandle(), limitWidthHeight);
    }

    public double getGrid3DMainLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGrid3DMainLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetGrid3DMainLineWidth(this.getHandle());
    }

    public void setGrid3DMainLineWidth(double grid3DMainLineWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGrid3DMainLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetGrid3DMainLineWidth(this.getHandle(), grid3DMainLineWidth);
    }

    public double getGrid3DSurroundLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGrid3DSurroundLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetGrid3DSurroundLineWidth(this.getHandle());
    }

    public void setGrid3DSurroundLineWidth(double grid3DSurroundLineWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGrid3DSurroundLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetGrid3DSurroundLineWidth(this.getHandle(), grid3DSurroundLineWidth);
    }

    public int getModelID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModelID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetModelID(this.getHandle());
    }

    public void setModelID(int modelID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModelID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetModelID(this.getHandle(), modelID);
    }

    public String getModelPath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModelPath()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetModelPath(this.getHandle());
    }

    public void setModelPath(String modelPath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModelPath(String modelPath)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetModelPath(this.getHandle(), modelPath);
    }

    public String getPicturePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPicturePath()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetPicturePath(this.getHandle());
    }

    public void setPicturePath(String picturePath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPicturePath()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetPicturePath(this.getHandle(), picturePath);
    }

    public double getExtendHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetExtendHeight(this.getHandle());
    }

    public void setExtendHeight(double extendHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtendHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetExtendHeight(this.getHandle(), extendHeight);
    }

    public double getWholeHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWholeHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetWholeHeight(this.getHandle());
    }

    public void setWholeHeight(double wholeHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWholeHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetWholeHeight(this.getHandle(), wholeHeight);
    }

    public boolean getRoundCorner() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoundCorner()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetRoundCorner(this.getHandle());
    }

    public void setRoundCorner(boolean roundCorner) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRoundCorner()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetRoundCorner(this.getHandle(), roundCorner);
    }

    public boolean getRoundBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoundBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetRoundBox(this.getHandle());
    }

    public void setRoundBox(boolean roundBox) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRoundBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetRoundBox(this.getHandle(), roundBox);
    }

    public double getCameraAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraAltitude()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetCameraAltitude(this.getHandle());
    }

    public void setCameraAltitude(double cameraAltitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraAltitude()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetCameraAltitude(this.getHandle(), cameraAltitude);
    }

    public SurroundLineType getSurroundLineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSurroundLineType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetSurroundLineType(this.getHandle());
        SurroundLineType surroundLineType = new SurroundLineType(n, n);
        return surroundLineType;
    }

    public void setSurroundLineType(SurroundLineType surroundLineType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSurroundLineType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSurroundLineType(this.getHandle(), surroundLineType.value());
    }

    public double getSurroundLineWidth2D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSurroundLineWidth2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetSurroundLineWidth2D(this.getHandle());
    }

    public void setSurroundLineWidth2D(double surroundLineWidth2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSurroundLineWidth2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSurroundLineWidth2D(this.getHandle(), surroundLineWidth2D);
    }

    public double getSurroundLineWidth3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetSurroundLineWidth3D(this.getHandle());
    }

    public void setSurroundLineWidth3D(double surroundLineWidth3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSurroundLineWidth3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSurroundLineWidth3D(this.getHandle(), surroundLineWidth3D);
    }

    public Color getSurroundLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSurroundLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new Color(GeoGraphicObjectNative.jni_GetSurroundLineColor(this.getHandle()));
    }

    public void setSurroundLineColor(Color surroundLineColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSurroundLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSurroundLineColor(this.getHandle(), surroundLineColor.getRGB());
    }

    public String getTextContent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextContent()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetTextContent(this.getHandle());
    }

    public void setTextContent(String textContent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextContent()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetTextContent(this.getHandle(), textContent);
    }

    public MarkPos getAnnotationPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnnotationPosition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetAnnotationPosition(this.getHandle());
        MarkPos markPos = new MarkPos(n, n);
        return markPos;
    }

    public void setAnnotationPosition(MarkPos annotationPosition) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnnotationPosition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetAnnotationPosition(this.getHandle(), annotationPosition.value());
    }

    public double getShowTipLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShowTipLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetShowTipLength(this.getHandle());
    }

    public void setShowTipLength(double showTipLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShowTipLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetShowTipLength(this.getHandle(), showTipLength);
    }

    public boolean getMarkHalo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkHalo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetMarkHalo(this.getHandle());
    }

    public void setMarkHalo(boolean markHalo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkHalo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetMarkHalo(this.getHandle(), markHalo);
    }

    public double getMainLineWidth3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMainLineWidth3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetMainLineWidth3D(this.getHandle());
    }

    public void setMainLineWidth3D(double mainLineWidth3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMainLineWidth3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetMainLineWidth3D(this.getHandle(), mainLineWidth3D);
    }

    public boolean getLineTypeLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineTypeLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetLineTypeLimit(this.getHandle());
    }

    public void setLineTypeLimit(boolean lineTypeLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineTypeLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetLineTypeLimit(this.getHandle(), lineTypeLimit);
    }

    public boolean getLineWidthLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineWidthLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetLineWidthLimit(this.getHandle());
    }

    public void setLineWidthLimit(boolean lineWidthLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineWidthLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetLineWidthLimit(this.getHandle(), lineWidthLimit);
    }

    public boolean getLineColorLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColorLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetLineColorLimit(this.getHandle());
    }

    public void setLineColorLimit(boolean lineColorLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColorLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetLineColorLimit(this.getHandle(), lineColorLimit);
    }

    public boolean getFillLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetFillLimit(this.getHandle());
    }

    public void setFillLimit(boolean fillLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetFillLimit(this.getHandle(), fillLimit);
    }

    public boolean getFillColorLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillColorLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetFillColorLimit(this.getHandle());
    }

    public void setFillColorLimit(boolean fillColorLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillColorLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetFillColorLimit(this.getHandle(), fillColorLimit);
    }

    public boolean getSurroundLineLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSurroundLineLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetSurroundLineLimit(this.getHandle());
    }

    public void setSurroundLineLimit(boolean surroundLineLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSurroundLineLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSurroundLineLimit(this.getHandle(), surroundLineLimit);
    }

    public boolean getFontColorLimit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontColorLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetFontColorLimit(this.getHandle());
    }

    public void setFontColorLimit(boolean fontColorLimit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontColorLimit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetFontColorLimit(this.getHandle(), fontColorLimit);
    }

    public boolean getSurroundLineFlag() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSurroundLineFlag()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetSurroundLineFlag(this.getHandle());
    }

    public void setSurroundLineFlag(boolean surroundLineFlag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSurroundLineFlag()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSurroundLineFlag(this.getHandle(), surroundLineFlag);
    }

    public Point3Ds getPositionPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPositionPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point3Ds point3Ds = new Point3Ds();
        int n = GeoGraphicObjectNative.jni_GetPositionPointCount(this.getHandle());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        GeoGraphicObjectNative.jni_GetPositionPoints(this.getHandle(), dArray, dArray2, dArray3);
        for (int i = 0; i < n; ++i) {
            point3Ds.add(new Point3D(dArray[i], dArray2[i], dArray3[i]));
        }
        return point3Ds;
    }

    public void setPositionPoints(Point3Ds positionPoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPositionPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = positionPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = positionPoints.getItem(i).getX();
            dArray2[i] = positionPoints.getItem(i).getY();
            dArray3[i] = positionPoints.getItem(i).getZ();
        }
        GeoGraphicObjectNative.jni_SetPositionPoints(this.getHandle(), dArray, dArray2, dArray3);
    }

    public SubSymbol[] getSubSymbols() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSubSymbols()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetSubSymbolCount(this.getHandle());
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        GeoGraphicObjectNative.jni_GetSubSymbols(this.getHandle(), nArray, nArray2);
        SubSymbol[] subSymbolArray = new SubSymbol[n];
        for (int i = 0; i < n; ++i) {
            SubSymbol subSymbol;
            subSymbolArray[i] = subSymbol = new SubSymbol(nArray[i], nArray2[i]);
        }
        return subSymbolArray;
    }

    public void setSubSymbols(int index, SubSymbol symbol) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSubSymbols()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetSubSymbols(this.getHandle(), symbol.libID, symbol.code, index);
    }

    public double[] getScaleValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleValues()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetScaleValueCount(this.getHandle());
        double[] dArray = new double[n];
        GeoGraphicObjectNative.jni_GetScaleValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setScaleValues(double[] scaleValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleValues()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetScaleValues(this.getHandle(), scaleValues);
    }

    public Size2D getSymbolSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoGraphicObjectNative.jni_GetSymbolSize(this.getHandle(), dArray);
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setSymbolSize(Size2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Size2D size2D = value;
        if (this.getLimitWidthHeight()) {
            Size2D size2D2 = this.getSymbolSize();
            if (size2D2.width != value.width && size2D2.height == value.height) {
                size2D.height = size2D2.height * value.width / size2D2.width;
            } else if (size2D2.width == value.width && size2D2.height != value.height) {
                size2D.width = size2D2.width * value.height / size2D2.height;
            } else if (size2D2.width != value.width && size2D2.height != value.height) {
                double d = value.height / size2D2.height;
                double d2 = value.width / size2D2.width;
                double d3 = d > d2 ? d : d2;
                size2D.width = d3 * size2D2.width;
                size2D.height = d3 * size2D2.height;
            }
        }
        GeoGraphicObjectNative.jni_SetSymbolSize(this.getHandle(), size2D.getWidth(), size2D.getHeight());
    }

    public Size2D getGridSymbolSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridSymbolSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoGraphicObjectNative.jni_GetGridSymbolSize(this.getHandle(), dArray);
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setGridSymbolSize(Size2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridSymbolSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Size2D size2D = value;
        Size2D size2D2 = this.getGridSymbolSize();
        if (size2D2.width != value.width && size2D2.height == value.height) {
            size2D.height = size2D2.height * value.width / size2D2.width;
        } else if (size2D2.width == value.width && size2D2.height != value.height) {
            size2D.width = size2D2.width * value.height / size2D2.height;
        } else if (size2D2.width != value.width && size2D2.height != value.height) {
            double d = value.height / size2D2.height;
            double d2 = value.width / size2D2.width;
            double d3 = d > d2 ? d : d2;
            size2D.width = d3 * size2D2.width;
            size2D.height = d3 * size2D2.height;
        }
        GeoGraphicObjectNative.jni_SetGridSymbolSize(this.getHandle(), size2D.getWidth(), size2D.getHeight());
    }

    public Size2D getPictureSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPictureSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoGraphicObjectNative.jni_GetPictureSize(this.getHandle(), dArray);
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setPictureSize(Size2D pictureSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPictureSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetPictureSize(this.getHandle(), pictureSize.getWidth(), pictureSize.getHeight());
    }

    public GeoGraphicObject[] getInnerCells() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerCells()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetInnerCellCount(this.getHandle());
        long[] lArray = new long[n];
        GeoGraphicObjectNative.jni_GetInnerCells(this.getHandle(), lArray);
        GeoGraphicObject[] geoGraphicObjectArray = new GeoGraphicObject[n];
        for (int i = 0; i < n; ++i) {
            geoGraphicObjectArray[i] = new GeoGraphicObject(lArray[i]);
        }
        return geoGraphicObjectArray;
    }

    public Point2Ds getInnerPositionPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPositionPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        int n = GeoGraphicObjectNative.jni_GetInnerPositionPointCount(this.getHandle());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        GeoGraphicObjectNative.jni_GetInnerPositionPoints(this.getHandle(), dArray, dArray2);
        for (int i = 0; i < n; ++i) {
            point2Ds.add(new Point2D(dArray[i], dArray2[i]));
        }
        return point2Ds;
    }

    public void computeScalePoint(Point2D posPt, int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeScalePoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_ComputeScalePoint(this.getHandle(), posPt.getX(), posPt.getY(), index);
    }

    public Point2D getAnchorPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoGraphicObjectNative.jni_GetAnchorPoint(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point3Ds getScalePoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPositionPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point3Ds point3Ds = new Point3Ds();
        int n = GeoGraphicObjectNative.jni_GetScalePointCount(this.getHandle());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        GeoGraphicObjectNative.jni_GetScalePoints(this.getHandle(), dArray, dArray2, dArray3);
        for (int i = 0; i < n; ++i) {
            point3Ds.add(new Point3D(dArray[i], dArray2[i], dArray3[i]));
        }
        return point3Ds;
    }

    public void setScalePoints(Point3Ds scalePoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScalePoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = scalePoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = scalePoints.getItem(i).getX();
            dArray2[i] = scalePoints.getItem(i).getY();
            dArray3[i] = scalePoints.getItem(i).getZ();
        }
        GeoGraphicObjectNative.jni_SetScalePoints(this.getHandle(), dArray, dArray2, dArray3);
    }

    public int[] getSymbolRanks() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolRanks()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicObjectNative.jni_GetSymbolRankCount(this.getHandle());
        int[] nArray = new int[n];
        GeoGraphicObjectNative.jni_GetSymbolRanks(this.getHandle(), nArray);
        return nArray;
    }

    public boolean getMiddleMarkExist() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMiddleMarkExist()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetMiddleMarkExist(this.getHandle());
    }

    public int getAlgoMaxEditPts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlgoMaxEditPts()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetAlgoMaxEditPts(this.getHandle());
    }

    public int getAlgoMinEditPts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlgoMinEditPts()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetAlgoMinEditPts(this.getHandle());
    }

    public Rectangle2D getMiddleMarkBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMiddleMarkBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        GeoGraphicObjectNative.jni_GetMiddleMarkBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public boolean isCanFill() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCanFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_IsCanFill(this.getHandle());
    }

    public boolean isPolybezierClose() {
        return GeoGraphicObjectNative.jni_IsPolybezierClose(this.getHandle());
    }

    public void setPolybezierClose(boolean isClose) {
        GeoGraphicObjectNative.jni_SetPolybezierClose(this.getHandle(), isClose);
    }

    public String getUuID() {
        String string = GeoGraphicObjectNative.jni_GetUuID(this.getHandle());
        return string;
    }

    public void generateUuid() {
        GeoGraphicObjectNative.jni_GenerateUuID(this.getHandle());
    }

    public boolean IsShowBloodVolume() {
        return GeoGraphicObjectNative.jni_IsShowBloodVolume(this.getHandle());
    }

    public void SetShowBloodVolume(boolean isShow) {
        GeoGraphicObjectNative.jni_SetIsShowBloodVolume(this.getHandle(), isShow);
    }

    public double GetBloodVolume() {
        return GeoGraphicObjectNative.jni_GetBloodVolume(this.getHandle());
    }

    public void SetBloodVolume(double bloodVolume) {
        GeoGraphicObjectNative.jni_SetBloodVolume(this.getHandle(), bloodVolume);
    }

    public void AddAvoidRegion(GeoRegion avoidRegion) {
        if (avoidRegion == null) {
            return;
        }
        GeoGraphicObjectNative.jni_AddAvoidRegion(this.getHandle(), avoidRegion.getHandle());
    }

    public void SetAvoidRegion(GeoRegion avoidRegion, int index) {
        if (avoidRegion == null) {
            return;
        }
        GeoGraphicObjectNative.jni_SetAvoidRegion(this.getHandle(), avoidRegion.getHandle(), index);
    }

    public GeoRegion GetAvoidRegion(int index) {
        long l = GeoGraphicObjectNative.jni_GetAvoidRegion(this.getHandle(), index);
        if (l == 0L) {
            return null;
        }
        GeoRegion geoRegion = new GeoRegion(l);
        return geoRegion;
    }

    public int GetAvoidRegionCount() {
        int n = GeoGraphicObjectNative.jni_GetAvoidRegionCount(this.getHandle());
        return n;
    }

    public boolean RemoveAvoidRegion(int index) {
        return GeoGraphicObjectNative.jni_RemoveAvoidRegion(this.getHandle(), index);
    }

    public boolean RemoveAllAvoidRegion() {
        return GeoGraphicObjectNative.jni_RemoveAllAvoidRegion(this.getHandle());
    }

    public int GetWallOpaqueRate() {
        return GeoGraphicObjectNative.jni_GetWallOpaqueRate(this.getHandle());
    }

    public void SetWallOpaqueRate(int value) {
        GeoGraphicObjectNative.jni_SetWallOpaqueRate(this.getHandle(), value);
    }

    public boolean getDrawWall() {
        return GeoGraphicObjectNative.jni_GetDrawWall(this.getHandle());
    }

    public void setDrawWall(boolean value) {
        GeoGraphicObjectNative.jni_SetDrawWall(this.getHandle(), value);
    }

    public boolean getHorizontalMirror() {
        return GeoGraphicObjectNative.jni_GetHorizontalMirror(this.getHandle());
    }

    public void setHorizontalMirror(boolean value) {
        GeoGraphicObjectNative.jni_SetHorizontalMirror(this.getHandle(), value);
    }

    public boolean getVerticalMirror() {
        return GeoGraphicObjectNative.jni_GetVerticalMirror(this.getHandle());
    }

    public void setVerticalMirror(boolean value) {
        GeoGraphicObjectNative.jni_SetVerticalMirror(this.getHandle(), value);
    }

    public double getSpace() {
        return GeoGraphicObjectNative.jni_GetSpace(this.getHandle());
    }

    public void setSpace(double value) {
        GeoGraphicObjectNative.jni_SetSpace(this.getHandle(), value);
    }

    public double getScaleValue(int index) {
        return GeoGraphicObjectNative.jni_GetScaleValue(this.getHandle(), index);
    }

    public void setScaleValue(int index, double scaleValue) {
        GeoGraphicObjectNative.jni_SetScaleValue(this.getHandle(), index, scaleValue);
    }

    public boolean getDragLine() {
        return GeoGraphicObjectNative.jni_GetDragLine(this.getHandle());
    }

    public void setDragLine(boolean value) {
        GeoGraphicObjectNative.jni_SetDragLine(this.getHandle(), value);
    }

    public boolean isVisible() {
        return GeoGraphicObjectNative.jni_GetVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        GeoGraphicObjectNative.jni_SetVisible(this.getHandle(), value);
    }

    public void setTextBoxType(int value) {
        GeoGraphicObjectNative.jni_SetTextBoxType(this.getHandle(), value);
    }

    public int getTextBoxType() {
        return GeoGraphicObjectNative.jni_GetTextBoxType(this.getHandle());
    }

    public void setStartAssociation(String uuid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAssociation(String uuid)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetStartAssociation(this.getHandle(), uuid);
    }

    public String getStartAssociation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAssociation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetStartAssociation(this.getHandle());
    }

    public void setEndAssociation(String uuid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndAssociation(String uuid)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetEndAssociation(this.getHandle(), uuid);
    }

    public String getEndAssociation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndAssociation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetEndAssociation(this.getHandle());
    }

    public String[] getLineRelations() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineRelations()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoGraphicObjectNative.jni_GetLineRelations(this.getHandle());
        if (string.isEmpty()) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = string.split(";");
        return stringArray;
    }

    public void addLineRelation(String uuid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addLineRelation(String uuid)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_AddLineRelation(this.getHandle(), uuid);
    }

    public void removeLineRelation(String uuid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeLineRelation(String uuid)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_RemoveLineRelation(this.getHandle(), uuid);
    }

    public int getDashPattern() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDashPattern()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetDashPattern(this.getHandle());
    }

    public void setDashPattern(int dashPattern) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDashPattern(int dashPattern)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetDashPattern(this.getHandle(), dashPattern);
    }

    public double getDashLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDashLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicObjectNative.jni_GetDashLength(this.getHandle());
    }

    public void setDashLength(double dashLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDashLength(double dashLength)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetDashLength(this.getHandle(), dashLength);
    }

    public Color getGapColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGapColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = GeoGraphicObjectNative.jni_GetGapColor(this.getHandle());
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setGapColor(Color gapColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGapColor(Color gapColor)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicObjectNative.jni_SetGapColor(this.getHandle(), gapColor.getRed(), gapColor.getGreen(), gapColor.getBlue(), gapColor.getAlpha());
    }
}

