/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoGraphicCompoundNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import java.util.ArrayList;

public class GeoGraphicCompound
extends Geometry {
    private ArrayList<Geometry> m_geoParts;

    public GeoGraphicCompound() {
        long l = GeoGraphicCompoundNative.jni_New();
        this.setHandle(l, true);
        this.m_geoParts = new ArrayList();
    }

    GeoGraphicCompound(long handle) {
        this.setHandle(handle, false);
        this.m_geoParts = new ArrayList();
        GeoGraphicCompound.refreshFromUGC1(this);
    }

    public GeoGraphicCompound(GeoGraphicCompound geoCompound) {
        if (geoCompound == null) {
            String string = InternalResource.loadString("geoCompound", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoCompound);
        if (l == 0L) {
            String string = InternalResource.loadString("geoCompound", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoGraphicCompoundNative.jni_Clone(l);
        this.m_geoParts = new ArrayList();
        this.setHandle(l2, true);
        GeoGraphicCompound.refreshFromUGC1(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompound);
    }

    public int addPart(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoGraphicCompoundNative.jni_addPart(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.m_geoParts.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.m_geoParts.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicCompoundNative.jni_getPartCount(this.getHandle());
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemovePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_geoParts.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        bl = GeoGraphicCompoundNative.jni_removePart(this.getHandle(), index);
        if (bl) {
            this.m_geoParts.get(index).clearHandle();
            InternalHandleDisposable.setIsDisposable(this.m_geoParts.get(index), true);
            this.m_geoParts.remove(index);
        }
        return bl;
    }

    public Geometry getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.m_geoParts.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_geoParts.get(index);
    }

    public boolean insertPart(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InsertPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.m_geoParts.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoGraphicCompoundNative.jni_insertPart(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            this.m_geoParts.add(index, geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean setPart(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.m_geoParts.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoGraphicCompoundNative.jni_setPart(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this.m_geoParts.get(index);
            geometry3.clearHandle();
            this.m_geoParts.remove(index);
            this.m_geoParts.add(index, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public void adjust(boolean isMinGeometryMovedUp) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Adjust(boolean isMinGeometryMovedUp)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompoundNative.jni_adjust(this.getHandle(), isMinGeometryMovedUp);
        int n2 = this.getPartCount();
        long[] lArray = new long[n2];
        GeoGraphicCompoundNative.jni_AllSubGeometrys(this.getHandle(), lArray);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (n = 0; n < this.m_geoParts.size(); ++n) {
            arrayList.add(this.m_geoParts.get(n));
        }
        this.m_geoParts.clear();
        block1: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (((Geometry)arrayList.get(i)).getHandle() != lArray[n]) continue;
                this.m_geoParts.add((Geometry)arrayList.get(i));
                arrayList.remove(i);
                continue block1;
            }
        }
    }

    public Geometry[] divide(boolean isTopOnly) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Divide(boolean isTopOnly)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoGraphicCompoundNative.jni_divide(this.getHandle(), isTopOnly);
        int n = lArray.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            geometryArray[i] = Geometry.createInstance(lArray[i]);
        }
        return geometryArray;
    }

    @Override
    public GeoGraphicCompound clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoGraphicCompound(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoGraphicCompoundNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void rotate(Point2D basePoint, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(basePoint, angle);
        this.refrashPartsList();
    }

    @Override
    public Geometry mirror(Point2D startPoint, Point2D endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompound geoGraphicCompound = (GeoGraphicCompound)super.mirror(startPoint, endPoint);
        this.refrashPartsList();
        return geoGraphicCompound;
    }

    @Override
    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(dx, dy);
        this.refrashPartsList();
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompoundNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    public String getUuID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUuID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoGraphicCompoundNative.jni_GetUuID(this.getHandle());
        return string;
    }

    public void generateUuid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("generateUuid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompoundNative.jni_GenerateUuID(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this.m_geoParts.size(); ++i) {
            this.m_geoParts.get(i).setIsDisposable(true);
            this.m_geoParts.get(i).setHandle(0L);
            this.m_geoParts.get(i).clearHandle();
        }
        this.m_geoParts.clear();
    }

    static void refreshFromUGC1(GeoGraphicCompound geoCompound) {
        int n = geoCompound.getPartCount();
        long[] lArray = new long[n];
        GeoGraphicCompoundNative.jni_AllSubGeometrys(geoCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoCompound.m_geoParts.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompound);
    }

    void refrashPartsList() {
        for (int i = 0; i < this.m_geoParts.size(); ++i) {
            Geometry geometry;
            if (this.m_geoParts.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this.m_geoParts.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this.m_geoParts.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this.m_geoParts.get(i);
            ((GeoLine)geometry).refrashPartsList();
        }
    }

    protected static GeoGraphicCompound creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoGraphicCompound(handle);
    }
}

