/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfoNative;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.Locale;

public class DatasourceConnectionInfo
extends InternalHandleDisposable {
    private boolean m_readOnly = false;

    public DatasourceConnectionInfo() {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public DatasourceConnectionInfo(String tns, String database, String alias, String user, String password) {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        if (alias == null || alias.trim().length() == 0) {
            String string = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.reset(tns, "", database, alias, user, password, EngineType.ORACLEPLUS);
    }

    public DatasourceConnectionInfo(String server, String driver, String database, String alias, String user, String password) {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        if (driver == null) {
            driver = "SQL Server";
        }
        if (alias == null || alias.trim().length() == 0) {
            String string = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.reset(server, driver, database, alias, user, password, EngineType.SQLPLUS);
    }

    public DatasourceConnectionInfo(String file, String alias, String password) {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        if (alias == null || alias.trim().length() == 0) {
            String string = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.reset(file, "", "", alias, "", password, EngineType.UDB);
    }

    public String getAlias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetAlias(this.getHandle());
    }

    public void setAlias(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setAlias()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasourceConnectionInfoNative.jni_SetAlias(this.getHandle(), value);
    }

    public EngineType getEngineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceConnectionInfoNative.jni_GetEngineType(this.getHandle());
        EngineType engineType = null;
        try {
            engineType = (EngineType)Enum.parseUGCValue(EngineType.class, n);
        }
        catch (Exception exception) {
            engineType = new EngineType(n, n);
        }
        return engineType;
    }

    public void setEngineType(EngineType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setEngineType()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value.equals(EngineType.IMAGEPLUGINS)) {
            this.setReadOnly(true);
        }
        int n = value.getUGCValue();
        DatasourceConnectionInfoNative.jni_SetEngineType(this.getHandle(), n);
    }

    public String getServer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetServer(this.getHandle());
    }

    public void setServer(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setServer()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        if (Locale.getDefault().equals(Locale.JAPANESE)) {
            value = value.replaceAll("\\\\", "/");
        }
        DatasourceConnectionInfoNative.jni_SetServer(this.getHandle(), value);
    }

    public String getDatabase() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetDataBase(this.getHandle());
    }

    public void setDatabase(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setDatabase()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        DatasourceConnectionInfoNative.jni_SetDataBase(this.getHandle(), value);
    }

    public String getUser() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetUser(this.getHandle());
    }

    public void setUser(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setUser()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        DatasourceConnectionInfoNative.jni_SetUser(this.getHandle(), value);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setPassword()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "";
        }
        DatasourceConnectionInfoNative.jni_SetPassword(this.getHandle(), value);
    }

    public String getDriver() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetDriver(this.getHandle());
    }

    public void setDriver(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setDriver()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null) {
            value = "SQL Server";
        }
        DatasourceConnectionInfoNative.jni_SetDriver(this.getHandle(), value);
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetReadOnly(this.getHandle());
    }

    public void setReadOnly(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setIsReadOnly()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetReadOnly(this.getHandle(), value);
    }

    public boolean isAutoConnect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetAutoConnect(this.getHandle());
    }

    public void setAutoConnect(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setIsAutoConnect(boolean value)", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetAutoConnect(this.getHandle(), value);
    }

    public boolean isOpenLinkTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetIsOpenLinkTable(this.getHandle());
    }

    public void setOpenLinkTable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setIsOpenLinkTable(boolean value)", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetIsOpenLinkTable(this.getHandle(), value);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setConnectionIncrementStep()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = DatasourceConnectionInfoNative.jni_FromXML(this.getHandle(), xml);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_ToXML(this.getHandle());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasourceConnectionInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean saveAsDCF(String strPath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_SaveAsDCF(this.getHandle(), strPath);
    }

    public boolean loadFromDCF(String strPath) {
        if (this.getHandle() == 0L) {
            long l = DatasourceConnectionInfoNative.jni_New();
            this.setHandle(l, true);
        }
        return DatasourceConnectionInfoNative.jni_LoadFromDCF(this.getHandle(), strPath);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Alias = ");
        stringBuffer.append(this.getAlias());
        stringBuffer.append(",EngineType = ");
        stringBuffer.append(this.getEngineType().name());
        stringBuffer.append(",Server = ");
        stringBuffer.append(this.getServer());
        stringBuffer.append(",Database = ");
        stringBuffer.append(this.getDatabase());
        stringBuffer.append(",Driver = ");
        stringBuffer.append(this.getDriver());
        stringBuffer.append(",User = ");
        stringBuffer.append(this.getUser());
        stringBuffer.append(",Password = ");
        stringBuffer.append(this.getPassword());
        stringBuffer.append(",IsReadOnly = ");
        stringBuffer.append(this.isReadOnly());
        stringBuffer.append(",IsAutoConnect = ");
        stringBuffer.append(this.isAutoConnect());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void clearHandle(DatasourceConnectionInfo connectionInfo) {
        connectionInfo.clearHandle();
    }

    DatasourceConnectionInfo(long handle) {
        this.setHandle(handle, false);
    }

    DatasourceConnectionInfo(Datasource datasource, long handle) {
        if (datasource == null || datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_readOnly = true;
        this.setHandle(handle, false);
    }

    void reset() {
        this.reset("", "", "", "UntitledDatasource", "", "", EngineType.UDB);
    }

    void reset(String server, String driver, String database, String alias, String user, String password, EngineType engineType) {
        if (alias == null || alias.trim().length() == 0) {
            String string = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (Locale.getDefault().equals(Locale.JAPANESE)) {
            server = server.replaceAll("\\\\", "/");
        }
        if (this.getHandle() != 0L) {
            int n = engineType.getUGCValue();
            DatasourceConnectionInfoNative.jni_Reset(this.getHandle(), server, driver, database, alias, user, password, n);
        }
    }

    protected static DatasourceConnectionInfo createInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new DatasourceConnectionInfo(handle);
    }

    public int getMaxConnPoolNum() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceConnectionInfoNative.jni_GetMaxConnPoolNum(this.getHandle());
        return n;
    }

    public void setMaxConnPoolNum(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_readOnly) {
            String string = InternalResource.loadString("setEngineType()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetMaxConnPoolNum(this.getHandle(), value);
    }
}

