/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import com.supermap.InterfaceAdmin;
import com.supermap.KeyInfo;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseRemoteManagersInfo;
import com.supermap.Runner;
import com.supermap.SessionInfo;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class LicenseAdmin {
    private InterfaceAdmin m_admin;
    private Runner g_HaspRunner;
    private String m_ip;

    public LicenseAdmin(String ip, int port, String password) {
        this.m_ip = ip;
        ServiceLoader<InterfaceAdmin> serviceLoader = ServiceLoader.load(InterfaceAdmin.class);
        Iterator<InterfaceAdmin> it = serviceLoader.iterator();
        while (it != null && it.hasNext()) {
            InterfaceAdmin handler;
            this.m_admin = handler = it.next();
        }
        if (this.m_admin != null) {
            this.m_admin.init(ip, port, password);
        }
    }

    public String getLastApiError() {
        String result = "";
        if (this.m_admin != null) {
            result = this.m_admin.getLastApiError();
        }
        return result;
    }

    public void deleteSession(String sessionID) {
        if (this.m_admin != null) {
            this.m_admin.deleteSession(sessionID);
        }
    }

    public List<SessionInfo> getSessionInfo(String keyId, String featureId) {
        List<SessionInfo> sessionInfoList = null;
        if (this.m_admin != null) {
            sessionInfoList = this.m_admin.getSessionInfo(keyId, featureId);
        }
        return sessionInfoList;
    }

    public List<LicenseFeatureInfo> getFeatureInfo(String keyId) {
        List<LicenseFeatureInfo> featureInfoList = null;
        if (this.m_admin != null) {
            featureInfoList = this.m_admin.getFeatureInfo(keyId);
        }
        return featureInfoList;
    }

    public List<KeyInfo> getKeyInfo() {
        List<KeyInfo> keyInfoList = null;
        if (this.m_admin != null) {
            keyInfoList = this.m_admin.getKeyInfo();
        }
        return keyInfoList;
    }

    public void updateConfig(String str) {
        if (this.m_admin != null) {
            this.m_admin.update(str);
        }
    }

    public void updateConfig(LicenseRemoteManagersInfo licenseSeverInfo) {
        if (this.m_admin != null) {
            this.m_admin.update(licenseSeverInfo);
        }
    }

    public LicenseRemoteManagersInfo getRemoteManagersInfo() {
        LicenseRemoteManagersInfo serverInfo = null;
        if (this.m_admin != null) {
            serverInfo = this.m_admin.getRemoteManagersInfo();
        }
        return serverInfo;
    }

    public void dispose() {
        if (this.m_admin != null) {
            this.m_admin.dispose();
        }
    }

    public String[] getC2V() {
        this.initHaspRunner();
        return this.g_HaspRunner.getC2V();
    }

    public String[] update(String info) {
        this.initHaspRunner();
        return this.g_HaspRunner.update(info);
    }

    public void update(LicenseRemoteManagersInfo licenseSeverInfo) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<config>");
        int value = licenseSeverInfo.getAccesstoRemote() ? 1 : 0;
        strBuilder.append(String.format("<accesstoremote>%s</accesstoremote>", value));
        value = licenseSeverInfo.getBroadcastSearch() ? 1 : 0;
        strBuilder.append(String.format("<broadcastsearch>%s</broadcastsearch>", value));
        strBuilder.append("<access_restrictions_clear/>");
        value = licenseSeverInfo.getAccessfromRemote() ? 1 : 0;
        strBuilder.append(String.format("<accessfromremote>%s</accessfromremote>", value));
        strBuilder.append("<serveraddrs_clear/>");
        List<String> serveraddrs = licenseSeverInfo.getServeraddrs();
        if (serveraddrs != null && serveraddrs.size() > 0) {
            for (int i = 0; i < serveraddrs.size(); ++i) {
                strBuilder.append(String.format("<serveraddr>%s</serveraddr>", serveraddrs.get(i)));
            }
        }
        strBuilder.append("<writeconfig />");
        strBuilder.append("</config>");
        this.update(strBuilder.toString());
    }

    public String[] getID() {
        this.initHaspRunner();
        return this.g_HaspRunner.getID();
    }

    public String[] detach(int second, String productID, String recipient) {
        this.initHaspRunner();
        return this.g_HaspRunner.detach(second, productID, recipient);
    }

    public String[] getR2h(String keyID) {
        this.initHaspRunner();
        return this.g_HaspRunner.getR2H(keyID);
    }

    private void initHaspRunner() {
        if (this.g_HaspRunner == null) {
            ServiceLoader<Runner> serviceLoader = ServiceLoader.load(Runner.class);
            Iterator<Runner> it = serviceLoader.iterator();
            while (it != null && it.hasNext()) {
                String arch;
                Runner licenseInstance = it.next();
                String implName = licenseInstance.getImplName();
                if (!implName.equals("HASP") || !(arch = System.getProperty("os.arch")).equals("x86") && !arch.equals("x86_64") && !arch.equals("amd64")) continue;
                this.g_HaspRunner = licenseInstance;
                this.g_HaspRunner.SetServerIP(this.m_ip);
            }
        }
    }
}

