/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionScaleBParameter
extends SamplingFunctionParameter {
    private double m_dPopulationVariance = 0.0;
    private double m_dExpectedVariance = 0.0;

    private SamplingFunctionScaleBParameter() {
    }

    public SamplingFunctionScaleBParameter(double dPopulationVariance, double dExpectedVariance) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONSCALEB;
        this.setPopulationVariance(dPopulationVariance);
        this.setExpectedVariance(dExpectedVariance);
    }

    public double getPopulationVariance() {
        return this.m_dPopulationVariance;
    }

    public void setPopulationVariance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("PopulationVariance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dPopulationVariance = value;
    }

    public double getExpectedVariance() {
        return this.m_dExpectedVariance;
    }

    public void setExpectedVariance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("ExpectedVariance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dExpectedVariance = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setPopulationVariance(handle, this.m_dPopulationVariance);
        SamplingParameterNative.jni_setExpectedVariance(handle, this.m_dExpectedVariance);
    }
}

