/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.GeographicalDetectorResultNative;
import com.supermap.analyst.spatialstatistics.InternalHandleDisposable;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.RiskDetectorMean;
import com.supermap.analyst.spatialstatistics.RiskDetectorValue;

public class RiskDetectorResult
extends InternalHandleDisposable {
    RiskDetectorResult(long handle) {
        this.setHandle(handle, false);
    }

    public RiskDetectorMean[] getRiskDetectorMeans() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRiskDetectorMeans()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeographicalDetectorResultNative.jni_RiskDetectorMeans(this.getHandle());
        RiskDetectorMean[] riskDetectorMeanArray = null;
        if (lArray != null && lArray.length != 0) {
            riskDetectorMeanArray = new RiskDetectorMean[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                riskDetectorMeanArray[i] = new RiskDetectorMean(lArray[i]);
            }
        }
        return riskDetectorMeanArray;
    }

    public RiskDetectorValue[][] getRiskDetectorValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRiskDetectorValues()", "Handle_ObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        long[][] lArray = GeographicalDetectorResultNative.jni_RiskDetectorValues(this.getHandle());
        RiskDetectorValue[][] riskDetectorValueArray = null;
        if (lArray != null && lArray.length != 0) {
            riskDetectorValueArray = new RiskDetectorValue[lArray.length][];
            for (int i = 0; i < lArray.length; ++i) {
                riskDetectorValueArray[i] = new RiskDetectorValue[lArray[i].length];
                for (int j = 0; j < lArray[i].length; ++j) {
                    riskDetectorValueArray[i][j] = new RiskDetectorValue(lArray[i][j]);
                }
            }
        }
        return riskDetectorValueArray;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            GeographicalDetectorResultNative.jni_RDRDelete(super.getHandle());
            this.setHandle(0L);
        }
    }
}

