/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class LayeredFunctionProportionAParameter
extends SamplingFunctionParameter {
    private double m_dTotalCost = 0.0;
    private double m_dInitalCost = 0.0;
    private String m_strLayeredCostFieldName;
    private String m_strLayeredProportionFieldName;

    private LayeredFunctionProportionAParameter() {
    }

    public LayeredFunctionProportionAParameter(double dTotalCost, double dInitalCost, String strLayeredProportionFieldName, String strLayeredCostFieldName) {
        this.m_FunctionType = SamplingFunctionType.LAYEREDFUNCTIONPROPORTIONA;
        this.setTotalCost(dTotalCost);
        this.setInitalCost(dInitalCost);
        this.setLayeredCostFieldName(strLayeredCostFieldName);
        this.setLayeredProportionFieldName(strLayeredProportionFieldName);
    }

    public double getTotalCost() {
        return this.m_dTotalCost;
    }

    public void setTotalCost(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("TotalCost", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dTotalCost = value;
    }

    public double getInitalCost() {
        return this.m_dInitalCost;
    }

    public void setInitalCost(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("InitalCost", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dInitalCost = value;
    }

    public String getLayeredCostFieldName() {
        return this.m_strLayeredCostFieldName;
    }

    public void setLayeredCostFieldName(String value) {
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("LayeredCostFieldName", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strLayeredCostFieldName = value;
    }

    public String getLayeredProportionFieldName() {
        return this.m_strLayeredProportionFieldName;
    }

    public void setLayeredProportionFieldName(String value) {
        if (value == null || value.length() == 0) {
            String string = InternalResource.loadString("LayeredProportionFieldName", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strLayeredProportionFieldName = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setTotalCost(handle, this.m_dTotalCost);
        SamplingParameterNative.jni_setInitalCost(handle, this.m_dInitalCost);
        SamplingParameterNative.jni_setLayeredCostFieldName(handle, this.m_strLayeredCostFieldName);
        SamplingParameterNative.jni_setLayeredProportionFieldName(handle, this.m_strLayeredProportionFieldName);
    }
}

