/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibraryNative;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolLineLibrary;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolMarker3D;
import com.supermap.data.SymbolMarkerLibrary;

public abstract class SymbolLibrary
extends InternalHandleDisposable {
    private SymbolGroup m_SymbolGroup;

    protected SymbolLibrary() {
    }

    public SymbolGroup findGroup(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findGroup(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroup symbolGroup = null;
        if (this.getRootGroup() != null) {
            symbolGroup = this.m_SymbolGroup.findGroup(id);
        }
        return symbolGroup;
    }

    public boolean contains(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_Contains(this.getHandle(), id);
    }

    public Symbol findSymbol(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSymbol(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.m_SymbolGroup.findSymbol(id);
        }
        return symbol;
    }

    public Symbol findSymbol(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSymbol(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.m_SymbolGroup.findSymbol(name);
        }
        return symbol;
    }

    public boolean toFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFile(String fileName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (fileName != null && fileName.trim().length() != 0) {
            if (this instanceof SymbolFillLibrary) {
                if (!fileName.endsWith(".bru")) {
                    fileName = fileName + ".bru";
                }
            } else if (this instanceof SymbolLineLibrary) {
                if (!fileName.endsWith(".lsl")) {
                    fileName = fileName + ".lsl";
                }
            } else if (this instanceof SymbolMarkerLibrary && !fileName.endsWith(".sym")) {
                fileName = fileName + ".sym";
            }
            bl = SymbolLibraryNative.jni_toFile(this.getHandle(), fileName);
        }
        return bl;
    }

    public boolean fromFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile(String filename, boolean overWrite)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (fileName != null && fileName.trim().length() != 0) {
            bl = SymbolLibraryNative.jni_fromFile(this.getHandle(), fileName, false);
        }
        if (bl && this.getRootGroup() != null) {
            this.m_SymbolGroup.reset();
        }
        return bl;
    }

    public boolean remove(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getRootGroup() != null) {
            bl = this.m_SymbolGroup.remove(id);
        }
        return bl;
    }

    public int add(Symbol symbol, SymbolGroup desGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Symbol symbol, SymbolGroup desGroup)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = InternalResource.loadString("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(symbol);
        if (l == 0L) {
            String string = InternalResource.loadString("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desGroup == null) {
            String string = InternalResource.loadString("desGroup", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(desGroup);
        if (l2 == 0L) {
            String string = InternalResource.loadString("desGroup", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_SymbolGroup.getChildGroups().contains(desGroup.getName())) {
            String string = InternalResource.loadString("desGroup", "SymbolGroups_NotContainTheSymbolGroup", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.add(symbol);
        if (n != -1) {
            this.moveTo(n, desGroup);
        }
        symbol.makeSureNativeObjectLive();
        desGroup.makeSureNativeObjectLive();
        return n;
    }

    public boolean moveTo(int id, SymbolGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (group == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(group);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        Symbol symbol = this.findSymbol(id);
        SymbolGroup symbolGroup = symbol.getGroup();
        int n = symbolGroup.indexOf(id);
        bl = symbolGroup.moveTo(n, group);
        group.makeSureNativeObjectLive();
        return bl;
    }

    public int add(Symbol symbol) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Add(Symbol symbol)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = InternalResource.loadString("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(symbol);
        if (l == 0L) {
            String string = InternalResource.loadString("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolFillLibrary && !(symbol instanceof SymbolFill)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolLineLibrary && !(symbol instanceof SymbolLine)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolMarkerLibrary && !(symbol instanceof SymbolMarker) && !(symbol instanceof SymbolMarker3D)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SymbolLibraryNative.jni_add(this.getHandle(), l);
        int n = -1;
        if (l2 != 0L) {
            Symbol symbol2 = Symbol.createInstance(l2);
            n = symbol2.getID();
            symbol2.setIsDisposable(false);
            if (this.m_SymbolGroup != null) {
                this.m_SymbolGroup.getSymbols().add(symbol2);
            }
            symbol2.setLibrary(this);
            symbol2.setGroup(this.m_SymbolGroup);
        }
        symbol.makeSureNativeObjectLive();
        return n;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLibraryNative.jni_clear(this.getHandle());
        if (this.m_SymbolGroup != null) {
            this.m_SymbolGroup.reset();
        }
    }

    public SymbolGroup getRootGroup() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRootGroup()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_SymbolGroup == null && (l = SymbolLibraryNative.jni_GetRootGroup(this.getHandle())) != 0L) {
            this.m_SymbolGroup = new SymbolGroup(this, l);
        }
        return this.m_SymbolGroup;
    }

    String getLibPath() {
        return SymbolLibraryNative.jni_GetLibPath(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.m_SymbolGroup != null) {
            this.m_SymbolGroup.clearHandle();
            this.m_SymbolGroup = null;
        }
        this.setHandle(0L);
    }
}

