/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.SceneAddedEvent;
import com.supermap.data.SceneAddedListener;
import com.supermap.data.SceneClearedEvent;
import com.supermap.data.SceneClearedListener;
import com.supermap.data.SceneClearingEvent;
import com.supermap.data.SceneClearingListener;
import com.supermap.data.SceneRemovedEvent;
import com.supermap.data.SceneRemovedListener;
import com.supermap.data.SceneRemovingEvent;
import com.supermap.data.SceneRemovingListener;
import com.supermap.data.SceneRenamedEvent;
import com.supermap.data.SceneRenamedListener;
import com.supermap.data.SceneRenamingEvent;
import com.supermap.data.SceneRenamingListener;
import com.supermap.data.ScenesNative;
import com.supermap.data.Workspace;
import java.util.concurrent.CopyOnWriteArrayList;

public class Scenes {
    private Workspace m_workspace;
    transient CopyOnWriteArrayList<SceneAddedListener> m_sceneAddedListeners;
    transient CopyOnWriteArrayList<SceneRemovingListener> m_sceneRemovingListeners;
    transient CopyOnWriteArrayList<SceneRemovedListener> m_sceneRemovedListeners;
    transient CopyOnWriteArrayList<SceneClearingListener> m_sceneClearingListeners;
    transient CopyOnWriteArrayList<SceneClearedListener> m_sceneClearedListeners;
    transient CopyOnWriteArrayList<SceneRenamingListener> m_sceneRenamingListeners;
    transient CopyOnWriteArrayList<SceneRenamedListener> m_sceneRenamedListeners;

    Scenes(Workspace workspace) {
        this.m_workspace = workspace;
    }

    public String get(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScenesNative.jni_GetItem(this.m_workspace.getHandle(), index);
    }

    public int getCount() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ScenesNative.jni_GetCount(this.m_workspace.getHandle());
    }

    public int add(String name, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = ScenesNative.jni_Add(this.m_workspace.getHandle(), name, xml);
        if (n > -1) {
            SceneAddedEvent sceneAddedEvent = new SceneAddedEvent(this, name);
            this.fireAdded(sceneAddedEvent);
        }
        return n;
    }

    public boolean insert(int index, String name, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ScenesNative.jni_Insert(this.m_workspace.getHandle(), index, name, xml);
    }

    public boolean setSceneXML(int index, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        return ScenesNative.jni_SetSceneXML(this.m_workspace.getHandle(), index, xml);
    }

    public boolean setSceneXML(String name, String xml) {
        int n;
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setSceneXML(n, xml);
    }

    public String getSceneXML(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScenesNative.jni_GetSceneXML(this.m_workspace.getHandle(), index);
    }

    public String getSceneXML(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ScenesNative.jni_GetSceneXML(this.m_workspace.getHandle(), n);
    }

    public boolean remove(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index);
        SceneRemovingEvent sceneRemovingEvent = new SceneRemovingEvent(this, string);
        this.fireRemoving(sceneRemovingEvent);
        if (sceneRemovingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = ScenesNative.jni_Remove(this.m_workspace.getHandle(), index);
        if (bl) {
            SceneRemovedEvent sceneRemovedEvent = new SceneRemovedEvent(this, string);
            this.fireRemoved(sceneRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.indexOf(name);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SceneClearingEvent sceneClearingEvent = new SceneClearingEvent(this);
        this.fireClearing(sceneClearingEvent);
        if (sceneClearingEvent.getCancel()) {
            return;
        }
        int n = this.getCount();
        ScenesNative.jni_Clear(this.m_workspace.getHandle());
        SceneClearedEvent sceneClearedEvent = new SceneClearedEvent(this, n);
        this.fireCleared(sceneClearedEvent);
    }

    public int indexOf(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = ScenesNative.jni_IndexOf(this.m_workspace.getHandle(), name);
        }
        return n;
    }

    public String getAvailableSceneName(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return ScenesNative.jni_GetAvailableSceneName(this.m_workspace.getHandle(), name);
    }

    public boolean rename(String oldName, String newName) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(oldName) == -1) {
            String string = InternalResource.loadString("oldName", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName.equalsIgnoreCase(oldName)) {
            return false;
        }
        if (this.indexOf(newName) >= 0) {
            String string = InternalResource.loadString("newName", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SceneRenamingEvent sceneRenamingEvent = new SceneRenamingEvent(this, oldName, newName);
        this.fireRenaming(sceneRenamingEvent);
        if (sceneRenamingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = ScenesNative.jni_Rename(this.m_workspace.getHandle(), oldName, newName);
        if (bl) {
            SceneRenamedEvent sceneRenamedEvent = new SceneRenamedEvent(this, oldName, newName);
            this.fireRenamed(sceneRenamedEvent);
        }
        return bl;
    }

    public synchronized void addAddedListener(SceneAddedListener l) {
        if (this.m_sceneAddedListeners == null) {
            this.m_sceneAddedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneAddedListeners.contains(l)) {
            this.m_sceneAddedListeners.add(l);
        }
    }

    public void removeAddedListener(SceneAddedListener l) {
        if (this.m_sceneAddedListeners != null && this.m_sceneAddedListeners.contains(l)) {
            this.m_sceneAddedListeners.remove(l);
        }
    }

    protected void fireAdded(SceneAddedEvent event) {
        if (this.m_sceneAddedListeners != null) {
            CopyOnWriteArrayList<SceneAddedListener> copyOnWriteArrayList = this.m_sceneAddedListeners;
            for (SceneAddedListener sceneAddedListener : copyOnWriteArrayList) {
                sceneAddedListener.sceneAdded(event);
            }
        }
    }

    public synchronized void addRemovingListener(SceneRemovingListener l) {
        if (this.m_sceneRemovingListeners == null) {
            this.m_sceneRemovingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRemovingListeners.contains(l)) {
            this.m_sceneRemovingListeners.add(l);
        }
    }

    public void removeRemovingListener(SceneRemovingListener l) {
        if (this.m_sceneRemovingListeners != null && this.m_sceneRemovingListeners.contains(l)) {
            this.m_sceneRemovingListeners.remove(l);
        }
    }

    protected void fireRemoving(SceneRemovingEvent event) {
        if (this.m_sceneRemovingListeners != null) {
            CopyOnWriteArrayList<SceneRemovingListener> copyOnWriteArrayList = this.m_sceneRemovingListeners;
            for (SceneRemovingListener sceneRemovingListener : copyOnWriteArrayList) {
                sceneRemovingListener.sceneRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(SceneRemovedListener l) {
        if (this.m_sceneRemovedListeners == null) {
            this.m_sceneRemovedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRemovedListeners.contains(l)) {
            this.m_sceneRemovedListeners.add(l);
        }
    }

    public void removeRemovedListener(SceneRemovedListener l) {
        if (this.m_sceneRemovedListeners != null && this.m_sceneRemovedListeners.contains(l)) {
            this.m_sceneRemovedListeners.remove(l);
        }
    }

    protected void fireRemoved(SceneRemovedEvent event) {
        if (this.m_sceneRemovedListeners != null) {
            CopyOnWriteArrayList<SceneRemovedListener> copyOnWriteArrayList = this.m_sceneRemovedListeners;
            for (SceneRemovedListener sceneRemovedListener : copyOnWriteArrayList) {
                sceneRemovedListener.sceneRemoved(event);
            }
        }
    }

    public synchronized void addClearingListener(SceneClearingListener l) {
        if (this.m_sceneClearingListeners == null) {
            this.m_sceneClearingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneClearingListeners.contains(l)) {
            this.m_sceneClearingListeners.add(l);
        }
    }

    public void removeClearingListener(SceneClearingListener l) {
        if (this.m_sceneClearingListeners != null && this.m_sceneClearingListeners.contains(l)) {
            this.m_sceneClearingListeners.remove(l);
        }
    }

    protected void fireClearing(SceneClearingEvent event) {
        if (this.m_sceneClearingListeners != null) {
            CopyOnWriteArrayList<SceneClearingListener> copyOnWriteArrayList = this.m_sceneClearingListeners;
            for (SceneClearingListener sceneClearingListener : copyOnWriteArrayList) {
                sceneClearingListener.sceneClearing(event);
            }
        }
    }

    public synchronized void addClearedListener(SceneClearedListener l) {
        if (this.m_sceneClearedListeners == null) {
            this.m_sceneClearedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneClearedListeners.contains(l)) {
            this.m_sceneClearedListeners.add(l);
        }
    }

    public void removeClearedListener(SceneClearedListener l) {
        if (this.m_sceneClearedListeners != null && this.m_sceneClearedListeners.contains(l)) {
            this.m_sceneClearedListeners.remove(l);
        }
    }

    protected void fireCleared(SceneClearedEvent event) {
        if (this.m_sceneClearedListeners != null) {
            CopyOnWriteArrayList<SceneClearedListener> copyOnWriteArrayList = this.m_sceneClearedListeners;
            for (SceneClearedListener sceneClearedListener : copyOnWriteArrayList) {
                sceneClearedListener.sceneCleared(event);
            }
        }
    }

    public synchronized void addRenamingListener(SceneRenamingListener l) {
        if (this.m_sceneRenamingListeners == null) {
            this.m_sceneRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRenamingListeners.contains(l)) {
            this.m_sceneRenamingListeners.add(l);
        }
    }

    public void removeRenamingListener(SceneRenamingListener l) {
        if (this.m_sceneRenamingListeners != null && this.m_sceneRenamingListeners.contains(l)) {
            this.m_sceneRenamingListeners.remove(l);
        }
    }

    protected void fireRenaming(SceneRenamingEvent event) {
        if (this.m_sceneRenamingListeners != null) {
            CopyOnWriteArrayList<SceneRenamingListener> copyOnWriteArrayList = this.m_sceneRenamingListeners;
            for (SceneRenamingListener sceneRenamingListener : copyOnWriteArrayList) {
                sceneRenamingListener.sceneRenaming(event);
            }
        }
    }

    public synchronized void addRenamedListener(SceneRenamedListener l) {
        if (this.m_sceneRenamedListeners == null) {
            this.m_sceneRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRenamedListeners.contains(l)) {
            this.m_sceneRenamedListeners.add(l);
        }
    }

    public void removeRenamedListener(SceneRenamedListener l) {
        if (this.m_sceneRenamedListeners != null && this.m_sceneRenamedListeners.contains(l)) {
            this.m_sceneRenamedListeners.remove(l);
        }
    }

    protected void fireRenamed(SceneRenamedEvent event) {
        if (this.m_sceneRenamedListeners != null) {
            CopyOnWriteArrayList<SceneRenamedListener> copyOnWriteArrayList = this.m_sceneRenamedListeners;
            for (SceneRenamedListener sceneRenamedListener : copyOnWriteArrayList) {
                sceneRenamedListener.sceneRenamed(event);
            }
        }
    }

    protected void clearHandle() {
        this.m_workspace = null;
    }
}

