/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoBSpline;
import com.supermap.data.GeoCardinal;
import com.supermap.data.GeoCurve;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import java.util.ArrayList;

public class Point2Ds {
    private ArrayList m_point2Ds = null;
    private GeoLine m_geoLine = null;
    private GeoRegion m_geoRegion = null;
    private UserType m_userType = UserType.NONE;
    private GeoCardinal m_geoCardinal = null;
    private GeoBSpline m_geoBSpline = null;
    private GeoCurve m_geoCurve = null;

    public Point2Ds() {
        this.m_point2Ds = new ArrayList();
        this.m_userType = UserType.NONE;
    }

    public Point2Ds(Point2D[] points) {
        this();
        this.addRange(points);
    }

    public Point2Ds(Point2Ds points) {
        this();
        int n = points.getCount();
        for (int i = 0; i < n; ++i) {
            this.m_point2Ds.add(points.getItem(i).clone());
        }
    }

    Point2Ds(Point2Ds points, GeoLine geoLine) {
        this(points);
        this.m_geoLine = geoLine;
        this.m_userType = UserType.GEOLINE;
    }

    Point2Ds(Point2Ds points, GeoRegion geoRegion) {
        this(points);
        this.m_geoRegion = geoRegion;
        this.m_userType = UserType.GEOREGION;
    }

    Point2Ds(Point2Ds points, GeoCardinal geoCardinal) {
        this(points);
        this.m_geoCardinal = geoCardinal;
        this.m_userType = UserType.GEOCARDINAL;
    }

    Point2Ds(Point2Ds points, GeoBSpline geoBSpline) {
        this(points);
        this.m_geoBSpline = geoBSpline;
        this.m_userType = UserType.GEOBSPLINE;
    }

    Point2Ds(Point2Ds points, GeoCurve geoCurve) {
        this(points);
        this.m_geoCurve = geoCurve;
        this.m_userType = UserType.GEOCURVE;
    }

    public int getCount() {
        if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCURVE.value() && this.m_geoCurve.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_point2Ds.size();
    }

    public Point2D getItem(int index) {
        int n;
        if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoLine.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoRegion.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCURVE.value() && this.m_geoCurve.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = (Point2D)this.m_point2Ds.get(index);
        return point2D.clone();
    }

    public void setItem(int index, Point2D point2D) {
        if (this.m_userType.value() == UserType.NONE.value()) {
            this.m_point2Ds.set(index, point2D.clone());
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.set(index, point2D);
            this.m_geoLine.setPartJustToUGC(n, this);
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (index == 0) {
                this.m_point2Ds.set(this.m_point2Ds.size() - 1, point2D);
            } else if (index == this.m_point2Ds.size() - 1) {
                this.m_point2Ds.set(0, point2D);
            }
            this.m_point2Ds.set(index, point2D);
            this.m_geoRegion.setPartJustToUGC(n, this);
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem(int index, Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.set(index, point2D);
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem(int index, Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.set(index, point2D);
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem(int index, Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.set(index, point2D);
            this.m_geoCurve.setControlPoints(this);
        }
    }

    public Point2Ds clone() {
        if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCURVE.value() && this.m_geoCurve.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new Point2Ds(this);
    }

    public int add(Point2D pt) {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        if (this.m_userType.value() == UserType.NONE.value()) {
            n2 = this.m_point2Ds.size() - 1;
            bl = this.m_point2Ds.add(pt.clone());
            if (bl) {
                n = this.m_point2Ds.size() - 1;
            }
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n2 = this.m_point2Ds.size() - 1;
            bl = this.m_point2Ds.add(pt.clone());
            if (bl) {
                n = this.m_point2Ds.size() - 1;
            }
            int n4 = this.m_geoLine.getPartsList().indexOf(this);
            this.m_geoLine.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n5 = this.m_geoRegion.getPartsList().indexOf(this);
            if (n5 == -1) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n2 = this.m_point2Ds.size() - 1;
            bl = this.m_point2Ds.add(pt.clone());
            if (bl) {
                n = this.m_point2Ds.size() - 1;
            }
            this.m_point2Ds.remove(n2);
            this.m_geoRegion.setPart(n5, this);
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Point2D pt)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            bl = this.m_point2Ds.add(pt.clone());
            if (bl) {
                n = this.m_point2Ds.size() - 1;
            }
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Point2D pt)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            bl = this.m_point2Ds.add(pt.clone());
            if (bl) {
                n = this.m_point2Ds.size() - 1;
            }
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Point2D pt)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            bl = this.m_point2Ds.add(pt.clone());
            if (bl) {
                n = this.m_point2Ds.size() - 1;
            }
            this.m_geoCurve.setControlPoints(this);
        }
        return n;
    }

    public int addRange(Point2D[] points) {
        int n = points.length;
        int n2 = this.m_point2Ds.size() - 1;
        if (this.m_userType.value() == UserType.NONE.value()) {
            for (int i = 0; i < n; ++i) {
                this.m_point2Ds.add(points[i].clone());
            }
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point2Ds.add(points[i].clone());
            }
            this.m_geoLine.setPart(n3, this);
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoRegion.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point2Ds.add(points[i].clone());
            }
            this.m_point2Ds.remove(n2);
            this.m_geoRegion.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange(Point2D[] points)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point2Ds.add(points[i].clone());
            }
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange(Point2D[] points)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point2Ds.add(points[i].clone());
            }
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange(Point2D[] points)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point2Ds.add(points[i].clone());
            }
            this.m_geoCurve.setControlPoints(this);
        }
        return n;
    }

    public boolean insert(int index, Point2D pt) {
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insert(int index, Point2D pt)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int n = this.m_point2Ds.size() - 1;
        int n2 = this.m_point2Ds.size();
        if (this.m_userType.value() == UserType.NONE.value()) {
            this.m_point2Ds.add(index, pt.clone());
            bl = this.m_point2Ds.size() == n2 + 1;
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.add(index, pt.clone());
            bl = this.m_point2Ds.size() == n2 + 1;
            this.m_geoLine.setPart(n3, this);
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoRegion.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.add(index, pt.clone());
            bl = this.m_point2Ds.size() == n2 + 1;
            if (index == 0) {
                this.m_point2Ds.remove(n + 1);
            }
            if (index == this.m_point2Ds.size()) {
                this.m_point2Ds.remove(n);
            }
            this.m_geoRegion.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Point2D pt)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.add(index, pt.clone());
            bl = this.m_point2Ds.size() == n2 + 1;
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Point2D pt)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.add(index, pt.clone());
            bl = this.m_point2Ds.size() == n2 + 1;
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Point2D pt)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point2Ds.add(index, pt.clone());
            bl = this.m_point2Ds.size() == n2 + 1;
            this.m_geoCurve.setControlPoints(this);
        }
        return bl;
    }

    public int insertRange(int index, Point2D[] points) {
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insertRange(int index, Point2D[] points)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_point2Ds.size() - 1;
        int n2 = points.length;
        if (this.m_userType.value() == UserType.NONE.value()) {
            for (int i = 0; i < n2; ++i) {
                int n3 = index + i;
                this.m_point2Ds.add(n3, points[i].clone());
            }
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoLine.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n5 = index + i;
                this.m_point2Ds.add(n5, points[i].clone());
            }
            this.m_geoLine.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n6 = this.m_geoRegion.getPartsList().indexOf(this);
            if (n6 == -1) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n7 = index + i;
                this.m_point2Ds.add(n7, points[i].clone());
            }
            if (index == 0) {
                this.m_point2Ds.remove(n + n2);
            }
            if (index == this.m_point2Ds.size()) {
                this.m_point2Ds.remove(n);
            }
            this.m_geoRegion.setPart(n6, this);
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange(int index, Point2D[] points)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n8 = index + i;
                this.m_point2Ds.add(n8, points[i].clone());
            }
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange(int index, Point2D[] points)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n9 = index + i;
                this.m_point2Ds.add(n9, points[i].clone());
            }
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange(int index, Point2D[] points)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n10 = index + i;
                this.m_point2Ds.add(n10, points[i].clone());
            }
            this.m_geoCurve.setControlPoints(this);
        }
        return n2;
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("remove(int index)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = null;
        Point2D point2D2 = null;
        boolean bl = false;
        if (this.m_userType.value() == UserType.NONE.value()) {
            point2D = (Point2D)this.m_point2Ds.get(index);
            if (point2D.equals(point2D2 = (Point2D)this.m_point2Ds.remove(index))) {
                bl = true;
            }
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 2) {
                String string = InternalResource.loadString("remove()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point2D = (Point2D)this.m_point2Ds.get(index);
            if (point2D.equals(point2D2 = (Point2D)this.m_point2Ds.remove(index))) {
                this.m_geoLine.setPart(n, this);
                bl = true;
            }
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 4) {
                String string = InternalResource.loadString("remove()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point2D = (Point2D)this.m_point2Ds.get(index);
            if (point2D.equals(point2D2 = (Point2D)this.m_point2Ds.remove(index))) {
                if (index == 0) {
                    this.m_point2Ds.remove(this.m_point2Ds.size() - 1);
                }
                if (index == this.m_point2Ds.size()) {
                    this.m_point2Ds.remove(0);
                }
                this.m_geoRegion.setPart(n, this);
                bl = true;
            }
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 2) {
                String string = InternalResource.loadString("remove(int index)", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point2D = (Point2D)this.m_point2Ds.get(index);
            if (point2D.equals(point2D2 = (Point2D)this.m_point2Ds.remove(index))) {
                bl = true;
            }
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 4) {
                String string = InternalResource.loadString("remove(int index)", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point2D = (Point2D)this.m_point2Ds.get(index);
            if (point2D.equals(point2D2 = (Point2D)this.m_point2Ds.remove(index))) {
                bl = true;
            }
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 6) {
                String string = InternalResource.loadString("remove(int index)", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point2D = (Point2D)this.m_point2Ds.get(index);
            if (point2D.equals(point2D2 = (Point2D)this.m_point2Ds.remove(index))) {
                bl = true;
            }
            this.m_geoCurve.setControlPoints(this);
        }
        return bl;
    }

    public int removeRange(int index, int count) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        int n2 = n - count;
        if (this.m_userType.value() == UserType.NONE.value()) {
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point2Ds.remove(i);
            }
        } else if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 2) {
                String string = InternalResource.loadString("removeRange()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point2Ds.remove(i);
            }
            this.m_geoLine.setPart(n3, this);
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoRegion.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 4) {
                String string = InternalResource.loadString("removeRange()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point2Ds.remove(i);
            }
            if (index == 0) {
                this.m_point2Ds.remove(this.m_point2Ds.size() - 1);
            }
            if (index + count == n) {
                this.m_point2Ds.remove(0);
            }
            this.m_geoRegion.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 2) {
                String string = InternalResource.loadString("removeRange()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point2Ds.remove(i);
            }
            this.m_geoCardinal.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 4) {
                String string = InternalResource.loadString("removeRange()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point2Ds.remove(i);
            }
            this.m_geoBSpline.setControlPoints(this);
        } else if (this.m_userType.value() == UserType.GEOCURVE.value()) {
            if (this.m_geoCurve.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 6) {
                String string = InternalResource.loadString("removeRange()", "Point2Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point2Ds.remove(i);
            }
            this.m_geoCurve.setControlPoints(this);
        }
        return count;
    }

    public void clear() {
        if (this.m_userType.equals(UserType.GEOLINE) || this.m_userType.equals(UserType.GEOREGION)) {
            String string = InternalResource.loadString("clear()", "Point2Ds_CannotDoClearOperation", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.m_point2Ds.clear();
    }

    public Point2D[] toArray() {
        int n;
        if (this.m_userType.value() == UserType.GEOLINE.value()) {
            if (this.m_geoLine.getHandle() == 0L) {
                String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoLine.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION.value()) {
            if (this.m_geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoRegion.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCARDINAL.value()) {
            if (this.m_geoCardinal.getHandle() == 0L) {
                String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOBSPLINE.value()) {
            if (this.m_geoBSpline.getHandle() == 0L) {
                String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOCURVE.value() && this.m_geoCurve.getHandle() == 0L) {
            String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        n = this.m_point2Ds.size();
        Point2D[] point2DArray = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = (Point2D)this.m_point2Ds.get(i);
        }
        return point2DArray;
    }

    public Point3Ds toPoint3Ds() {
        int n = this.getCount();
        Point3D[] point3DArray = new Point3D[n];
        for (int i = 0; i < n; ++i) {
            point3DArray[i] = new Point3D();
            point3DArray[i].setX(this.getItem(i).getX());
            point3DArray[i].setY(this.getItem(i).getY());
            point3DArray[i].setZ(0.0);
        }
        Point3Ds point3Ds = new Point3Ds(point3DArray);
        return point3Ds;
    }

    UserType getUserType() {
        return this.m_userType;
    }

    void setUserType(UserType userType) {
        this.m_userType = userType;
    }

    static class UserType
    extends Enum {
        public static final UserType NONE = new UserType(1, 1);
        public static final UserType GEOLINE = new UserType(2, 2);
        public static final UserType GEOREGION = new UserType(3, 3);
        public static final UserType GEOCARDINAL = new UserType(4, 4);
        public static final UserType GEOBSPLINE = new UserType(5, 5);
        public static final UserType GEOCURVE = new UserType(6, 6);

        private UserType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }
}

