/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCurveNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class GeoCurve
extends Geometry {
    private Point2Ds m_point2Ds = null;

    public GeoCurve() {
        long l = GeoCurveNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoCurve(GeoCurve GeoCurve2) {
        if (GeoCurve2 == null) {
            String string = InternalResource.loadString("GeoCurve", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(GeoCurve2);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoCurve", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCurveNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.m_point2Ds = new Point2Ds(GeoCurve2.getControlPoints(), this);
        InternalHandleDisposable.makeSureNativeObjectLive(GeoCurve2);
    }

    public GeoCurve(Point2Ds controlPoints) {
        int n = controlPoints.getCount();
        if (n < 6) {
            String string = InternalResource.loadString("controlPoints", "GeoCurve_ControlPointsLengthShouldNotLessThanSix", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = controlPoints.getItem(i).getX();
            dArray2[i] = controlPoints.getItem(i).getY();
        }
        long l = GeoCurveNative.jni_New2(dArray, dArray2);
        this.setHandle(l, true);
        this.m_point2Ds = new Point2Ds(controlPoints, this);
    }

    GeoCurve(long handle) {
        this.setHandle(handle, false);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCurveNative.jni_GetLength(this.getHandle());
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCurveNative.jni_IsEmpty(this.getHandle());
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_point2Ds.clear();
        this.m_point2Ds = null;
        GeoCurveNative.jni_SetEmpty(this.getHandle());
    }

    public Point2Ds getControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoCurveNative.jni_GetPartPointCount(this.getHandle());
        if (n >= 6) {
            int n2;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            GeoCurveNative.jni_GetControlPoints(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds = new Point2Ds();
            for (n2 = 0; n2 < n; ++n2) {
                point2Ds.add(new Point2D(dArray[n2], dArray2[n2]));
            }
            if (this.m_point2Ds == null) {
                this.m_point2Ds = new Point2Ds(point2Ds, this);
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    this.m_point2Ds.add(new Point2D(dArray[n2], dArray2[n2]));
                }
                n2 = this.m_point2Ds.getCount();
                this.m_point2Ds.removeRange(0, n2 - n);
            }
        }
        return this.m_point2Ds;
    }

    public void setControlPoints(Point2Ds controlPoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setControlPoints(Point2Ds controlPoints)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = controlPoints.getCount();
        if (n < 6) {
            String string = InternalResource.loadString("controlPoints", "GeoCurve_ControlPointsLengthShouldNotLessThanSix", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = controlPoints.getItem(i).getX();
            dArray2[i] = controlPoints.getItem(i).getY();
        }
        GeoCurveNative.jni_SetControlPoints(this.getHandle(), dArray, dArray2);
    }

    public GeoLine convertToLine(int pointCountPerSegment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (pointCountPerSegment < 2) {
            String string = InternalResource.loadString("pointCountPerSegment", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoCurveNative.jni_ConvertToLine(this.getHandle(), pointCountPerSegment);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    @Override
    public GeoCurve clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCurve(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCurveNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

