/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Charset;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.DatasourceDisconnectedEvent;
import com.supermap.data.DatasourceDisconnectedListener;
import com.supermap.data.DatasourceLockChangedEvent;
import com.supermap.data.DatasourceLockChangedListener;
import com.supermap.data.DatasourceNative;
import com.supermap.data.DatasourceRefreshedEvent;
import com.supermap.data.DatasourceRefreshedListener;
import com.supermap.data.Datasources;
import com.supermap.data.DomainManager;
import com.supermap.data.DynamicSegmentManager;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.LockStateType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TextStyle;
import com.supermap.data.Unit;
import com.supermap.data.VersionManager;
import com.supermap.data.Workspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

public class Datasource
extends InternalHandle {
    private Workspace m_workspace;
    private Datasets m_datasets;
    private DatasourceConnectionInfo m_datasourceConnectionInfo;
    private PrjCoordSys m_prjCoordSys;
    private VersionManager m_versionManager;
    private DynamicSegmentManager m_dynamicsegmentManager;
    private static Timer m_Timer = new Timer(600000, null);
    ActionListener m_Listener = null;
    boolean m_connected = true;
    private transient CopyOnWriteArrayList<DatasourceDisconnectedListener> m_disConnectedListeners;
    private transient CopyOnWriteArrayList<DatasourceLockChangedListener> m_disLockChangedListeners;
    private transient CopyOnWriteArrayList<DatasourceRefreshedListener> m_refreshedListeners;
    private final Object m_lock = new Object();
    private static final Object m_lockListen = new Object();
    transient CopyOnWriteArrayList<SteppedListener> m_steppedListeners;
    protected static String m_senderMethodName;
    protected long m_selfEventHandle;
    private DatasetGroup m_rootGroup;
    private DomainManager m_DomainManager;

    protected Datasource() {
    }

    public Dataset open(DatasourceConnectionInfo connectioninfo, String strDtName) {
        DatasetType datasetType;
        this.m_datasourceConnectionInfo = connectioninfo;
        long[] lArray = new long[]{0L};
        int[] nArray = new int[1];
        boolean bl = DatasourceNative.jni_Open2(this.getHandle(), this.m_datasourceConnectionInfo.getHandle(), lArray, nArray, strDtName);
        if (!bl) {
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        try {
            datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[0]);
        }
        catch (RuntimeException runtimeException) {
            if (nArray[0] == 88) {
                datasetType = DatasetType.IMAGE;
            }
            if (nArray[0] == 90) {
                datasetType = DatasetType.DEM;
            }
            if (nArray[0] == DatasetType.DEM.getUGCValue()) {
                datasetType = DatasetType.DEM;
            }
            return null;
        }
        try {
            Dataset dataset = Dataset.createInstance(lArray[0], datasetType, this);
            return dataset;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Datasource(EngineType enginetype) {
        int n = enginetype.value();
        long l = DatasourceNative.jni_New(this.getHandle(), n);
        if (l == 0L) {
            return;
        }
        this.setHandle(l);
        l = DatasourceNative.jni_GetConnectionInfo(this.getHandle());
        this.m_datasourceConnectionInfo = new DatasourceConnectionInfo(this, l);
        this.m_datasets = new Datasets(this);
        l = DatasourceNative.jni_GetPrjCoordSys(this.getHandle());
        this.m_prjCoordSys = new PrjCoordSys(l, false);
        this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
        if (this.m_Listener == null) {
            this.m_Listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!Datasource.this.connect()) {
                        DatasourceDisconnectedEvent datasourceDisconnectedEvent = new DatasourceDisconnectedEvent(this, Datasource.this);
                        if (Datasource.this.m_connected) {
                            Datasource.this.fireDisconnected(datasourceDisconnectedEvent);
                            Datasource.this.m_connected = false;
                        }
                    } else {
                        Datasource.this.m_connected = true;
                    }
                }
            };
        }
        m_Timer.addActionListener(this.m_Listener);
    }

    public boolean open(DatasourceConnectionInfo connectioninfo) {
        if (this.m_workspace != null) {
            Datasources datasources = this.m_workspace.getDatasources();
            datasources.open(connectioninfo);
            return true;
        }
        if (this.getHandle() == 0L) {
            return false;
        }
        this.m_datasourceConnectionInfo = connectioninfo;
        boolean bl = DatasourceNative.jni_Open(this.getHandle(), this.m_datasourceConnectionInfo.getHandle());
        if (bl) {
            this.m_datasets.reset();
            return true;
        }
        return false;
    }

    public boolean create(DatasourceConnectionInfo connectioninfo) {
        this.m_datasourceConnectionInfo = connectioninfo;
        boolean bl = DatasourceNative.jni_Create(this.getHandle(), this.m_datasourceConnectionInfo.getHandle());
        if (bl) {
            this.m_datasets.reset();
            return true;
        }
        return false;
    }

    public void close() {
        if (this.m_workspace != null) {
            Datasources datasources = this.m_workspace.getDatasources();
            String string = this.getAlias();
            datasources.close(string);
        } else {
            DatasourceNative.jni_Close(this.getHandle());
            DatasourceNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    Datasource(long handle, Workspace workspace) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null || workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("workspace", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_workspace = workspace;
        this.setHandle(handle);
        long l = DatasourceNative.jni_GetConnectionInfo(this.getHandle());
        this.m_datasourceConnectionInfo = new DatasourceConnectionInfo(this, l);
        this.m_datasets = new Datasets(this);
        l = DatasourceNative.jni_GetPrjCoordSys(this.getHandle());
        this.m_prjCoordSys = new PrjCoordSys(l, false);
        this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
        if (this.m_Listener == null) {
            this.m_Listener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Object object = m_lockListen;
                    synchronized (object) {
                        if (!Datasource.this.connect()) {
                            DatasourceDisconnectedEvent datasourceDisconnectedEvent = new DatasourceDisconnectedEvent(this, Datasource.this);
                            if (Datasource.this.m_connected) {
                                Datasource.this.fireDisconnected(datasourceDisconnectedEvent);
                                Datasource.this.m_connected = false;
                            }
                        } else {
                            Datasource.this.m_connected = true;
                        }
                    }
                }
            };
        }
        m_Timer.addActionListener(this.m_Listener);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
    }

    protected static Datasource createInstance(long handle, Workspace workspace) {
        return new Datasource(handle, workspace);
    }

    public String getAlias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetAlias(this.getHandle());
    }

    public static int getConnectCheckInterval() {
        return m_Timer.getDelay();
    }

    public static void setConnectCheckInterval(int interval) {
        m_Timer.setDelay(interval);
    }

    public boolean isConnected() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsConnected(this.getHandle());
    }

    public boolean isOpened() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsOpened(this.getHandle());
    }

    public boolean isAutoConnect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsAutoConnected(this.getHandle());
    }

    public void setAutoConnect(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasourceNative.jni_SetIsAutoConnected(this.getHandle(), value);
    }

    public DatasourceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasourceConnectionInfo;
    }

    public Datasets getDatasets() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasets;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetDescription(this.getHandle());
    }

    public int ReleaseIdleConn() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_ReleaseIdleConn(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        DatasourceNative.jni_SetDescription(this.getHandle(), value);
    }

    public EngineType getEngineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = this.m_datasourceConnectionInfo.getServer();
        if (string.compareToIgnoreCase(":memory:") == 0) {
            return EngineType.MEMORY;
        }
        return this.m_datasourceConnectionInfo.getEngineType();
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsModified(this.getHandle());
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_prjCoordSys;
    }

    public void setPrjCoordSys(PrjCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasourceNative.jni_SetPrjCoordSys(this.getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public Unit getCoordUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceNative.jni_GetCoordUnit(this.getHandle());
        return (Unit)Enum.parseUGCValue(Unit.class, n);
    }

    public void setCoordUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoordUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = value.getUGCValue();
        DatasourceNative.jni_SetCoordUnit(this.getHandle(), n);
    }

    public Unit getDistanceUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceNative.jni_GetDistanceUnit(this.getHandle());
        return (Unit)Enum.parseUGCValue(Unit.class, n);
    }

    public void setDistanceUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistanceUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = value.getUGCValue();
        DatasourceNative.jni_SetDistanceUnit(this.getHandle(), n);
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsReadOnly(this.getHandle());
    }

    public boolean isUnicodeSupported() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetIsSupportUnicode(this.getHandle());
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanConnect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        Workspace workspace = this.m_workspace;
        synchronized (workspace) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.isConnected()) {
                    return true;
                }
                bl = DatasourceNative.jni_Connect(this.getHandle());
                if (bl) {
                    this.m_datasets = new Datasets(this);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        Workspace workspace = this.m_workspace;
        synchronized (workspace) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.isConnected()) {
                    return true;
                }
                bl = DatasourceNative.jni_Connect(this.getHandle());
                if (bl) {
                    this.m_datasets = new Datasets(this);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset copyDataset(Dataset srcDataset, String desDatasetName, EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (srcDataset == null || srcDataset.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object object = this.m_lock;
        synchronized (object) {
            int n = encodeType.getUGCValue();
            if (srcDataset.getType().equals(DatasetType.CAD)) {
                n = 0;
            }
            m_senderMethodName = "copyDataset";
            this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
            long l = DatasourceNative.jni_CopyDataset(this.getHandle(), srcDataset.getHandle(), desDatasetName, n, this.m_selfEventHandle);
            if (l == 0L) {
                return null;
            }
            Dataset dataset = Dataset.createInstance(l, srcDataset.getType(), this);
            this.m_datasets.add(dataset);
            return dataset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset copyDatasetWithSmID(Dataset srcDataset, String desDatasetName, EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (srcDataset == null || srcDataset.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object object = this.m_lock;
        synchronized (object) {
            int n = encodeType.getUGCValue();
            if (srcDataset.getType().equals(DatasetType.CAD)) {
                n = 0;
            }
            m_senderMethodName = "copyDataset";
            this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
            long l = DatasourceNative.jni_CopyDatasetWithSmID(this.getHandle(), srcDataset.getHandle(), desDatasetName, n, this.m_selfEventHandle);
            if (l == 0L) {
                return null;
            }
            Dataset dataset = Dataset.createInstance(l, srcDataset.getType(), this);
            this.m_datasets.add(dataset);
            return dataset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset copyDataset(Dataset srcDataset, String desDatasetName, EncodeType encodeType, Charset nCharset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (srcDataset == null || srcDataset.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object object = this.m_lock;
        synchronized (object) {
            int n = encodeType.getUGCValue();
            if (srcDataset.getType().equals(DatasetType.CAD)) {
                n = 0;
            }
            int n2 = nCharset.getUGCValue();
            m_senderMethodName = "copyDataset";
            this.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(this);
            long l = DatasourceNative.jni_CopyDataset2(this.getHandle(), srcDataset.getHandle(), desDatasetName, n, n2, this.m_selfEventHandle);
            if (l == 0L) {
                return null;
            }
            Dataset dataset = Dataset.createInstance(l, srcDataset.getType(), this);
            this.m_datasets.add(dataset);
            return dataset;
        }
    }

    public DatasetVector innerPointToDataset(DatasetVector srcDataset, String desDatasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (srcDataset.getType().equals(DatasetType.TABULAR) || srcDataset.getType().equals(DatasetType.LINKTABLE)) {
            String string = InternalResource.loadString("innerPointToDataset", "Datasource_DatasetHasNoInnerPoint", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasourceNative.jni_InnerPointToDataset(this.getHandle(), srcDataset.getHandle(), desDatasetName);
        if (l == 0L) {
            return null;
        }
        DatasetVector datasetVector = new DatasetVector(l, this);
        this.getDatasets().add(datasetVector);
        return datasetVector;
    }

    public DatasetVector fieldToPointDataset(DatasetVector srcDataset, String desDatasetName, String fieldX, String fieldY) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (srcDataset == null || srcDataset.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().equals("")) {
            String string = InternalResource.loadString("desDatasetName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (fieldX == null || fieldX.trim().equals("")) {
            String string = InternalResource.loadString("fieldX", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (fieldY == null || fieldY.trim().equals("")) {
            String string = InternalResource.loadString("fieldY", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcDataset.getFieldInfos().indexOf(fieldX) == -1) {
            String string = InternalResource.loadString("fieldX", "Datasource_FieldIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (srcDataset.getFieldInfos().indexOf(fieldY) == -1) {
            String string = InternalResource.loadString("fieldY", "Datasource_FieldIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasourceNative.jni_FieldToPointDataset(this.getHandle(), srcDataset.getHandle(), desDatasetName, fieldX, fieldY);
        if (l == 0L) {
            return null;
        }
        DatasetVector datasetVector = new DatasetVector(l, this);
        this.m_datasets.add(datasetVector);
        return datasetVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector labelToTextDataset(DatasetVector srcDataset, String desDatasetName, String textField, TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (srcDataset.getType().equals(DatasetType.TABULAR) || srcDataset.getType().equals(DatasetType.LINKTABLE)) {
            String string = InternalResource.loadString("labelToTextDataset", "Datasource_DatasetHasNoInnerPoint", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (textField == null || textField.trim().equals("")) {
            String string = InternalResource.loadString("textField", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object object = this.m_lock;
        synchronized (object) {
            long l;
            long l2 = 0L;
            if (textStyle != null) {
                l2 = textStyle.getHandle();
            }
            if ((l = DatasourceNative.jni_LabelToTextDataset(this.getHandle(), srcDataset.getHandle(), desDatasetName, textField, l2)) == 0L) {
                return null;
            }
            DatasetVector datasetVector = new DatasetVector(l, this);
            this.m_datasets.add(datasetVector);
            InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
            return datasetVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector recordsetToDataset(Recordset recordset, String desDatasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Datasource_TheDatasourceIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null || recordset.getHandle() == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        if (desDatasetName == null || desDatasetName.trim().length() == 0) {
            String string = InternalResource.loadString("desDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.getDatasets().isAvailableDatasetName(desDatasetName)) {
            String string = InternalResource.loadString("desDatasetName", "Datasource_DatasetNameIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasourceNative.jni_RecordsetToDataset(this.getHandle(), recordset.getHandle(), desDatasetName);
        if (l == 0L) {
            InternalHandleDisposable.makeSureNativeObjectLive(recordset);
            return null;
        }
        DatasetVector datasetVector = new DatasetVector(l, this);
        Object object = this.m_lock;
        synchronized (object) {
            this.m_datasets.add(datasetVector);
            InternalHandleDisposable.makeSureNativeObjectLive(recordset);
            return datasetVector;
        }
    }

    @Deprecated
    public VersionManager getVersionManager() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        EngineType engineType = this.getEngineType();
        if ((engineType.equals(EngineType.ORACLEPLUS) || engineType.equals(EngineType.SQLPLUS)) && this.m_versionManager == null && (l = DatasourceNative.jni_GetVersionManager(this.getHandle())) != 0L) {
            this.m_versionManager = new VersionManager(l, this);
        }
        return this.m_versionManager;
    }

    public DomainManager getDomainManager() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_DomainManager == null && (l = DatasourceNative.jni_GetDomainManager(this.getHandle())) != 0L) {
            this.m_DomainManager = new DomainManager(l, this);
        }
        return this.m_DomainManager;
    }

    public boolean changePassword(String oldPassword, String newPassword) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("changePassword(String oldPassword, String newPassword)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldPassword == null || newPassword == null) {
            String string = InternalResource.loadString("password", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        String string = this.getConnectionInfo().getPassword();
        boolean bl = false;
        if (oldPassword.equals(string)) {
            bl = DatasourceNative.jni_ChangePassword(this.getHandle(), newPassword);
        }
        return bl;
    }

    public boolean createSequence(String sequenceName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_CreateSequence(this.getHandle(), sequenceName);
    }

    public boolean createSequence(String sequenceName, long startValue, long maxValue, int incrementValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_CreateSequence1(this.getHandle(), sequenceName, startValue, maxValue, incrementValue);
    }

    public long getSequenceNextValue(String sequenceName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = DatasourceNative.jni_GetSequenceNextValue(this.getHandle(), sequenceName);
        if (null == string) {
            String string2 = "";
            string2 = false == this.isSequenceExist(sequenceName) ? InternalResource.loadString("", "Sequence_Not_Exist", "data_resources") : InternalResource.loadString("", "Sequence_Is_MAX", "data_resources");
            throw new IllegalStateException(string2);
        }
        long l = Long.parseLong(string);
        return l;
    }

    public boolean deleteSequence(String sequenceName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_DeleteSequence(this.getHandle(), sequenceName);
    }

    public boolean isSequenceExist(String sequenceName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_IsSequenceExist(this.getHandle(), sequenceName);
    }

    public boolean executeSQL(String sql) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (sql == null || sql.trim().length() == 0) {
            String string = InternalResource.loadString("sql", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasourceNative.jni_ExecuteSQL(this.getHandle(), sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getEngineType() == EngineType.UDB || this.getEngineType() == EngineType.MEMORY) {
            int n = DatasourceNative.jni_GetDatasetsCount(this.getHandle());
            Datasets datasets = this.getDatasets();
            int n2 = datasets.getCount();
            long l = 0L;
            if (n > n2) {
                int n3 = 0;
                long[] lArray = new long[n];
                int[] nArray = new int[n];
                DatasourceNative.jni_GetDatasets(this.getHandle(), lArray, nArray);
                for (int i = 0; i < n; ++i) {
                    DatasetType datasetType;
                    l = lArray[i];
                    if (l <= 0L) continue;
                    for (n3 = 0; n3 < n2 && this.m_datasets.get(n3).getHandle() != l; ++n3) {
                    }
                    if (n3 < n2) continue;
                    try {
                        datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
                    }
                    catch (RuntimeException runtimeException) {
                        if (nArray[i] == 88) {
                            datasetType = DatasetType.IMAGE;
                        }
                        if (nArray[i] == 89) {
                            datasetType = DatasetType.GRID;
                        }
                        if (nArray[i] == 90) {
                            datasetType = DatasetType.DEM;
                        }
                        if (nArray[i] != DatasetType.DEM.getUGCValue()) continue;
                        datasetType = DatasetType.DEM;
                    }
                    try {
                        Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this);
                        if (dataset == null) continue;
                        this.getDatasets().add(dataset);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        Object object = this.m_lock;
        synchronized (object) {
            this.m_datasets.lock();
            if (this.getEngineType() == EngineType.ORACLEPLUS) {
                try {
                    Dataset dataset;
                    DatasetType datasetType;
                    int n;
                    int n4 = 10;
                    long[] lArray = new long[n4];
                    int[] nArray = new int[n4];
                    long[] lArray2 = new long[n4];
                    int[] nArray2 = new int[n4];
                    int n5 = DatasourceNative.jni_RefreshEx(this.getHandle(), lArray, nArray, lArray2, nArray2);
                    if (n5 > 0) {
                        lArray = null;
                        lArray = new long[n5];
                        nArray = null;
                        nArray = new int[n5];
                        lArray2 = null;
                        lArray2 = new long[n5];
                        nArray2 = null;
                        nArray2 = new int[n5];
                        DatasourceNative.jni_RefreshEx(this.getHandle(), lArray, nArray, lArray2, nArray2);
                        n4 = n5;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (n = 0; n < n4; ++n) {
                        datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[n]);
                        try {
                            dataset = Dataset.createInstance(lArray[n], datasetType, this);
                            arrayList.add(dataset.getName());
                            continue;
                        }
                        catch (IllegalStateException illegalStateException) {
                            break;
                        }
                    }
                    this.m_datasets.remove(arrayList);
                    for (n = 0; n < n4; ++n) {
                        datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray2[n]);
                        try {
                            dataset = Dataset.createInstance(lArray2[n], datasetType, this);
                            if (dataset == null) continue;
                            this.m_datasets.add(dataset);
                            continue;
                        }
                        catch (IllegalStateException illegalStateException) {
                        }
                    }
                }
                finally {
                    this.m_datasets.unlock();
                }
            } else {
                try {
                    int[] nArray = new int[2];
                    String[] stringArray = DatasourceNative.jni_Refresh(this.getHandle(), nArray, this.m_selfEventHandle);
                    if (nArray[0] > 0) {
                        this.m_datasets.reset();
                    } else if (nArray[1] > 0) {
                        String[] stringArray2 = new String[nArray[1]];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            stringArray2[i] = stringArray[nArray[0] + i];
                        }
                        this.getDatasets().addRange(stringArray2);
                    }
                }
                finally {
                    this.m_datasets.unlock();
                }
            }
        }
    }

    public boolean flush(String datasetName) {
        Dataset dataset;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetName == null) {
            String string = InternalResource.loadString("datasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetName.trim().length() != 0 && (dataset = this.m_datasets.get(datasetName)) == null) {
            String string = InternalResource.loadString("datasetName", "Global_SpecifiedNameNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasourceNative.jni_Flush(this.getHandle(), datasetName);
    }

    private int getIndex(String[] names, String name) {
        int n = -1;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(name)) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    protected void clearHandle() {
        this.m_workspace = null;
        this.m_datasets.clearHandle();
        this.m_datasets = null;
        this.m_datasourceConnectionInfo.clearHandle();
        this.m_datasourceConnectionInfo = null;
        this.clearSelfEventHandle();
        if (this.m_versionManager != null) {
            this.m_versionManager.clearHandle();
            this.m_versionManager = null;
        }
        if (this.m_dynamicsegmentManager != null) {
            this.m_dynamicsegmentManager.clearHandle();
            this.m_dynamicsegmentManager = null;
        }
        if (this.m_Listener != null) {
            m_Timer.removeActionListener(this.m_Listener);
            this.m_Listener = null;
            if (m_Timer.getActionListeners().length == 0) {
                m_Timer.stop();
            }
        }
        this.setHandle(0L);
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasourceNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public synchronized void addDisconnectedListener(DatasourceDisconnectedListener l) {
        if (this.m_disConnectedListeners == null) {
            this.m_disConnectedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_disConnectedListeners.contains(l)) {
            this.m_disConnectedListeners.add(l);
        }
        if (!m_Timer.isRunning()) {
            m_Timer.start();
        }
    }

    public void removeDisconnectedListener(DatasourceDisconnectedListener l) {
        if (this.m_disConnectedListeners != null && this.m_disConnectedListeners.contains(l)) {
            this.m_disConnectedListeners.remove(l);
        }
    }

    protected void fireDisconnected(DatasourceDisconnectedEvent event) {
        if (this.m_disConnectedListeners != null) {
            CopyOnWriteArrayList<DatasourceDisconnectedListener> copyOnWriteArrayList = this.m_disConnectedListeners;
            for (DatasourceDisconnectedListener datasourceDisconnectedListener : copyOnWriteArrayList) {
                datasourceDisconnectedListener.datasourceDisconnected(event);
            }
        }
    }

    public synchronized void addLockChangedListener(DatasourceLockChangedListener l) {
        if (this.m_disLockChangedListeners == null) {
            this.m_disLockChangedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_disLockChangedListeners.contains(l)) {
            this.m_disLockChangedListeners.add(l);
        }
        if (!m_Timer.isRunning()) {
            m_Timer.start();
        }
    }

    public void removeLockChangedListener(DatasourceLockChangedListener l) {
        if (this.m_disLockChangedListeners != null && this.m_disLockChangedListeners.contains(l)) {
            this.m_disLockChangedListeners.remove(l);
        }
    }

    protected void fireLockChanged(DatasourceLockChangedEvent event) {
        if (this.m_disLockChangedListeners != null) {
            CopyOnWriteArrayList<DatasourceLockChangedListener> copyOnWriteArrayList = this.m_disLockChangedListeners;
            for (DatasourceLockChangedListener datasourceLockChangedListener : copyOnWriteArrayList) {
                datasourceLockChangedListener.datasourceLockChanged(event);
            }
        }
    }

    public synchronized void addRefreshedListener(DatasourceRefreshedListener l) {
        if (this.m_refreshedListeners == null) {
            this.m_refreshedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_refreshedListeners.contains(l)) {
            this.m_refreshedListeners.add(l);
        }
        if (!m_Timer.isRunning()) {
            m_Timer.start();
        }
    }

    public void removeRefreshedListener(DatasourceRefreshedListener l) {
        if (this.m_refreshedListeners != null) {
            this.m_refreshedListeners.remove(l);
            if (this.m_refreshedListeners.size() == 0) {
                m_Timer.stop();
            }
        }
    }

    protected void fireRefreshed(DatasourceRefreshedEvent event) {
        if (this.m_refreshedListeners != null) {
            CopyOnWriteArrayList<DatasourceRefreshedListener> copyOnWriteArrayList = this.m_refreshedListeners;
            for (DatasourceRefreshedListener datasourceRefreshedListener : copyOnWriteArrayList) {
                datasourceRefreshedListener.datasourceRefreshed(event);
            }
        }
    }

    static void refreshDatasourceCallBack(Datasource datasource, String name) {
        if (datasource != null) {
            Datasets datasets = datasource.getDatasets();
            int n = datasets.indexOf(name);
            if (n != -1) {
                datasets.getList().remove(n);
            }
            DatasourceRefreshedEvent datasourceRefreshedEvent = new DatasourceRefreshedEvent(datasource, datasource);
            datasource.fireRefreshed(datasourceRefreshedEvent);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.m_steppedListeners;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(event);
            }
        }
    }

    static void steppedCallBack(Datasource source, int percent, long remainTime, String title, String message) {
        if (source != null) {
            SteppedEvent steppedEvent = new SteppedEvent(source, percent, remainTime, title, message, m_senderMethodName);
            source.fireStepped(steppedEvent);
        }
    }

    static boolean compareDatasources(Datasource datasource1, Datasource datasource2) {
        boolean bl = false;
        DatasourceConnectionInfo datasourceConnectionInfo = datasource1.getConnectionInfo();
        DatasourceConnectionInfo datasourceConnectionInfo2 = datasource2.getConnectionInfo();
        if (datasourceConnectionInfo.getEngineType().equals(datasourceConnectionInfo2.getEngineType()) && datasourceConnectionInfo.getServer().equals(datasourceConnectionInfo2.getServer()) && datasourceConnectionInfo.getDatabase().equals(datasourceConnectionInfo2.getDatabase()) && datasourceConnectionInfo.getUser().equals(datasourceConnectionInfo2.getUser())) {
            bl = true;
        }
        return bl;
    }

    protected static void refresh(Datasource ds) {
        ds.getDatasets().refresh();
        DatasetGroup datasetGroup = ds.getRootGroup();
        if (datasetGroup != null) {
            datasetGroup.getChildGroups().refreshManagedItem();
        }
    }

    protected static void refreshDatasets(Datasource ds) {
        ds.getDatasets().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataset() {
        Object object = this.m_lock;
        synchronized (object) {
            int n = DatasourceNative.jni_GetDatasetsCount(this.getHandle());
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            DatasetType datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[n - 1]);
            try {
                Dataset dataset = Dataset.createInstance(lArray[n - 1], datasetType, this);
                if (dataset != null) {
                    this.getDatasets().add(dataset);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public DatasetGroup getRootGroup() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_rootGroup == null && (l = DatasourceNative.jni_GetRootGroupHandle(this.getHandle())) != 0L) {
            this.m_rootGroup = new DatasetGroup(l, this, null);
        }
        return this.m_rootGroup;
    }

    public String getDateLastUpdated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_GetDateLastUpdated(this.getHandle());
    }

    public boolean isFieldIndexNameExist(String strIndexName, String strTableName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceNative.jni_IsFieldIndexNameExist(this.getHandle(), strIndexName, strTableName);
    }

    public LockStateType getLockState() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceNative.jni_GetLockState(this.getHandle());
        LockStateType lockStateType = null;
        try {
            lockStateType = (LockStateType)Enum.parseUGCValue(LockStateType.class, n);
        }
        catch (Exception exception) {
            lockStateType = LockStateType.LOCKNONE;
        }
        return lockStateType;
    }

    public boolean setLockState(LockStateType lockType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = lockType.getUGCValue();
        boolean bl = DatasourceNative.jni_SetLockState(this.getHandle(), n);
        if (bl) {
            DatasourceLockChangedEvent datasourceLockChangedEvent = new DatasourceLockChangedEvent(this, this);
            this.fireLockChanged(datasourceLockChangedEvent);
        }
        return bl;
    }
}

