/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.data.GeoGraphicObject;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.GraphicObjectType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.data.Recordset;
import com.supermap.plot.InternalResource;
import com.supermap.plot.SymbolInfo;
import com.supermap.plot.SymbolLibraryNative;
import java.util.ArrayList;

public class SymbolLibrary
extends InternalHandleDisposable {
    public SymbolLibrary(long handle) {
        this.setHandle(handle, false);
    }

    public SymbolInfo getRootNode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRootNode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolLibraryNative.jni_GetRootNode(this.getHandle());
        if (l == 0L) {
            String string = InternalResource.loadString("getRootNode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfo symbolInfo = new SymbolInfo(l);
        return symbolInfo;
    }

    public int getLibId() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibId()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetLibId(this.getHandle());
    }

    public int getSymbolCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetSymbolCount(this.getHandle());
    }

    public String getSymbolLibName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolLibName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetSymbolLibName(this.getHandle());
    }

    public String getClassFication() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClassFication()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetClassFication(this.getHandle());
    }

    public String getCreateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCreateTime()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetCreateTime(this.getHandle());
    }

    public String getCreator() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCreator()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetCreator(this.getHandle());
    }

    public String getModifyTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModifyTime()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetModifyTime(this.getHandle());
    }

    public String getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetVersion(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
    }

    public int getSymbolDotCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetSymbolDotCount(this.getHandle());
    }

    public int getSymbolAlgoCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetSymbolAlgoCount(this.getHandle());
    }

    public SymbolInfo[] querySymbol(String strkey) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SymbolLibraryNative.jni_GetQuerySymbolCount(this.getHandle(), strkey);
        long[] lArray = new long[n];
        SymbolLibraryNative.jni_QuerySymbol(this.getHandle(), strkey, lArray);
        SymbolInfo[] symbolInfoArray = new SymbolInfo[n];
        for (int i = 0; i < n; ++i) {
            symbolInfoArray[i] = new SymbolInfo(lArray[i]);
        }
        return symbolInfoArray;
    }

    public void save(String symbolPath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("save()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLibraryNative.jni_CompressAndSave(this.getHandle(), symbolPath);
    }

    public boolean saveSymbol(SymbolInfo symbolInfo, SymbolInfo parentSymbolInfo, Recordset rec) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveSymbol()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == symbolInfo || null == parentSymbolInfo || null == rec) {
            return false;
        }
        ArrayList<GeoGraphicObject> arrayList = new ArrayList<GeoGraphicObject>();
        boolean bl = rec.moveFirst();
        while (bl) {
            Geometry geometry = rec.getGeometry();
            if (null != geometry && geometry.getType() == GeometryType.GRAPHICOBJECT) {
                arrayList.add((GeoGraphicObject)geometry);
            }
            bl = rec.moveNext();
        }
        int n = arrayList.size();
        if (n == arrayList.size()) {
            return false;
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((InternalHandle)((InternalHandle)arrayList.get(i)));
        }
        return SymbolLibraryNative.jni_SaveSymbol(this.getHandle(), InternalHandle.getHandle((InternalHandle)symbolInfo), InternalHandle.getHandle((InternalHandle)parentSymbolInfo), lArray);
    }

    public boolean moveSymbol(int index, SymbolInfo symbolInfo, SymbolInfo parentSymbolInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveSymbol()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_MoveSymbol(this.getHandle(), index, InternalHandle.getHandle((InternalHandle)symbolInfo), InternalHandle.getHandle((InternalHandle)parentSymbolInfo));
    }

    public boolean moveSymbol(SymbolInfo symbolInfo, SymbolInfo oldParentSymbolInfo, SymbolInfo newParentSymbolInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveSymbol()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_MoveSymbol1(this.getHandle(), InternalHandle.getHandle((InternalHandle)symbolInfo), InternalHandle.getHandle((InternalHandle)oldParentSymbolInfo), InternalHandle.getHandle((InternalHandle)newParentSymbolInfo));
    }

    public boolean moveGroup(int index, SymbolInfo symbolInfo, SymbolInfo parentSymbolInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveGroup()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_MoveGroup(this.getHandle(), index, InternalHandle.getHandle((InternalHandle)symbolInfo), InternalHandle.getHandle((InternalHandle)parentSymbolInfo));
    }

    public SymbolInfo addGroup(String symbolName, SymbolInfo parentSymbolInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGroup()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolLibraryNative.jni_AddGroup(this.getHandle(), symbolName, InternalHandle.getHandle((InternalHandle)parentSymbolInfo));
        if (0L == l) {
            return null;
        }
        return new SymbolInfo(l);
    }

    public SymbolInfo createSymbol(SymbolInfo parentSymbolInfo, GraphicObjectType symbolType, int code, String symbolName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("createSymbol()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolLibraryNative.jni_CreateSymbol(this.getHandle(), InternalHandle.getHandle((InternalHandle)parentSymbolInfo), symbolType.value(), code, symbolName);
        if (0L == l) {
            return null;
        }
        return new SymbolInfo(l);
    }

    public ArrayList<GeoGraphicObject> getSymbolCells(int code, boolean isShowSurroundLine) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolCells()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<GeoGraphicObject> arrayList = new ArrayList<GeoGraphicObject>();
        int n = SymbolLibraryNative.jni_GetSymbolCellsCount(this.getHandle(), code, isShowSurroundLine);
        if (0 == n) {
            return arrayList;
        }
        long[] lArray = new long[n];
        SymbolLibraryNative.jni_GetSymbolCells(this.getHandle(), code, lArray, isShowSurroundLine);
        for (int i = 0; i < lArray.length; ++i) {
            GeoGraphicObject geoGraphicObject = new GeoGraphicObject();
            InternalHandle.setHandle((InternalHandle)geoGraphicObject, (long)lArray[i]);
        }
        return arrayList;
    }

    public boolean deleteSymbolInfo(SymbolInfo symbolInfo, SymbolInfo parentSymbolInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteSymbolInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_DeleteSymbolInfo(this.getHandle(), InternalHandle.getHandle((InternalHandle)symbolInfo), InternalHandle.getHandle((InternalHandle)parentSymbolInfo));
    }

    public boolean generationSurroundLine(Recordset rec) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("generationSurroundLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rec) {
            return false;
        }
        ArrayList<GeoGraphicObject> arrayList = new ArrayList<GeoGraphicObject>();
        boolean bl = rec.moveFirst();
        while (bl) {
            Geometry geometry = rec.getGeometry();
            if (null != geometry && geometry.getType() == GeometryType.GRAPHICOBJECT) {
                arrayList.add((GeoGraphicObject)geometry);
            }
            bl = rec.moveNext();
        }
        int n = arrayList.size();
        if (n == arrayList.size()) {
            return false;
        }
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        boolean bl2 = SymbolLibraryNative.jni_GenerationSurroundLine(this.getHandle(), lArray, lArray2);
        if (bl2) {
            for (int i = 0; i < lArray2.length; ++i) {
                GeoGraphicObject geoGraphicObject = new GeoGraphicObject();
                InternalHandle.setHandle((InternalHandle)geoGraphicObject, (long)lArray2[i]);
                rec.addNew((Geometry)geoGraphicObject);
                rec.update();
            }
        }
        return bl2;
    }

    public Point3D getDefaultRotate3D(int code) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultRotate3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        SymbolLibraryNative.jni_GetDefaultRotate3D(this.getHandle(), code, dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public boolean mergeTo(String symbolPath, boolean isCover) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mergeTo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_MergeTo(this.getHandle(), symbolPath, isCover);
    }

    public void showSymbol(Recordset rec, int code, boolean isShowSurroundLine) {
        if (null == rec) {
            return;
        }
        ArrayList<GeoGraphicObject> arrayList = this.getSymbolCells(code, isShowSurroundLine);
        if (null == arrayList) {
            return;
        }
        rec.edit();
        for (int i = 0; i < arrayList.size(); ++i) {
            rec.addNew((Geometry)arrayList.get(i));
            rec.update();
        }
    }
}

