/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.data.DotShowMode;
import com.supermap.data.Size2D;
import com.supermap.data.SurroundLineType;
import com.supermap.data.TextStyle;
import com.supermap.plot.InternalTextStyle;
import com.supermap.plot.SymbolDefaultStyleNative;
import java.awt.Color;

public class SymbolDefaultStyle {
    private static SymbolDefaultStyle instance = null;

    public static SymbolDefaultStyle getInstance() {
        if (null == instance) {
            instance = new SymbolDefaultStyle();
        }
        return instance;
    }

    private SymbolDefaultStyle() {
    }

    public TextStyle getTextStyle2D() {
        long l = SymbolDefaultStyleNative.jni_GetTextStyle2D();
        if (l == 0L) {
            return null;
        }
        TextStyle textStyle = InternalTextStyle.createInstance(l);
        return textStyle;
    }

    public TextStyle getTextStyle3D() {
        long l = SymbolDefaultStyleNative.jni_GetTextStyle3D();
        if (l == 0L) {
            return null;
        }
        TextStyle textStyle = InternalTextStyle.createInstance(l);
        return textStyle;
    }

    public double getDefaultLineWidth() {
        return SymbolDefaultStyleNative.jni_GetDefaultLineWidth();
    }

    public void setDefaultLineWidth(double dWidth) {
        SymbolDefaultStyleNative.jni_SetDefaultLineWidth(dWidth);
    }

    public double getDefaultGridLineWidth() {
        return SymbolDefaultStyleNative.jni_GetDefaultGridLineWidth();
    }

    public void setDefaultGridLineWidth(double dWidth) {
        SymbolDefaultStyleNative.jni_SetDefaultGridLineWidth(dWidth);
    }

    public Size2D getDefaultSymbolSize() {
        double[] dArray = new double[2];
        SymbolDefaultStyleNative.jni_GetDefaultSymbolSize(dArray);
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setDefaultSymbolSize(Size2D size) {
        SymbolDefaultStyleNative.jni_SetDefaultSymbolSize(size.width, size.height);
    }

    public Size2D getDefaultGridSymbolSize() {
        double[] dArray = new double[2];
        SymbolDefaultStyleNative.jni_GetDefaultGridSymbolSize(dArray);
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setDefaultGridSymbolSize(Size2D size) {
        SymbolDefaultStyleNative.jni_SetDefaultGridSymbolSize(size.width, size.height);
    }

    public Color getDefaultLineColor() {
        return new Color(SymbolDefaultStyleNative.jni_GetDefaultLineColor());
    }

    public void setDefaultLineColor(Color color) {
        SymbolDefaultStyleNative.jni_SetDefaultLineColor(color.getRGB());
    }

    public DotShowMode getDefaultShowMode() {
        int n = SymbolDefaultStyleNative.jni_GetDefaultShowMode();
        DotShowMode dotShowMode = new DotShowMode(n, n);
        return dotShowMode;
    }

    public void setDefaultShowMode(DotShowMode mode) {
        SymbolDefaultStyleNative.jni_SetDefaultShowMode(mode.value());
    }

    public SurroundLineType getDefaultSurroundLineType() {
        int n = SymbolDefaultStyleNative.jni_GetDefaultSurroundLineType();
        SurroundLineType surroundLineType = new SurroundLineType(n, n);
        return surroundLineType;
    }

    public void setDefaultSurroundLineType(SurroundLineType type) {
        SymbolDefaultStyleNative.jni_SetDefaultSurroundLineType(type.value());
    }

    public boolean isUseDefaultStyle() {
        return SymbolDefaultStyleNative.jni_IsUseDefaultStyle();
    }

    public void setUseDefaultStyle(boolean bUse) {
        SymbolDefaultStyleNative.jni_SetUseDefaultStyle(bUse);
    }

    public void resetDefaultStyle() {
        SymbolDefaultStyleNative.jni_ResetDefaultStyle();
    }

    public void setDefaultSymbolSizeD(double dValue) {
        SymbolDefaultStyleNative.jni_SetDefaultSymbolSizeD(dValue);
    }

    public double getDefaultSymbolSizeD() {
        return SymbolDefaultStyleNative.jni_GetDefaultSymbolSizeD();
    }

    public void setDefaultGridSymbolSizeD(double dValue) {
        SymbolDefaultStyleNative.jni_SetDefaultGridSymbolSizeD(dValue);
    }

    public double getDefaultGridSymbolSizeD() {
        return SymbolDefaultStyleNative.jni_GetDefaultGridSymbolSizeD();
    }

    public double getDefaultLineWidth3D() {
        return SymbolDefaultStyleNative.jni_GetDefaultLineWidth3D();
    }

    public void setDefaultLineWidth3D(double dValue) {
        SymbolDefaultStyleNative.jni_SetDefaultLineWidth3D(dValue);
    }

    public double getDefaultGridSurroundLineWidth() {
        return SymbolDefaultStyleNative.jni_GetDefaultGridSurroundLineWidth();
    }

    public void setDefaultGridSurroundLineWidth(double dValue) {
        SymbolDefaultStyleNative.jni_SetDefaultGridSurroundLineWidth(dValue);
    }

    public double getDefaultSurroundLineWidth() {
        return SymbolDefaultStyleNative.jni_GetDefaultSurroundLineWidth();
    }

    public void setDefaultSurroundLineWidth(double dValue) {
        SymbolDefaultStyleNative.jni_SetDefaultSurroundLineWidth(dValue);
    }

    public double getDefaultSurroundLineWidth3D() {
        return SymbolDefaultStyleNative.jni_GetDefaultSurroundLineWidth3D();
    }

    public void setDefaultSurroundLineWidth3D(double dValue) {
        SymbolDefaultStyleNative.jni_SetDefaultSurroundLineWidth3D(dValue);
    }

    public Color getDefaultSurroundLineColor() {
        return new Color(SymbolDefaultStyleNative.jni_GetDefaultSurroundLineColor());
    }

    public void setDefaultSurroundLineColor(Color color) {
        SymbolDefaultStyleNative.jni_SetDefaultSurroundLineColor(color.getRGB());
    }
}

