/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import com.supermap.data.TransformationError;
import com.supermap.data.TransformationMode;
import com.supermap.data.TransformationNative;
import com.supermap.data.TransformationResampleMode;
import java.util.concurrent.CopyOnWriteArrayList;

public class Transformation
extends InternalHandleDisposable {
    private Point2Ds m_originalControlPoints = null;
    private Point2Ds m_targetControlPoints = null;
    private TransformationMode m_TransformMode = TransformationMode.RECT;
    transient CopyOnWriteArrayList<SteppedListener> m_steppedListeners;
    protected long m_selfEventHandle;

    public Transformation() {
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this.m_originalControlPoints = new Point2Ds();
        this.m_targetControlPoints = new Point2Ds();
    }

    public Transformation(Transformation transformation) {
        if (transformation == null) {
            String string = InternalResource.loadString("transformation", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformation.getHandle() == 0L) {
            String string = InternalResource.loadString("transformation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this.m_originalControlPoints = new Point2Ds();
        this.m_targetControlPoints = new Point2Ds();
        InternalHandleDisposable.makeSureNativeObjectLive(transformation);
    }

    public Transformation(Point2Ds originalControlPoints, Point2Ds targetControlPoints, TransformationMode transformMode) {
        if (originalControlPoints == null) {
            String string = InternalResource.loadString("originalControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetControlPoints == null) {
            String string = InternalResource.loadString("targetControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformMode == null) {
            String string = InternalResource.loadString("transformationMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this.m_originalControlPoints = new Point2Ds();
        this.m_targetControlPoints = new Point2Ds();
        this.setOriginalControlPoints(originalControlPoints);
        this.setTargetControlPoints(targetControlPoints);
        this.m_TransformMode = transformMode;
    }

    public Point2Ds getOriginalControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOriginalControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_originalControlPoints;
    }

    public boolean rectify(Dataset rectifyDataset) {
        if (rectifyDataset == null || InternalHandle.getHandle(rectifyDataset) == 0L) {
            String string = InternalResource.loadString("rectifyDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectifyDataset.getType() != DatasetType.GRID && rectifyDataset.getType() != DatasetType.IMAGE) {
            String string = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        boolean bl = TransformationNative.jni_RectifyDirect(this.getHandle(), rectifyDataset.getHandle(), this.m_TransformMode.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        if (!bl) {
            String[] stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
        }
        return bl;
    }

    public Dataset rectify(Dataset rectifyDataset, Datasource outputDatasource, String outputDatasetName, TransformationResampleMode resampleMode, double cellSize) {
        if (rectifyDataset == null || InternalHandle.getHandle(rectifyDataset) == 0L) {
            String string = InternalResource.loadString("rectifyDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectifyDataset.getType() != DatasetType.GRID && rectifyDataset.getType() != DatasetType.IMAGE) {
            String string = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle(outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        long l = 0L;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        l = TransformationNative.jni_RectifyResample(this.getHandle(), rectifyDataset.getHandle(), resampleMode.value(), cellSize, outputDatasource.getHandle(), outputDatasetName, this.m_TransformMode.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        Dataset dataset = null;
        if (l != 0L) {
            dataset = Dataset.createInstance(l, rectifyDataset.getType(), outputDatasource);
            Datasets.add(outputDatasource.getDatasets(), dataset);
        }
        if (dataset == null) {
            String[] stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
        }
        return dataset;
    }

    public Dataset rectify(Dataset rectifyDataset, Datasource outputDatasource, String outputDatasetName) {
        if (rectifyDataset == null || InternalHandle.getHandle(rectifyDataset) == 0L) {
            String string = InternalResource.loadString("rectifyDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectifyDataset.getType() != DatasetType.GRID && rectifyDataset.getType() != DatasetType.IMAGE) {
            String string = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle(outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        long l = 0L;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        l = TransformationNative.jni_Rectify(this.getHandle(), rectifyDataset.getHandle(), outputDatasource.getHandle(), outputDatasetName, this.m_TransformMode.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        Dataset dataset = null;
        if (l != 0L) {
            dataset = Dataset.createInstance(l, rectifyDataset.getType(), outputDatasource);
            Datasets.add(outputDatasource.getDatasets(), dataset);
        }
        if (dataset == null) {
            String[] stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
        }
        return dataset;
    }

    public boolean rectify(Dataset[] rectifyDatasets) {
        if (rectifyDatasets == null) {
            String string = InternalResource.loadString("rectifyDatasets", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        boolean bl = true;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        for (int i = 0; i < rectifyDatasets.length; ++i) {
            String[] stringArray;
            if (rectifyDatasets[i] == null || InternalHandle.getHandle(rectifyDatasets[i]) == 0L) {
                stringArray = InternalResource.loadString("rectifyDatasets", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException((String)stringArray);
            }
            if (rectifyDatasets[i].getType() != DatasetType.GRID && rectifyDatasets[i].getType() != DatasetType.IMAGE) {
                stringArray = InternalResource.loadString("rectifyDatasets", "RecordsetDatasetTypeIsNotSupported", "data_resources");
                throw new IllegalArgumentException((String)stringArray);
            }
            if (TransformationNative.jni_RectifyDirect(this.getHandle(), rectifyDatasets[i].getHandle(), this.m_TransformMode.value(), this.m_selfEventHandle)) continue;
            stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
            bl = false;
        }
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean transform(DatasetVector transformDataset) {
        if (transformDataset == null || InternalHandle.getHandle(transformDataset) == 0L) {
            String string = InternalResource.loadString("transformDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformDataset.getType() != DatasetType.CAD && transformDataset.getType() != DatasetType.POINT && transformDataset.getType() != DatasetType.LINE && transformDataset.getType() != DatasetType.REGION && transformDataset.getType() != DatasetType.NETWORK && transformDataset.getType() != DatasetType.TEXT && transformDataset.getType() != DatasetType.POINT3D && transformDataset.getType() != DatasetType.LINE3D && transformDataset.getType() != DatasetType.REGION3D && transformDataset.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("transformDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        boolean bl = TransformationNative.jni_TransformDirect(this.getHandle(), transformDataset.getHandle(), this.m_TransformMode.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        if (!bl) {
            String[] stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
        }
        return bl;
    }

    public DatasetVector transform(DatasetVector transformDataset, Datasource outputDatasource, String outputDatasetName) {
        if (transformDataset == null || InternalHandle.getHandle(transformDataset) == 0L) {
            String string = InternalResource.loadString("transformDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformDataset.getType() != DatasetType.CAD && transformDataset.getType() != DatasetType.POINT && transformDataset.getType() != DatasetType.LINE && transformDataset.getType() != DatasetType.REGION && transformDataset.getType() != DatasetType.NETWORK && transformDataset.getType() != DatasetType.TEXT && transformDataset.getType() != DatasetType.POINT3D && transformDataset.getType() != DatasetType.LINE3D && transformDataset.getType() != DatasetType.REGION3D && transformDataset.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle(outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        long l = 0L;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        l = TransformationNative.jni_Transform(this.getHandle(), transformDataset.getHandle(), outputDatasource.getHandle(), outputDatasetName, this.m_TransformMode.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        DatasetVector datasetVector = null;
        if (l != 0L) {
            datasetVector = DatasetVector.createInstance(l, outputDatasource);
            Datasets.add(outputDatasource.getDatasets(), datasetVector);
        }
        if (datasetVector == null) {
            String[] stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
        }
        return datasetVector;
    }

    public boolean transform(DatasetVector[] transformDatasets) {
        if (transformDatasets == null) {
            String string = InternalResource.loadString("transformDatasets", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        for (int i = 0; i < transformDatasets.length; ++i) {
            Object object;
            if (transformDatasets[i] == null || InternalHandle.getHandle(transformDatasets[i]) == 0L) {
                object = InternalResource.loadString("transformDatasets", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException((String)object);
            }
            if (transformDatasets[i].getType() != DatasetType.CAD && transformDatasets[i].getType() != DatasetType.POINT && transformDatasets[i].getType() != DatasetType.LINE && transformDatasets[i].getType() != DatasetType.REGION && transformDatasets[i].getType() != DatasetType.NETWORK && transformDatasets[i].getType() != DatasetType.TEXT && transformDatasets[i].getType() != DatasetType.POINT3D && transformDatasets[i].getType() != DatasetType.LINE3D && transformDatasets[i].getType() != DatasetType.REGION3D && transformDatasets[i].getType() != DatasetType.NETWORK3D) {
                object = InternalResource.loadString("transformDatasets", "RecordsetDatasetTypeIsNotSupported", "data_resources");
                throw new IllegalArgumentException((String)object);
            }
            this.checkControlPoints();
            if (TransformationNative.jni_TransformDirect(this.getHandle(), transformDatasets[i].getHandle(), this.m_TransformMode.value(), this.m_selfEventHandle)) continue;
            object = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), object);
            if (object[0].isEmpty()) {
                throw new IllegalArgumentException(object[0]);
            }
            bl = false;
        }
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean transform(Geometry transformGeometry) {
        if (transformGeometry == null || InternalHandle.getHandle(transformGeometry) == 0L) {
            String string = InternalResource.loadString("transformGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        boolean bl = TransformationNative.jni_TransformGeometry(this.getHandle(), transformGeometry.getHandle(), this.m_TransformMode.value());
        if (!bl) {
            String[] stringArray = new String[1];
            TransformationNative.jni_GetLastErrorMsg(this.getHandle(), stringArray);
            if (stringArray[0].isEmpty()) {
                throw new IllegalArgumentException(stringArray[0]);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(transformGeometry);
        return bl;
    }

    public boolean transform(Point2Ds transformPoint2Ds) {
        int n;
        if (transformPoint2Ds == null) {
            String string = InternalResource.loadString("transformPoint2Ds", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkControlPoints();
        int n2 = transformPoint2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = transformPoint2Ds.getItem(n).getX();
            dArray2[n] = transformPoint2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_TransformPoint2Ds(this.getHandle(), dArray, dArray2, this.m_TransformMode.value()) ? 1 : 0;
        if (n != 0) {
            transformPoint2Ds.clear();
            for (int i = 0; i < n2; ++i) {
                Point2D point2D = new Point2D(dArray[i], dArray2[i]);
                transformPoint2Ds.add(point2D);
            }
        }
        return n != 0;
    }

    public boolean setOriginalControlPoints(Point2Ds points) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOriginalControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = points.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
        }
        n = TransformationNative.jni_SetOriginalControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            this.m_originalControlPoints.clear();
            this.m_originalControlPoints.addRange(points.toArray());
        }
        return n != 0;
    }

    public Point2Ds getTargetControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_targetControlPoints;
    }

    public boolean setTargetControlPoints(Point2Ds points) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = points.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = points.getItem(n).getX();
            dArray2[n] = points.getItem(n).getY();
        }
        n = TransformationNative.jni_SetTargetControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            this.m_targetControlPoints.clear();
            this.m_targetControlPoints.addRange(points.toArray());
        }
        return n != 0;
    }

    public TransformationMode getTransformMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_TransformMode;
    }

    public void setTransformMode(TransformationMode transformMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (transformMode == null) {
            String string = InternalResource.loadString("transformMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_TransformMode = transformMode;
    }

    public TransformationError getError() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getError()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = TransformationNative.jni_GetError(this.getHandle(), this.m_TransformMode.value());
        if (l != 0L) {
            return new TransformationError(l);
        }
        return null;
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        if (this.m_originalControlPoints != null) {
            this.m_originalControlPoints.clear();
            this.m_originalControlPoints = null;
        }
        if (this.m_targetControlPoints != null) {
            this.m_targetControlPoints.clear();
            this.m_targetControlPoints = null;
        }
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TransformationNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean fromSFCFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromSFCFile(String fileName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null) {
            String string = InternalResource.loadString("fileName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = new int[1];
        if (fileName.trim().length() != 0 && (bl = TransformationNative.jni_FromSFCFile(this.getHandle(), fileName, nArray))) {
            int n;
            double[] dArray = new double[nArray[0]];
            double[] dArray2 = new double[nArray[0]];
            if (TransformationNative.jni_GetOriginalControlPoints(this.getHandle(), dArray, dArray2)) {
                this.m_originalControlPoints.clear();
                for (n = 0; n < nArray[0]; ++n) {
                    this.m_originalControlPoints.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
            if (TransformationNative.jni_GetTargetControlPoints(this.getHandle(), dArray, dArray2)) {
                this.m_targetControlPoints.clear();
                for (n = 0; n < nArray[0]; ++n) {
                    this.m_targetControlPoints.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
        }
        return bl;
    }

    public boolean toSFCFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toSFCFile(String fileName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null) {
            String string = InternalResource.loadString("fileName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return TransformationNative.jni_ToSFCFile(this.getHandle(), fileName);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (xml == null) {
            String string = InternalResource.loadString("xml", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = new int[2];
        if (xml.trim().length() != 0 && (bl = TransformationNative.jni_FromXML(this.getHandle(), xml, nArray))) {
            int n;
            this.m_TransformMode = (TransformationMode)Enum.parseUGCValue(TransformationMode.class, nArray[0]);
            double[] dArray = new double[nArray[1]];
            double[] dArray2 = new double[nArray[1]];
            if (TransformationNative.jni_GetOriginalControlPoints(this.getHandle(), dArray, dArray2)) {
                this.m_originalControlPoints.clear();
                for (n = 0; n < nArray[1]; ++n) {
                    this.m_originalControlPoints.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
            if (TransformationNative.jni_GetTargetControlPoints(this.getHandle(), dArray, dArray2)) {
                this.m_targetControlPoints.clear();
                for (n = 0; n < nArray[1]; ++n) {
                    this.m_targetControlPoints.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TransformationNative.jni_ToXML(this.getHandle(), this.m_TransformMode.value());
    }

    public String getTransformEquation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransformEquation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TransformationNative.jni_GetTransformEquation(this.getHandle());
    }

    private void checkControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Transformmation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_originalControlPoints == null || this.m_targetControlPoints == null) {
            String string = InternalResource.loadString("ControlPoints", "Transformation_ControlPointsNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_originalControlPoints.getCount();
        int n2 = this.m_targetControlPoints.getCount();
        if (n == 0 || n2 == 0) {
            String string = InternalResource.loadString("Transformmation", "Transformation_ControlPointsShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n != n2) {
            String string = InternalResource.loadString("Transformmation", "Transformation_OriginalAndTargetControlPointsCountMustEqual", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_TransformMode == TransformationMode.RECT && n < 2) {
            String string = InternalResource.loadString("Transformmation", "Transformation_RectModeNeedLeastTwoControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_TransformMode == TransformationMode.LINEAR && n < 4) {
            String string = InternalResource.loadString("Transformmation", "Transformation_LinearModeNeedLeastFourControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_TransformMode == TransformationMode.SQUARE && n < 7) {
            String string = InternalResource.loadString("Transformmation", "Transformation_SquareModeNeedLeastSevenControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.m_steppedListeners;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(event);
            }
        }
    }

    static void steppedCallBack(Transformation source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            String string = "Transformation";
            boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent(source, percent, remainTime, title, message, string, bl);
            source.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            TransformationNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }
}

