/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetTopologyNative;
import com.supermap.data.InternalResource;
import com.supermap.data.TopologyDatasetRelationItem;
import java.util.ArrayList;

public class TopologyDatasetRelationItems {
    private DatasetTopology m_datasetTopology;
    private ArrayList<TopologyDatasetRelationItem> m_topologyRelationItems;

    TopologyDatasetRelationItems(DatasetTopology datasetTopology) {
        this.m_datasetTopology = datasetTopology;
        this.m_topologyRelationItems = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            TopologyDatasetRelationItem topologyDatasetRelationItem = new TopologyDatasetRelationItem(this.m_datasetTopology, i);
            this.m_topologyRelationItems.add(topologyDatasetRelationItem);
        }
    }

    public int getCount() {
        if (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetTopologyNative.jni_GetRelationItemsCount(this.m_datasetTopology.getHandle());
    }

    public TopologyDatasetRelationItem get(int index) {
        if (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_topologyRelationItems.get(index);
    }

    public int add(TopologyDatasetRelationItem item) {
        if (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!item.getDataset().getDatasource().equals(this.m_datasetTopology.getDatasource())) {
            String string = InternalResource.loadString("item", "TopologyDatasetRelationItem_DatasetMustBeInTopologyDatasetDatasource", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        String string = item.getDataset().getName();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.m_topologyRelationItems.get(i).getDataset().getName())) continue;
            String string2 = InternalResource.loadString("item", "TopologyDatasetRelationItem_DatasetMustBeInTopologyDatasetDatasource", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = item.getDataset().getHandle();
        int n2 = -1;
        boolean bl = DatasetTopologyNative.jni_AddRelationItem(this.m_datasetTopology.getHandle(), l, item.getPrecisionOrder());
        if (bl) {
            this.m_topologyRelationItems.add(new TopologyDatasetRelationItem(this.m_datasetTopology, this.getCount() - 1));
            n2 = this.m_topologyRelationItems.size() - 1;
        }
        return n2;
    }

    public boolean remove(int index) {
        if (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = DatasetTopologyNative.jni_RemoveRelationItem(this.m_datasetTopology.getHandle(), index);
        if (bl) {
            this.m_topologyRelationItems.remove(index);
        }
        return bl;
    }

    public void clear() {
        if (this.m_datasetTopology == null || this.m_datasetTopology.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasetTopology", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetTopologyNative.jni_ClearRelationItem(this.m_datasetTopology.getHandle());
        this.m_topologyRelationItems.clear();
    }

    protected void clearHandle() {
        if (this.m_datasetTopology != null) {
            this.m_datasetTopology.clearHandle();
            this.m_datasetTopology = null;
        }
    }

    boolean contain(String name) {
        int n = this.m_topologyRelationItems.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!this.m_topologyRelationItems.get(i).getDataset().getName().equalsIgnoreCase(name)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

