/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolMarker3D;
import com.supermap.data.SymbolNative;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public abstract class Symbol
extends InternalHandleDisposable {
    protected SymbolLibrary m_lib;
    private SymbolGroup m_group;

    protected Symbol() {
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (name != null) {
            string = name;
        }
        SymbolNative.jni_setName(this.getHandle(), string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolNative.jni_getName(this.getHandle());
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolNative.jni_getID(this.getHandle());
    }

    public SymbolLibrary getLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_lib;
    }

    public abstract SymbolType getType();

    public abstract boolean draw(Graphics var1, Geometry var2);

    public abstract boolean draw(BufferedImage var1, Geometry var2);

    public abstract boolean draw(Graphics var1, Point2Ds var2, GeoStyle var3);

    public abstract boolean draw(BufferedImage var1, Point2Ds var2, GeoStyle var3);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(",ID=");
        stringBuffer.append(this.getID());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static final Symbol createInstance(Symbol symbol) {
        long l = SymbolNative.createInstance(symbol.getHandle());
        Symbol symbol2 = Symbol.createInstance(l);
        InternalHandleDisposable.makeSureNativeObjectLive(symbol);
        return symbol2;
    }

    static final Symbol createInstance(long symbolHandle) {
        if (symbolHandle == 0L) {
            return null;
        }
        int n = SymbolNative.jni_GetType(symbolHandle);
        Symbol symbol = null;
        if (n == 0 || n == 7) {
            boolean bl = SymbolNative.jni_Is3D(symbolHandle);
            symbol = bl ? new SymbolMarker3D(symbolHandle) : new SymbolMarker(symbolHandle);
        } else if (n == 1 || n == 4 || n == 6) {
            symbol = new SymbolLine(symbolHandle);
        } else if (n == 2 || n == 5) {
            symbol = new SymbolFill(symbolHandle);
        }
        if (symbol != null) {
            symbol.setIsDisposable(true);
        }
        return symbol;
    }

    void setLibrary(SymbolLibrary lib) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_lib = lib;
    }

    protected void setGroup(SymbolGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_group = group;
    }

    protected SymbolGroup getGroup() {
        return this.m_group;
    }
}

