/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material3DNative;
import com.supermap.data.MaterialType;
import com.supermap.data.ModelEntityManager;
import com.supermap.data.Point3D;
import com.supermap.data.TextureData;
import com.supermap.data.TextureWrapMode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class Material3D
extends InternalHandleDisposable {
    ArrayList<TextureData> m_arrTexture;

    protected Material3D(long handle) {
        this.setHandle(handle, false);
        this.m_arrTexture = null;
    }

    protected Material3D(long srcHandle, long modelHandle) {
        long l = Material3DNative.jni_New2(srcHandle);
        this.setHandle(l, true);
        this.m_arrTexture = null;
        long[] lArray = Material3DNative.jni_GetTextureData(srcHandle, modelHandle);
        if (lArray != null && lArray.length > 0) {
            this.m_arrTexture = new ArrayList();
            for (int i = 0; i < lArray.length; ++i) {
                this.m_arrTexture.add(new TextureData(lArray[i]));
            }
        }
    }

    protected Material3D(long pMaterial, ModelEntityManager pEM) {
        long l = Material3DNative.jni_New2(pMaterial);
        this.setHandle(l, true);
        this.m_arrTexture = null;
        long[] lArray = Material3DNative.jni_GetTextureData2(pMaterial, pEM.getHandle());
        if (lArray != null && lArray.length > 0) {
            this.m_arrTexture = new ArrayList();
            for (int i = 0; i < lArray.length; ++i) {
                this.m_arrTexture.add(new TextureData(lArray[i]));
            }
        }
    }

    void ClearHandle() {
        this.dispose();
        this.ClearTextureHandle();
    }

    void ClearTextureHandle() {
        if (this.m_arrTexture == null) {
            return;
        }
        for (int i = 0; i < this.m_arrTexture.size(); ++i) {
            this.m_arrTexture.get(i).dispose();
        }
        this.m_arrTexture.clear();
        this.m_arrTexture = null;
    }

    public Material3D() {
        long l = Material3DNative.jni_New();
        this.setHandle(l, true);
        this.m_arrTexture = null;
    }

    public Material3D(Material3D materialSrc) {
        ArrayList<TextureData> arrayList;
        if (materialSrc == null) {
            String string = InternalResource.loadString("materialSrc", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = materialSrc.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("materialSrc", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = Material3DNative.jni_New2(l);
        this.setHandle(l2, true);
        this.disposeTextureDatas();
        if (materialSrc.m_arrTexture != null && (arrayList = materialSrc.m_arrTexture).size() > 0) {
            this.m_arrTexture = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                TextureData textureData = new TextureData(arrayList.get(i).getHandle());
                this.m_arrTexture.add(textureData);
            }
        }
    }

    private void disposeTextureDatas() {
        if (this.m_arrTexture != null) {
            for (int i = 0; i < this.m_arrTexture.size(); ++i) {
                this.m_arrTexture.get(i).dispose();
            }
            this.m_arrTexture.clear();
            this.m_arrTexture = null;
        }
    }

    public Material3D(String name) {
        long l = Material3DNative.jni_New();
        Material3DNative.jni_setName(l, name);
        this.setHandle(l, true);
        this.m_arrTexture = null;
    }

    @Override
    public void dispose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Material3DNative.jni_Delete(this.getHandle());
        this.clearHandle();
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_setName(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return Material3DNative.jni_GetName(this.getHandle());
    }

    public ArrayList<TextureData> getTextures() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TextureData> arrayList = new ArrayList<TextureData>();
        if (this.m_arrTexture != null) {
            for (int i = 0; i < this.m_arrTexture.size(); ++i) {
                arrayList.add(new TextureData(this.m_arrTexture.get(i).getHandle()));
            }
        }
        return arrayList;
    }

    public void setTextures(ArrayList<TextureData> value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.ClearTextureHandle();
        String[] stringArray = null;
        if (value.size() > 0) {
            stringArray = new String[value.size()];
            this.m_arrTexture = new ArrayList();
            for (int i = 0; i < value.size(); ++i) {
                TextureData textureData = new TextureData(value.get(i).getHandle());
                this.m_arrTexture.add(i, textureData);
                stringArray[i] = textureData.getName();
            }
        }
        Material3DNative.jni_SetTextureName(this.getHandle(), stringArray);
    }

    public TextureData getTexture() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextureData textureData = null;
        if (this.m_arrTexture != null && this.m_arrTexture.size() > 0) {
            textureData = new TextureData(this.m_arrTexture.get(0).getHandle());
        }
        return textureData;
    }

    public void setTexture(TextureData value) throws IOException {
        if (value == null || value.getHandle() == 0L || value.getData() == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = value.getData();
        if (bufferedImage.getWidth() == 0 || bufferedImage.getHeight() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.ClearTextureHandle();
        String[] stringArray = null;
        stringArray = new String[1];
        this.m_arrTexture = new ArrayList();
        TextureData textureData = new TextureData(value.getHandle());
        this.m_arrTexture.add(textureData);
        stringArray[0] = textureData.getName();
        Material3DNative.jni_SetTextureName(this.getHandle(), stringArray);
    }

    public void setMaterialColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetMaterialColor(this.getHandle(), value.getAlpha(), value.getRed(), value.getGreen(), value.getBlue());
    }

    public Color getMaterialColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = Material3DNative.jni_GetMaterialColor(this.getHandle());
        Color color = new Color(nArray[1], nArray[2], nArray[3], nArray[0]);
        nArray = null;
        return color;
    }

    public boolean check() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        if (this.m_arrTexture != null) {
            lArray = new long[this.m_arrTexture.size()];
            for (n = 0; n < this.m_arrTexture.size(); ++n) {
                lArray[n] = this.m_arrTexture.get(n).getHandle();
            }
        }
        n = Material3DNative.jni_Check(this.getHandle(), lArray);
        lArray = null;
        return n != 0;
    }

    public void setPosition(int iTexture, Point3D pnt) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetPosition(this.getHandle(), iTexture, pnt.getX(), pnt.getY(), pnt.getZ());
    }

    public void setRotate(int iTexture, double dbX, double dbY, double dbZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetRotate(this.getHandle(), iTexture, dbX, dbY, dbZ);
    }

    public void setScale(int iTexture, double dbX, double dbY, double dbZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetScale(this.getHandle(), iTexture, dbX, dbY, dbZ);
    }

    public void setTextureWrapMode(int iTexture, TextureWrapMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetTextureWrapMode(this.getHandle(), iTexture, mode.value());
    }

    public TextureWrapMode getTextureWrapMode(int iTexture) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = Material3DNative.jni_GetTextureWrapMode(this.getHandle(), iTexture);
        return (TextureWrapMode)Enum.parseUGCValue(TextureWrapMode.class, n);
    }

    public void removeTextures() {
        this.ClearTextureHandle();
        Material3DNative.jni_SetTextureName(this.getHandle(), null);
    }

    public MaterialType getMaterialType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaterialType", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = Material3DNative.jni_GetMaterialType(this.getHandle());
        switch (n) {
            case 3: {
                return MaterialType.COMMON;
            }
        }
        return MaterialType.PBR;
    }
}

