/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoTextEPSNative;
import com.supermap.data.GeometryEPS;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PointEPS;
import com.supermap.data.TextStyle;

public class GeoTextEPS
extends GeometryEPS {
    private TextStyle m_textStyle = null;

    public GeoTextEPS() {
        long l = GeoTextEPSNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoTextEPS(GeoTextEPS geoText) {
        if (geoText == null) {
            String string = InternalResource.loadString("geoText", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoText.getHandle() == 0L) {
            String string = InternalResource.loadString("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextEPSNative.jni_Clone(geoText.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoText);
    }

    public GeoTextEPS(PointEPS point, String text) {
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (text == null) {
            String string = InternalResource.loadString("text", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextEPSNative.jni_New();
        this.setHandle(l, true);
        this.add(point);
        this.setText(text);
    }

    GeoTextEPS(long handle) {
        this.setHandle(handle, false);
    }

    protected static GeoTextEPS creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoTextEPS(handle);
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextEPSNative.jni_GetText(this.getHandle());
    }

    public void setText(String text) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTextEPSNative.jni_SetText(this.getHandle(), text);
    }

    public TextStyle getTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_textStyle == null && (l = GeoTextEPSNative.jni_GetTextStyle(this.getHandle())) != 0L) {
            this.m_textStyle = TextStyle.createInstance(l);
        }
        return this.m_textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        GeoTextEPSNative.jni_SetTextStyle(this.getHandle(), textStyle2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle2);
    }

    @Override
    public GeoTextEPS clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoTextEPS(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTextEPSNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.m_textStyle != null) {
            this.m_textStyle.clearHandle();
            this.m_textStyle = null;
        }
    }
}

