/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.EditHistoryNative;
import com.supermap.data.EditType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Recordset;

public class EditHistory
extends InternalHandleDisposable {
    private boolean m_batchBegin = false;

    public EditHistory() {
        this.setHandle(EditHistoryNative.jni_New(), true);
    }

    EditHistory(long handle) {
        this.setHandle(handle, false);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCount(this.getHandle());
    }

    public void setCapacity(int maxCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCapacity(int maxCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (maxCount <= 0) {
            String string = InternalResource.loadString("maxCount", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new NullPointerException(string);
        }
        EditHistoryNative.jni_SetMaxCount(this.getHandle(), maxCount);
    }

    public int getCapacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCapacity()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetMaxCount(this.getHandle());
    }

    public int getCurrentIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentIndex()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCurrentIndex(this.getHandle());
    }

    public boolean getCanRedo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCanRedo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCanRedo(this.getHandle());
    }

    public boolean getCanUndo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCanUndo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCanUndo(this.getHandle());
    }

    public boolean add(EditType editType, Recordset recordset, boolean isCurrentOnly) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(EditType editType, Recordset recordset, boolean isCurrentOnly)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (editType == null) {
            String string = InternalResource.loadString("editType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = recordset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = editType.getUGCValue();
        boolean bl = false;
        bl = !this.m_batchBegin ? EditHistoryNative.jni_Add(this.getHandle(), n, l, isCurrentOnly) : EditHistoryNative.jni_Add2(this.getHandle(), n, l, isCurrentOnly);
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean undo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_batchBegin) {
            String string = InternalResource.loadString("undo()", "BatchAddOperation_Unsupport_Undo", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_Undo(this.getHandle());
    }

    public boolean undo(int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("undo(int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_batchBegin) {
            String string = InternalResource.loadString("undo(int count)", "BatchAddOperation_Unsupport_Undo", "data_resources");
            throw new IllegalStateException(string);
        }
        if (count <= 0) {
            String string = InternalResource.loadString("count", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_UndoCount(this.getHandle(), count);
    }

    public boolean redo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("redo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_batchBegin) {
            String string = InternalResource.loadString("redo()", "BatchAddOperation_Unsupport_Redo", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_Redo(this.getHandle());
    }

    public boolean redo(int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("redo(int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_batchBegin) {
            String string = InternalResource.loadString("redo(int count)", "BatchAddOperation_Unsupport_Redo", "data_resources");
            throw new IllegalStateException(string);
        }
        if (count <= 0) {
            String string = InternalResource.loadString("count", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_RedoCount(this.getHandle(), count);
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount() - 1) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return EditHistoryNative.jni_Remove(this.getHandle(), index);
    }

    public boolean removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount() - 1 || count < 0 || index + count > this.getCount()) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (count == 0) {
            return true;
        }
        return EditHistoryNative.jni_RemoveRange(this.getHandle(), index, count);
    }

    public boolean clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_RemoveRange(this.getHandle(), 0, this.getCount());
    }

    public void batchBegin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("batchBegin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_batchBegin) {
            String string = InternalResource.loadString("batchBegin()", "BatchHasBegun", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_batchBegin = EditHistoryNative.jni_BatchBegin(this.getHandle());
    }

    public void batchEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("batchEnd()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        EditHistoryNative.jni_BatchEnd(this.getHandle());
        this.m_batchBegin = false;
    }

    public void batchCancel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("batchCancel()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        EditHistoryNative.jni_BatchCancel(this.getHandle());
        this.m_batchBegin = false;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            EditHistoryNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public void customEditModify(int[] ids, boolean isUndo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("customEditModify()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (ids == null || ids.length <= 0) {
            String string = InternalResource.loadString("ModifyIDs", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new NullPointerException(string);
        }
        EditHistoryNative.jni_CustomEditModify(this.getHandle(), ids, isUndo);
    }

    protected static EditHistory createInstance(long handle) {
        return new EditHistory(handle);
    }
}

