/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceAliasModifiedEvent;
import com.supermap.data.DatasourceAliasModifiedListener;
import com.supermap.data.DatasourceAliasModifyingEvent;
import com.supermap.data.DatasourceAliasModifyingListener;
import com.supermap.data.DatasourceClosedEvent;
import com.supermap.data.DatasourceClosedListener;
import com.supermap.data.DatasourceClosingEvent;
import com.supermap.data.DatasourceClosingListener;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.DatasourceCreatedEvent;
import com.supermap.data.DatasourceCreatedListener;
import com.supermap.data.DatasourceOpenedEvent;
import com.supermap.data.DatasourceOpenedListener;
import com.supermap.data.DatasourcesNative;
import com.supermap.data.EngineType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Toolkit;
import com.supermap.data.Workspace;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.RuntimeErrorException;

public class Datasources {
    private static final Error Error = null;
    private Workspace m_workspace;
    private ArrayList m_datasources;
    private transient Vector m_aliasModifiedListeners;
    private transient Vector m_closingListeners;
    private transient Vector m_closedListeners;
    private transient Vector m_openedListeners;
    private transient Vector m_createdListeners;
    private transient Vector m_aliasModifyingListeners;
    private static final Object m_lock = new Object();

    protected Datasources() {
    }

    Datasources(Workspace workspace) {
        this.m_datasources = new ArrayList();
        this.m_workspace = workspace;
    }

    public int getCount() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_datasources.size();
        return n;
    }

    public Datasource get(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return (Datasource)this.m_datasources.get(index);
    }

    public Datasource get(String alias) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Datasource datasource = null;
        int n = this.indexOf(alias);
        if (n != -1) {
            datasource = (Datasource)this.m_datasources.get(n);
        }
        return datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datasource open(DatasourceConnectionInfo connectionInfo) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null || connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = connectionInfo.getAlias();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("connectionInfo", "Datasources_AliasIsAlreadyExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        Object object = m_lock;
        synchronized (object) {
            String[] stringArray = new String[1];
            long l = DatasourcesNative.jni_Open(this.m_workspace.getHandle(), connectionInfo.getHandle(), stringArray);
            Datasource datasource = null;
            if (l == 0L) {
                throw new RuntimeErrorException(Error, Toolkit.getLastError());
            }
            datasource = new Datasource(l, this.m_workspace);
            this.m_datasources.add(datasource);
            DatasourceOpenedEvent datasourceOpenedEvent = new DatasourceOpenedEvent(this, datasource);
            this.fireOpened(datasourceOpenedEvent);
            InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
            return datasource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datasource create(DatasourceConnectionInfo connectionInfo) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null || connectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("create()", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = connectionInfo.getAlias();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("connectionInfo", "Datasources_AliasIsAlreadyExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        Object object = m_lock;
        synchronized (object) {
            if (connectionInfo.getEngineType() == EngineType.MEMORY) {
                connectionInfo.setServer(":memory:");
                connectionInfo.setEngineType(EngineType.UDB);
            }
            long l = DatasourcesNative.jni_Create(this.m_workspace.getHandle(), connectionInfo.getHandle());
            Datasource datasource = null;
            if (l != 0L) {
                datasource = new Datasource(l, this.m_workspace);
                this.m_datasources.add(datasource);
                DatasourceCreatedEvent datasourceCreatedEvent = new DatasourceCreatedEvent(this, datasource);
                this.fireCreated(datasourceCreatedEvent);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(connectionInfo);
            return datasource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            Datasource datasource = this.get(index);
            String string = datasource.getAlias();
            DatasourceClosingEvent datasourceClosingEvent = new DatasourceClosingEvent(this, datasource, false);
            this.fireClosing(datasourceClosingEvent);
            boolean bl = false;
            if (!datasourceClosingEvent.getCancel() && (bl = DatasourcesNative.jni_Close(this.m_workspace.getHandle(), index))) {
                datasource.clearHandle();
                this.m_datasources.remove(index);
                DatasourceClosedEvent datasourceClosedEvent = new DatasourceClosedEvent(this, datasource, string, index);
                this.fireClosed(datasourceClosedEvent);
            }
            return bl;
        }
    }

    public boolean close(String alias) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (alias == null || alias.trim().length() == 0) {
            String string = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int n = this.indexOf(alias);
        if (n != -1) {
            Datasource datasource = this.get(n);
            DatasourceClosingEvent datasourceClosingEvent = new DatasourceClosingEvent(this, datasource, false);
            this.fireClosing(datasourceClosingEvent);
            if (!datasourceClosingEvent.getCancel() && (bl = DatasourcesNative.jni_Close(this.m_workspace.getHandle(), n))) {
                datasource.clearHandle();
                this.m_datasources.remove(n);
                DatasourceClosedEvent datasourceClosedEvent = new DatasourceClosedEvent(this, datasource, alias, n);
                this.fireClosed(datasourceClosedEvent);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            int n = this.m_datasources.size();
            for (int i = n - 1; i >= 0; --i) {
                this.close(i);
            }
        }
    }

    public boolean contains(String alias) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.indexOf(alias);
        return n != -1;
    }

    public int indexOf(String alias) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (alias != null && alias.trim().length() != 0) {
            n = DatasourcesNative.jni_IndexOf(this.m_workspace.getHandle(), alias);
        }
        return n;
    }

    public boolean modifyAlias(String oldAlias, String newAlias) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldAlias == null || oldAlias.trim().length() == 0) {
            String string = InternalResource.loadString("oldAlias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newAlias == null || newAlias.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.contains(oldAlias)) {
            String string = InternalResource.loadString("oldAlias", "Datasources_AliasIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.contains(newAlias)) {
            String string = InternalResource.loadString("newAlias", "Datasources_AliasIsAlreadyExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource datasource = this.get(oldAlias);
        DatasourceAliasModifyingEvent datasourceAliasModifyingEvent = new DatasourceAliasModifyingEvent(this, datasource, false);
        this.fireAliasModifying(datasourceAliasModifyingEvent);
        if (datasourceAliasModifyingEvent.getCancel()) {
            return false;
        }
        boolean bl = DatasourcesNative.jni_SetAlias(this.m_workspace.getHandle(), oldAlias, newAlias);
        if (bl) {
            DatasourceAliasModifiedEvent datasourceAliasModifiedEvent = new DatasourceAliasModifiedEvent(this, datasource);
            this.fireAliasModified(datasourceAliasModifiedEvent);
        }
        return bl;
    }

    Workspace getWorkspace() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    void clearChildHandle() {
        if (this.m_datasources != null) {
            int n = this.getCount();
            for (int i = 0; i < n; ++i) {
                this.get(i).clearHandle();
            }
            this.m_datasources.clear();
        }
    }

    void clearHandle() {
        this.clearChildHandle();
        this.m_datasources = null;
        this.m_workspace = null;
    }

    void reset() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L || this.m_datasources == null) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_datasources.clear();
        int n = DatasourcesNative.jni_GetCount(this.m_workspace.getHandle());
        if (n > 0) {
            long[] lArray = new long[n];
            DatasourcesNative.jni_GetDatasources(this.m_workspace.getHandle(), lArray);
            for (int i = 0; i < n; ++i) {
                Datasource datasource = new Datasource(lArray[i], this.m_workspace);
                this.m_datasources.add(datasource);
            }
        }
    }

    void refresh() {
        int n = this.getCount();
        int n2 = DatasourcesNative.jni_GetCount(this.m_workspace.getHandle());
        long[] lArray = new long[n2];
        DatasourcesNative.jni_GetDatasources(this.m_workspace.getHandle(), lArray);
        for (int i = 0; i < n2; ++i) {
            this.get(i).getDatasets().refresh();
            if (i < n) continue;
            Datasource datasource = new Datasource(lArray[i], this.m_workspace);
            this.m_datasources.add(datasource);
        }
    }

    public synchronized void addClosingListener(DatasourceClosingListener l) {
        if (this.m_closingListeners == null) {
            this.m_closingListeners = new Vector();
        }
        if (!this.m_closingListeners.contains(l)) {
            this.m_closingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeClosingListener(DatasourceClosingListener l) {
        if (this.m_closingListeners != null && this.m_closingListeners.contains(l)) {
            this.m_closingListeners.remove(l);
        }
    }

    protected void fireClosing(DatasourceClosingEvent event) {
        if (this.m_closingListeners != null) {
            Vector vector = this.m_closingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((DatasourceClosingListener)vector.elementAt(i)).datasourceClosing(event);
            }
        }
    }

    public synchronized void addClosedListener(DatasourceClosedListener l) {
        if (this.m_closedListeners == null) {
            this.m_closedListeners = new Vector();
        }
        if (!this.m_closedListeners.contains(l)) {
            this.m_closedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeClosedListener(DatasourceClosedListener l) {
        if (this.m_closedListeners != null && this.m_closedListeners.contains(l)) {
            this.m_closedListeners.remove(l);
        }
    }

    protected void fireClosed(DatasourceClosedEvent event) {
        if (this.m_closedListeners != null) {
            Vector vector = this.m_closedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((DatasourceClosedListener)vector.elementAt(i)).datasourceClosed(event);
            }
        }
    }

    public synchronized void addAliasModifiedListener(DatasourceAliasModifiedListener l) {
        if (this.m_aliasModifiedListeners == null) {
            this.m_aliasModifiedListeners = new Vector();
        }
        if (!this.m_aliasModifiedListeners.contains(l)) {
            this.m_aliasModifiedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeAliasModifiedListener(DatasourceAliasModifiedListener l) {
        if (this.m_aliasModifiedListeners != null && this.m_aliasModifiedListeners.contains(l)) {
            this.m_aliasModifiedListeners.remove(l);
        }
    }

    protected void fireAliasModified(DatasourceAliasModifiedEvent event) {
        if (this.m_aliasModifiedListeners != null) {
            Vector vector = this.m_aliasModifiedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((DatasourceAliasModifiedListener)vector.elementAt(i)).datasourceAliasModified(event);
            }
        }
    }

    public synchronized void addOpenedListener(DatasourceOpenedListener l) {
        if (this.m_openedListeners == null) {
            this.m_openedListeners = new Vector();
        }
        if (!this.m_openedListeners.contains(l)) {
            this.m_openedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeOpenedListener(DatasourceOpenedListener l) {
        if (this.m_openedListeners != null && this.m_openedListeners.contains(l)) {
            this.m_openedListeners.remove(l);
        }
    }

    protected void fireOpened(DatasourceOpenedEvent event) {
        if (this.m_openedListeners != null) {
            Vector vector = this.m_openedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((DatasourceOpenedListener)vector.elementAt(i)).datasourceOpened(event);
            }
        }
    }

    public synchronized void addCreatedListener(DatasourceCreatedListener l) {
        if (this.m_createdListeners == null) {
            this.m_createdListeners = new Vector();
        }
        if (!this.m_createdListeners.contains(l)) {
            this.m_createdListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeCreatedListener(DatasourceCreatedListener l) {
        if (this.m_createdListeners != null && this.m_createdListeners.contains(l)) {
            this.m_createdListeners.remove(l);
        }
    }

    protected void fireCreated(DatasourceCreatedEvent event) {
        if (this.m_createdListeners != null) {
            Vector vector = this.m_createdListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((DatasourceCreatedListener)vector.elementAt(i)).datasourceCreated(event);
            }
        }
    }

    public synchronized void addAliasModifyingListener(DatasourceAliasModifyingListener l) {
        if (this.m_aliasModifyingListeners == null) {
            this.m_aliasModifyingListeners = new Vector();
        }
        if (!this.m_aliasModifyingListeners.contains(l)) {
            this.m_aliasModifyingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeAliasModifyingListener(DatasourceAliasModifyingListener l) {
        if (this.m_aliasModifyingListeners != null && this.m_aliasModifyingListeners.contains(l)) {
            this.m_aliasModifyingListeners.remove(l);
        }
    }

    protected void fireAliasModifying(DatasourceAliasModifyingEvent event) {
        if (this.m_aliasModifyingListeners != null) {
            Vector vector = this.m_aliasModifyingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((DatasourceAliasModifyingListener)vector.elementAt(i)).datasourceAliasModifying(event);
            }
        }
    }
}

