/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.StandardMarginNative;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import com.supermap.data.ToolkitNative;

public class StandardMargin
extends InternalHandleDisposable {
    private MarginOffset m_marginOffset;
    private MarginStyle m_marginStyle;
    private PrjCoordSys m_prjCoordSys;

    public StandardMargin() {
        long l = StandardMarginNative.jni_New();
        this.setHandle(l, true);
    }

    public StandardMargin(StandardMargin margin) {
        if (margin == null) {
            String string = InternalResource.loadString("margin", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(margin);
        if (l == 0L) {
            String string = InternalResource.loadString("margin", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = StandardMarginNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(margin);
    }

    public StandardMargin(MarginScaleType scaleType) {
        if (scaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(scaleType);
        long l = StandardMarginNative.jni_New2(n);
        this.setHandle(l, true);
    }

    public StandardMargin(String sheetName) {
        if (!this.nameIsValid(sheetName)) {
            String string = InternalResource.loadString("StandardMargin(String sheetName)", "StandardMargin_SheetName_IsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = StandardMarginNative.jni_New3(sheetName);
        this.setHandle(l, true);
    }

    public StandardMargin(MarginScaleType scaleType, Point2D leftBottom) {
        if (scaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = leftBottom.getX();
        if (d < 0.0) {
            String string = InternalResource.loadString("StandardMargin(MarginScaleType scaleType, Point2D leftBottom)", "StandardMargin_LeftBottomXShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = leftBottom.getY();
        if (d2 < 0.0) {
            String string = InternalResource.loadString("StandardMargin(MarginScaleType scaleType, Point2D leftBottom)", "StandardMargin_LeftBottomYShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = Enum.internalGetUGCValue(scaleType);
        long l = StandardMarginNative.jni_New4(n, d, d2);
        this.setHandle(l, true);
    }

    public StandardMargin(MarginScaleType scaleType, MarginLargeScaleSheetType largeScaleSheetType, Rectangle2D bounds) {
        if (scaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (largeScaleSheetType == null) {
            String string = InternalResource.loadString("largeScaleSheetType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = scaleType.value();
        int n2 = largeScaleSheetType.value();
        long l = StandardMarginNative.jni_New5(n, n2, bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
        this.setHandle(l, true);
    }

    StandardMargin(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
    }

    public MarginOffset getOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_marginOffset == null) {
            this.m_marginOffset = new MarginOffset(this.getHandle());
        }
        return this.m_marginOffset;
    }

    public MarginStyle getStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_marginStyle == null) {
            this.m_marginStyle = new MarginStyle(this.getHandle());
        }
        return this.m_marginStyle;
    }

    public boolean get(MarginElementType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(MarginElementType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        return StandardMarginNative.jni_GetItem(this.getHandle(), n);
    }

    public void set(MarginElementType type, boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItem(MarginElementType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        StandardMarginNative.jni_SetItem(this.getHandle(), n, value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        StandardMarginNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D();
        rectangle2D.setLeft(dArray[0]);
        rectangle2D.setBottom(dArray[1]);
        rectangle2D.setRight(dArray[2]);
        rectangle2D.setTop(dArray[3]);
        return rectangle2D;
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_prjCoordSys == null && (l = StandardMarginNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this.m_prjCoordSys = PrjCoordSys.createInstance(l, false);
        }
        return this.m_prjCoordSys;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys prjCoordSys)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(prjCoordSys);
        if (l == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        StandardMarginNative.jni_SetPrjCoordSys(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
    }

    public MarginScaleType getScaleType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetScaleType(this.getHandle());
        return (MarginScaleType)Enum.parseUGCValue(MarginScaleType.class, n);
    }

    public MarginStandardType getSheetNameType() {
        return MarginStandardType.GB_T_20257;
    }

    public MarginLargeScaleSheetType getLargeScaleSheetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLargeScaleSheetType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetLargeScaleSheetType(this.getHandle());
        return (MarginLargeScaleSheetType)Enum.parseUGCValue(MarginLargeScaleSheetType.class, n);
    }

    public void setLargeScaleSheetType(MarginLargeScaleSheetType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLargeScaleSheetType(MarginLargeScaleSheetType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        StandardMarginNative.jni_SetLargeScaleSheetType(this.getHandle(), n);
    }

    public MarginLargeScaleCoordSysType getLargeScaleCoordSysType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLargeScaleCoordSysType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetLargeScaleCoordSysType(this.getHandle());
        return (MarginLargeScaleCoordSysType)Enum.parseUGCValue(MarginLargeScaleCoordSysType.class, n);
    }

    public void setLargeScaleCoordSysType(MarginLargeScaleCoordSysType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLargeScaleCoordSysType(MarginLargeScaleCoordSysType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        StandardMarginNative.jni_SetLargeScaleCoordSysType(this.getHandle(), n);
    }

    public MarginKilometerGridType getKilometerGridType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKilometerGridType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetKilometerGridType(this.getHandle());
        return (MarginKilometerGridType)Enum.parseUGCValue(MarginKilometerGridType.class, n);
    }

    public void setKilometerGridType(MarginKilometerGridType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKilometerGridType(MarginKilometerGridType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        StandardMarginNative.jni_SetKilometerGridType(this.getHandle(), n);
    }

    public String getMapName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetMapName(this.getHandle());
    }

    public void setMapName(String mapName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapName(String mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetMapName(this.getHandle(), mapName);
    }

    public String getSheetName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetSheetName(this.getHandle());
    }

    public String getPublisher() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPublisher()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetPublisher(this.getHandle());
    }

    public void setPublisher(String publisher) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPublisher(String publisher)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetPublisher(this.getHandle(), publisher);
    }

    public String getSafeInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSafeInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetSafeInfo(this.getHandle());
    }

    public void setSafeInfo(String safeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSafeInfo(String safeInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetSafeInfo(this.getHandle(), safeInfo);
    }

    public String[] getInformation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInformation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetInformation(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setInformation(String[] information) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInformation(String[] information)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (information != null) {
            string = Toolkit.joinString(information, ";");
        }
        StandardMarginNative.jni_SetInformation(this.getHandle(), string);
    }

    public String[] getAnnotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnnotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetAnnotation(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setAnnotation(String[] annotation) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnnotation(String[] annotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (annotation != null) {
            string = Toolkit.joinString(annotation, ";");
        }
        StandardMarginNative.jni_SetAnnotation(this.getHandle(), string);
    }

    public String[] getNeighborMapNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNeighborMapNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetNeighborMapNames(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setNeighborMapNames(String[] neighborMapName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNeighborMapNames(String[] neighborMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (neighborMapName != null) {
            string = Toolkit.joinString(neighborMapName, ";");
        }
        StandardMarginNative.jni_SetNeighborMapNames(this.getHandle(), string);
    }

    public String[] getNeighborSheetNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNeighborSheetNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetNeighborSheetNames(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public double getInformationRowSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInformationRowSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetInformationRowSpace(this.getHandle());
    }

    public void setInformationRowSpace(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInformationRowSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetInformationRowSpace(this.getHandle(), value);
    }

    public double getAnnotationRowSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnnotationRowSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetAnnotationRowSpace(this.getHandle());
    }

    public void setAnnotationRowSpace(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnnotationRowSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetAnnotationRowSpace(this.getHandle(), value);
    }

    public double getContourInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getContourInterval()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetContourInterval(this.getHandle());
    }

    public void setContourInterval(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setContourInterval(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetContourInterval(this.getHandle(), value);
    }

    public double getKilometerGridHorizontalSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKilometerGridHorizontalSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetKilometerGridHorizontalSpace(this.getHandle());
    }

    public void setKilometerGridHorizontalSpace(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKilometerGridHorizontalSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetKilometerGridHorizontalSpace(this.getHandle(), value);
    }

    public double getKilometerGridVerticalSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKilometerGridVerticalSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetKilometerGridVerticalSpace(this.getHandle());
    }

    public void setKilometerGridVerticalSpace(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKilometerGridVerticalSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetKilometerGridVerticalSpace(this.getHandle(), value);
    }

    public int getSegmentCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetSegmentCount(this.getHandle());
    }

    public void setSegmentCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetSegmentCount(this.getHandle(), value);
    }

    public int getZoneNumber() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getZoneNumber()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetZoneNumber(this.getHandle());
    }

    public void setZoneNumber(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setZoneNumber(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetZoneNumber(this.getHandle(), value);
    }

    public double getMeridianAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeridianAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetMeridianAngle(this.getHandle());
    }

    public void setMeridianAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMeridianAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < -90.0) {
            value = -90.0;
        }
        if (value > 90.0) {
            value = 90.0;
        }
        StandardMarginNative.jni_SetMeridianAngle(this.getHandle(), value);
    }

    public double getMagnetAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMagnetAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetMagnetAngle(this.getHandle());
    }

    public void setMagnetAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMagnetAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < -90.0) {
            value = -90.0;
        }
        if (value > 90.0) {
            value = 90.0;
        }
        StandardMarginNative.jni_SetMagnetAngle(this.getHandle(), value);
    }

    public double getInsideSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInsideSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetInsideSpace(this.getHandle());
    }

    public void setInsideSpace(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInsideSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetInsideSpace(this.getHandle(), value);
    }

    public double getOuterBoxLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOuterBoxLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetOuterBoxLineWidth(this.getHandle());
    }

    public void setOuterBoxLineWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOuterBoxLineWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetOuterBoxLineWidth(this.getHandle(), value);
    }

    public double getCrossLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCrossLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetCrossLength(this.getHandle());
    }

    public void setCrossLength(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCrossLength(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetCrossLength(this.getHandle(), value);
    }

    public boolean isCreateLonLatText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCreateLonLatText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_IsCreateLonLatText(this.getHandle());
    }

    public void setIsCreateLonLatText(boolean bValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsCreateLonLatText(boolean bValue)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetIsCreateLonLatText(this.getHandle(), bValue);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            StandardMarginNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public void showAllElements() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("showAllElements()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_ShowAllElements(this.getHandle());
    }

    public void hideAllElements() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hideAllElements()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_HideAllElements(this.getHandle());
    }

    public static String computeSheetName(Point2D bottomLeft, MarginScaleType scaleType) {
        if (scaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = bottomLeft.getX();
        double d2 = bottomLeft.getY();
        int n = Enum.internalGetUGCValue(scaleType);
        return StandardMarginNative.jni_ComputeSheetName(d, d2, n);
    }

    public static DatasetVector createStandardMarginDataset(Datasource datasource, String datasetName, StandardMargin standardMargin) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = datasource.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(datasetName)) {
            String string = InternalResource.loadString("datasetName", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (standardMargin == null) {
            String string = InternalResource.loadString("standardMargin", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = standardMargin.getHandle();
        if (l2 == 0L) {
            String string = InternalResource.loadString("standardMargin", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = ToolkitNative.jni_creatStandardMargin(l, datasetName, l2);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = DatasetVector.createInstance(l3, datasource);
            Datasets.add(datasource.getDatasets(), datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(standardMargin);
        return datasetVector;
    }

    @Override
    protected void clearHandle() {
        if (this.m_marginOffset != null) {
            this.m_marginOffset.clearHandle();
            this.m_marginOffset = null;
        }
        if (this.m_marginStyle != null) {
            this.m_marginStyle.clearHandle();
            this.m_marginStyle = null;
        }
        if (this.m_prjCoordSys != null) {
            this.m_prjCoordSys.clearHandle();
            this.m_prjCoordSys = null;
        }
        this.setHandle(0L);
    }

    protected boolean nameIsValid(String sheetName) {
        boolean bl = StandardMarginNative.jni_NameIsValid(sheetName);
        return bl;
    }

    public static class MarginKilometerGridType
    extends Enum {
        public static final MarginKilometerGridType CROSS = new MarginKilometerGridType(0, 0);
        public static final MarginKilometerGridType SOLIDLINE = new MarginKilometerGridType(1, 1);

        private MarginKilometerGridType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }

    public static class MarginLargeScaleCoordSysType
    extends Enum {
        public static final MarginLargeScaleCoordSysType USERDEFINE = new MarginLargeScaleCoordSysType(0, 0);
        public static final MarginLargeScaleCoordSysType NATIONAL = new MarginLargeScaleCoordSysType(1, 1);

        private MarginLargeScaleCoordSysType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }

    public static class MarginLargeScaleSheetType
    extends Enum {
        public static final MarginLargeScaleSheetType SHEET40x50 = new MarginLargeScaleSheetType(0, 0);
        public static final MarginLargeScaleSheetType SHEET50x50 = new MarginLargeScaleSheetType(1, 1);
        public static final MarginLargeScaleSheetType USERDEFINE = new MarginLargeScaleSheetType(2, 2);

        private MarginLargeScaleSheetType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }

    public static class MarginStandardType
    extends Enum {
        public static final MarginStandardType GB_T_20257 = new MarginStandardType(0, 0);

        private MarginStandardType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }

    public static class MarginScaleType
    extends Enum {
        public static final MarginScaleType SCALE_500 = new MarginScaleType(500, 500);
        public static final MarginScaleType SCALE_1000 = new MarginScaleType(1000, 1000);
        public static final MarginScaleType SCALE_2000 = new MarginScaleType(2000, 2000);
        public static final MarginScaleType SCALE_5000 = new MarginScaleType(5000, 5000);
        public static final MarginScaleType SCALE_10000 = new MarginScaleType(10000, 10000);
        public static final MarginScaleType SCALE_25000 = new MarginScaleType(25000, 25000);
        public static final MarginScaleType SCALE_50000 = new MarginScaleType(50000, 50000);
        public static final MarginScaleType SCALE_100000 = new MarginScaleType(100000, 100000);
        public static final MarginScaleType SCALE_250000 = new MarginScaleType(250000, 250000);
        public static final MarginScaleType SCALE_500000 = new MarginScaleType(500000, 500000);
        public static final MarginScaleType SCALE_1000000 = new MarginScaleType(1000000, 1000000);

        private MarginScaleType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }

    public static class MarginElementType
    extends Enum {
        public static final MarginElementType SCALE = new MarginElementType(1, 1);
        public static final MarginElementType MAPNAME = new MarginElementType(2, 2);
        public static final MarginElementType INFORMATION = new MarginElementType(4, 4);
        public static final MarginElementType PUBLISHER = new MarginElementType(16, 16);
        public static final MarginElementType GRID = new MarginElementType(32, 32);
        public static final MarginElementType NEIGHBORTABLE = new MarginElementType(64, 64);
        public static final MarginElementType ALTIMETER = new MarginElementType(128, 128);
        public static final MarginElementType DEPTHGAUGE = new MarginElementType(256, 256);
        public static final MarginElementType SLOPERULER = new MarginElementType(512, 512);
        public static final MarginElementType NEIGHBOR_KILOMETER_GRID = new MarginElementType(1024, 1024);
        public static final MarginElementType THREE_NORTH_GRAPH = new MarginElementType(2048, 2048);
        public static final MarginElementType ANNOTATIONS = new MarginElementType(4096, 4096);
        public static final MarginElementType MAPNUMBER = new MarginElementType(8192, 8192);
        public static final MarginElementType SAFEINFO = new MarginElementType(16384, 16384);
        public static final MarginElementType BASICSCALE = new MarginElementType(32768, 32768);
        public static final MarginElementType TEXTSCALE = new MarginElementType(65536, 65536);
        public static final MarginElementType SEASCALE = new MarginElementType(131072, 131072);
        public static final MarginElementType CORNER_MAP_NUMBER = new MarginElementType(262144, 262144);
        public static final MarginElementType CORNER_MAP_NAME = new MarginElementType(524288, 524288);
        public static final MarginElementType NEIGHBOR_SHEET_NAME = new MarginElementType(0x100000, 0x100000);
        public static final MarginElementType NEIGHBOR_MAP_NAME = new MarginElementType(0x200000, 0x200000);

        private MarginElementType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }

    public class MarginStyle
    extends InternalHandle {
        private TextStyle m_mapName = null;
        private TextStyle m_sheetName = null;
        private TextStyle m_publisher = null;
        private TextStyle m_safeInfo = null;
        private TextStyle m_information = null;
        private TextStyle m_annotation = null;
        private TextStyle m_neighborMapNames = null;
        private TextStyle m_neighborSheetNames = null;
        private TextStyle m_textScale = null;
        private TextStyle m_kilometer = null;
        private TextStyle m_hundredKilometer = null;
        private TextStyle m_cornerSheetName = null;
        private TextStyle m_cornerMapName = null;
        private TextStyle m_longitudeAndLatitude = null;
        private TextStyle m_basicScale = null;

        private MarginStyle(long handle) {
            this.setHandle(handle);
        }

        public TextStyle getAnnotation() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getAnnotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_annotation == null && (l = StandardMarginNative.jni_GetAnnotationStyle(this.getHandle())) != 0L) {
                this.m_annotation = TextStyle.createInstance(l);
            }
            return this.m_annotation;
        }

        public void setAnnotation(TextStyle annotation) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setAnnotation(TextStyle annotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (annotation == null) {
                String string = InternalResource.loadString("annotation", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (annotation.getHandle() == 0L) {
                String string = InternalResource.loadString("annotation", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetAnnotationStyle(this.getHandle(), annotation.getHandle());
        }

        public TextStyle getBasicScale() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBasicScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_basicScale == null && (l = StandardMarginNative.jni_GetBasicScaleStyle(this.getHandle())) != 0L) {
                this.m_basicScale = TextStyle.createInstance(l);
            }
            return this.m_basicScale;
        }

        public void setBasicScale(TextStyle basicScale) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBasicScale(TextStyle basicScale)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (basicScale == null) {
                String string = InternalResource.loadString("basicScale", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (basicScale.getHandle() == 0L) {
                String string = InternalResource.loadString("basicScale", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetBasicScaleStyle(this.getHandle(), basicScale.getHandle());
        }

        public TextStyle getCornerMapName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getCornerMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_cornerMapName == null && (l = StandardMarginNative.jni_GetCornerMapNameStyle(this.getHandle())) != 0L) {
                this.m_cornerMapName = TextStyle.createInstance(l);
            }
            return this.m_cornerMapName;
        }

        public void setCornerMapName(TextStyle cornerMapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setCornerMapName(TextStyle cornerMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (cornerMapName == null) {
                String string = InternalResource.loadString("cornerMapName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (cornerMapName.getHandle() == 0L) {
                String string = InternalResource.loadString("cornerMapName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetCornerMapNameStyle(this.getHandle(), cornerMapName.getHandle());
        }

        public TextStyle getCornerSheetName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getCornerSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_cornerSheetName == null && (l = StandardMarginNative.jni_GetCornerSheetNameStyle(this.getHandle())) != 0L) {
                this.m_cornerSheetName = TextStyle.createInstance(l);
            }
            return this.m_cornerSheetName;
        }

        public void setCornerSheetName(TextStyle cornerSheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setCornerSheetName(TextStyle cornerSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (cornerSheetName == null) {
                String string = InternalResource.loadString("cornerSheetName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (cornerSheetName.getHandle() == 0L) {
                String string = InternalResource.loadString("cornerSheetName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetCornerSheetNameStyle(this.getHandle(), cornerSheetName.getHandle());
        }

        public TextStyle getInformation() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getInformation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_information == null && (l = StandardMarginNative.jni_GetInformationStyle(this.getHandle())) != 0L) {
                this.m_information = TextStyle.createInstance(l);
            }
            return this.m_information;
        }

        public void setInformation(TextStyle information) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setInformation(TextStyle information)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (information == null) {
                String string = InternalResource.loadString("information", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (information.getHandle() == 0L) {
                String string = InternalResource.loadString("information", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetInformationStyle(this.getHandle(), information.getHandle());
        }

        public TextStyle getLongitudeAndLatitude() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getLongitudeAndLatitude()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_longitudeAndLatitude == null && (l = StandardMarginNative.jni_GetLongitudeAndLatitudeStyle(this.getHandle())) != 0L) {
                this.m_longitudeAndLatitude = TextStyle.createInstance(l);
            }
            return this.m_longitudeAndLatitude;
        }

        public void setLongitudeAndLatitude(TextStyle longitudeAndLatitude) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setLongitudeAndLatitude(TextStyle longitudeAndLatitude)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (longitudeAndLatitude == null) {
                String string = InternalResource.loadString("longitudeAndLatitude", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (longitudeAndLatitude.getHandle() == 0L) {
                String string = InternalResource.loadString("longitudeAndLatitude", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetLongitudeAndLatitudeStyle(this.getHandle(), longitudeAndLatitude.getHandle());
        }

        public TextStyle getMapName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_mapName == null && (l = StandardMarginNative.jni_GetMapNameStyle(this.getHandle())) != 0L) {
                this.m_mapName = TextStyle.createInstance(l);
            }
            return this.m_mapName;
        }

        public void setMapName(TextStyle mapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setMapName(TextStyle mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (mapName == null) {
                String string = InternalResource.loadString("mapName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (mapName.getHandle() == 0L) {
                String string = InternalResource.loadString("mapName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetMapNameStyle(this.getHandle(), mapName.getHandle());
        }

        public TextStyle getNeighborMapNames() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getNeighborMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_neighborMapNames == null && (l = StandardMarginNative.jni_GetNeighborMapNamesStyle(this.getHandle())) != 0L) {
                this.m_neighborMapNames = TextStyle.createInstance(l);
            }
            return this.m_neighborMapNames;
        }

        public void setNeighborMapNames(TextStyle neighborMapNames) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setNeighborMapNames(TextStyle neighborMapNames)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (neighborMapNames == null) {
                String string = InternalResource.loadString("neighborMapNames", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (neighborMapNames.getHandle() == 0L) {
                String string = InternalResource.loadString("neighborMapNames", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetNeighborMapNamesStyle(this.getHandle(), neighborMapNames.getHandle());
        }

        public TextStyle getNeighborSheetNames() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getNeighborSheetNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_neighborSheetNames == null && (l = StandardMarginNative.jni_GetNeighborSheetNamesStyle(this.getHandle())) != 0L) {
                this.m_neighborSheetNames = TextStyle.createInstance(l);
            }
            return this.m_neighborSheetNames;
        }

        public void setNeighborSheetNames(TextStyle neighborSheetNames) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setNeighborSheetNames(TextStyle neighborSheetNames)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (neighborSheetNames == null) {
                String string = InternalResource.loadString("neighborSheetNames", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (neighborSheetNames.getHandle() == 0L) {
                String string = InternalResource.loadString("neighborSheetNames", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetNeighborSheetNamesStyle(this.getHandle(), neighborSheetNames.getHandle());
        }

        public TextStyle getPublisher() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getPublisher()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_publisher == null && (l = StandardMarginNative.jni_GetPublisherStyle(this.getHandle())) != 0L) {
                this.m_publisher = TextStyle.createInstance(l);
            }
            return this.m_publisher;
        }

        public void setPublisher(TextStyle publisher) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setPublisher(TextStyle publisher)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (publisher == null) {
                String string = InternalResource.loadString("publisher", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (publisher.getHandle() == 0L) {
                String string = InternalResource.loadString("publisher", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetPublisherStyle(this.getHandle(), publisher.getHandle());
        }

        public TextStyle getSafeInfo() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getSafeInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_safeInfo == null && (l = StandardMarginNative.jni_GetSafeInfoStyle(this.getHandle())) != 0L) {
                this.m_safeInfo = TextStyle.createInstance(l);
            }
            return this.m_safeInfo;
        }

        public void setSafeInfo(TextStyle safeInfo) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSafeInfo(TextStyle safeInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (safeInfo == null) {
                String string = InternalResource.loadString("safeInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (safeInfo.getHandle() == 0L) {
                String string = InternalResource.loadString("safeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetSafeInfoStyle(this.getHandle(), safeInfo.getHandle());
        }

        public TextStyle getSheetName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_sheetName == null && (l = StandardMarginNative.jni_GetSheetNameStyle(this.getHandle())) != 0L) {
                this.m_sheetName = TextStyle.createInstance(l);
            }
            return this.m_sheetName;
        }

        public void setSheetName(TextStyle sheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSheetName(TextStyle sheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (sheetName == null) {
                String string = InternalResource.loadString("sheetName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (sheetName.getHandle() == 0L) {
                String string = InternalResource.loadString("sheetName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetSheetNameStyle(this.getHandle(), sheetName.getHandle());
        }

        public TextStyle getTextScale() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTextScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_textScale == null && (l = StandardMarginNative.jni_GetTextScaleStyle(this.getHandle())) != 0L) {
                this.m_textScale = TextStyle.createInstance(l);
            }
            return this.m_textScale;
        }

        public void setTextScale(TextStyle textScale) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTextScale(TextStyle textScale)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textScale == null) {
                String string = InternalResource.loadString("textScale", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textScale.getHandle() == 0L) {
                String string = InternalResource.loadString("textScale", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetTextScaleStyle(this.getHandle(), textScale.getHandle());
        }

        @Override
        protected void clearHandle() {
            this.setHandle(0L);
            if (this.m_mapName != null) {
                this.m_mapName.clearHandle();
                this.m_mapName = null;
            }
            if (this.m_sheetName != null) {
                this.m_sheetName.clearHandle();
                this.m_sheetName = null;
            }
            if (this.m_publisher != null) {
                this.m_publisher.clearHandle();
                this.m_publisher = null;
            }
            if (this.m_safeInfo != null) {
                this.m_safeInfo.clearHandle();
                this.m_safeInfo = null;
            }
            if (this.m_information != null) {
                this.m_information.clearHandle();
                this.m_information = null;
            }
            if (this.m_annotation != null) {
                this.m_annotation.clearHandle();
                this.m_annotation = null;
            }
            if (this.m_neighborMapNames != null) {
                this.m_neighborMapNames.clearHandle();
                this.m_neighborMapNames = null;
            }
            if (this.m_neighborSheetNames != null) {
                this.m_neighborSheetNames.clearHandle();
                this.m_neighborSheetNames = null;
            }
            if (this.m_textScale != null) {
                this.m_textScale.clearHandle();
                this.m_textScale = null;
            }
            if (this.m_kilometer != null) {
                this.m_kilometer.clearHandle();
                this.m_kilometer = null;
            }
            if (this.m_hundredKilometer != null) {
                this.m_hundredKilometer.clearHandle();
                this.m_hundredKilometer = null;
            }
            if (this.m_cornerSheetName != null) {
                this.m_cornerSheetName.clearHandle();
                this.m_cornerSheetName = null;
            }
            if (this.m_cornerMapName != null) {
                this.m_cornerMapName.clearHandle();
                this.m_cornerMapName = null;
            }
            if (this.m_longitudeAndLatitude != null) {
                this.m_longitudeAndLatitude.clearHandle();
                this.m_longitudeAndLatitude = null;
            }
            if (this.m_basicScale != null) {
                this.m_basicScale.clearHandle();
                this.m_basicScale = null;
            }
        }
    }

    public class MarginOffset
    extends InternalHandle {
        private MarginOffset(long handle) {
            this.setHandle(handle);
        }

        public Size2D getAnnotation() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getAnnotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetAnnotationOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setAnnotation(Size2D annotation) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setAnnotation(Size2D annotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = annotation.getWidth();
            double d2 = annotation.getHeight();
            StandardMarginNative.jni_SetAnnotationOffset(this.getHandle(), d, d2);
        }

        public Size2D getBasicScale() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBasicScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBasicScaleOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBasicScale(Size2D basicScale) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBasicScale(Size2D basicScale)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = basicScale.getWidth();
            double d2 = basicScale.getHeight();
            StandardMarginNative.jni_SetBasicScaleOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomLeftSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomLeftSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomLeftSheetNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomLeftSheetName(Size2D bottomLeftSheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomLeftSheetName(Size2D bottomLeftSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = bottomLeftSheetName.getWidth();
            double d2 = bottomLeftSheetName.getHeight();
            StandardMarginNative.jni_SetBottomLeftSheetNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomRightSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomRightSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomRightSheetNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomRightSheetName(Size2D bottomRightSheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomRightSheetName(Size2D bottomRightSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = bottomRightSheetName.getWidth();
            double d2 = bottomRightSheetName.getHeight();
            StandardMarginNative.jni_SetBottomRightSheetNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getInformation() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getInformation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetInformationOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setInformation(Size2D information) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setInformation(Size2D information)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = information.getWidth();
            double d2 = information.getHeight();
            StandardMarginNative.jni_SetInformationOffset(this.getHandle(), d, d2);
        }

        public Size2D getPublisher() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getPublisher()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetPublisherOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setPublisher(Size2D publisher) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setPublisher(Size2D publisher)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = publisher.getWidth();
            double d2 = publisher.getHeight();
            StandardMarginNative.jni_SetPublisherOffset(this.getHandle(), d, d2);
        }

        public Size2D getSafeInfo() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getSafeInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetSafeInfoOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setSafeInfo(Size2D safeInfo) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSafeInfo(Size2D safeInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = safeInfo.getWidth();
            double d2 = safeInfo.getHeight();
            StandardMarginNative.jni_SetSafeInfoOffset(this.getHandle(), d, d2);
        }

        public Size2D getTextScale() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTextScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTextScaleOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTextScale(Size2D textScale) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTextScale(Size2D textScaleOffset)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = textScale.getWidth();
            double d2 = textScale.getHeight();
            StandardMarginNative.jni_SetTextScaleOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopLeftSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopLeftSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopLeftSheepNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopLeftSheetName(Size2D topLeftSheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopLeftSheetName(Size2D topLeftSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = topLeftSheetName.getWidth();
            double d2 = topLeftSheetName.getHeight();
            StandardMarginNative.jni_SetTopLeftSheepNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopRightSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopRightSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopRightSheepNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopRightSheetName(Size2D topRightSheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopRightSheetName(Size2D topRightSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = topRightSheetName.getWidth();
            double d2 = topRightSheetName.getHeight();
            StandardMarginNative.jni_SetTopRightSheepNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopCenterSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopCenterSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopCenterSheepNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopCenterSheetName(Size2D topCenterSheetName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopCenterSheetName(Size2D topCenterSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = topCenterSheetName.getWidth();
            double d2 = topCenterSheetName.getHeight();
            StandardMarginNative.jni_SetTopCenterSheepNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopCenterMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopCenterMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopCenterMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopCenterMapName(Size2D topCenterMapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopCenterMapName(Size2D topCenterMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = topCenterMapName.getWidth();
            double d2 = topCenterMapName.getHeight();
            StandardMarginNative.jni_SetTopCenterMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopRightMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopRightMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopRightMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopRightMapName(Size2D topRightMapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopRightMapName(Size2D topRightMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = topRightMapName.getWidth();
            double d2 = topRightMapName.getHeight();
            StandardMarginNative.jni_SetTopRightMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopLeftMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopLeftMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopLeftMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopLeftMapName(Size2D topLeftMapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopLeftMapName(Size2D topLeftMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = topLeftMapName.getWidth();
            double d2 = topLeftMapName.getHeight();
            StandardMarginNative.jni_SetTopLeftMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomLeftMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomLeftMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomLeftMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomLeftMapName(Size2D bottomLeftMapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomLeftMapName(Size2D bottomLeftMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = bottomLeftMapName.getWidth();
            double d2 = bottomLeftMapName.getHeight();
            StandardMarginNative.jni_SetBottomLeftMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomRightMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomRightMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomRightMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomRightMapName(Size2D bottomRightMapName) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomRightMapName(Size2D bottomRightMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = bottomRightMapName.getWidth();
            double d2 = bottomRightMapName.getHeight();
            StandardMarginNative.jni_SetBottomLeftMapNameOffset(this.getHandle(), d, d2);
        }
    }
}

