/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.ResourcesNative;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolLineLibrary;
import com.supermap.data.SymbolMarkerLibrary;
import com.supermap.data.Workspace;

public class Resources
extends InternalHandleDisposable {
    Workspace m_workspace;
    SymbolLineLibrary m_symbolLineLibrary;
    SymbolMarkerLibrary m_symbolMarkerLibrary;
    SymbolFillLibrary m_symbolFillLibrary;

    public Resources() {
        this.setHandle(ResourcesNative.jni_New(), true);
    }

    Resources(Workspace workspace, long handle) {
        this.m_workspace = workspace;
        this.setHandle(handle, false);
    }

    public SymbolLineLibrary getLineLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_symbolLineLibrary == null) {
            long l = ResourcesNative.jni_GetLineLibrary(this.getHandle());
            this.m_symbolLineLibrary = new SymbolLineLibrary(l);
        }
        return this.m_symbolLineLibrary;
    }

    public SymbolMarkerLibrary getMarkerLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_symbolMarkerLibrary == null) {
            long l = ResourcesNative.jni_GetMarkerLibrary(this.getHandle());
            this.m_symbolMarkerLibrary = new SymbolMarkerLibrary(l);
        }
        return this.m_symbolMarkerLibrary;
    }

    public SymbolFillLibrary getFillLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_symbolFillLibrary == null) {
            long l = ResourcesNative.jni_GetFillLibrary(this.getHandle());
            this.m_symbolFillLibrary = new SymbolFillLibrary(l);
        }
        return this.m_symbolFillLibrary;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    @Override
    protected void clearHandle() {
        this.m_workspace = null;
        if (this.m_symbolLineLibrary != null) {
            this.m_symbolLineLibrary.clearHandle();
            this.m_symbolLineLibrary = null;
        }
        if (this.m_symbolMarkerLibrary != null) {
            this.m_symbolMarkerLibrary.clearHandle();
            this.m_symbolMarkerLibrary = null;
        }
        if (this.m_symbolFillLibrary != null) {
            this.m_symbolFillLibrary.clearHandle();
            this.m_symbolFillLibrary = null;
        }
        this.setHandle(0L);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ResourcesNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected static Resources createInstance(Workspace workspace, long handle) {
        if (workspace == null || workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("workspace", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Resources resources = new Resources(workspace, handle);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return resources;
    }

    private void refreshHandle(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
    }

    protected static void clearHandle(Resources resources) {
        resources.clearHandle();
    }

    protected static void refreshHandle(Resources resources, long handle) {
        resources.refreshHandle(handle);
    }
}

