/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parameter<T> {
    public final String name;
    public final String desc;
    public final Class<T> type;
    public final boolean essential;
    public final Object defaultValue;
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public Parameter(String name, Class<T> type) {
        this(name, type, null);
    }

    public Parameter(String name, Class<T> type, String description) {
        this(name, type, description, false);
    }

    public Parameter(String name, Class<T> type, String desc, boolean essential) {
        this(name, type, desc, essential, null);
    }

    public Parameter(String name, Class<T> type, String desc, boolean essential, Object defaultValue) {
        this.name = name;
        this.type = type;
        this.desc = desc;
        this.essential = essential;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Boolean isEssential() {
        return this.essential;
    }

    public T getDefaultValue() {
        return (T)this.defaultValue;
    }

    public T find(Map<Parameter, ?> map) throws IOException {
        Parameter parameter = null;
        for (Parameter parameter2 : map.keySet()) {
            if (!parameter2.getName().equals(this.name)) continue;
            parameter = parameter2;
            break;
        }
        if (parameter == null) {
            if (this.essential) {
                throw new IOException("Parameter " + this.name + " is essential.");
            }
            return null;
        }
        Iterator<Parameter<Object>> iterator = map.get(parameter);
        if (iterator == null) {
            return null;
        }
        if (!this.type.isInstance(iterator)) {
            throw new IOException("parameter " + this.name + " should be instance of " + this.type.getName() + ", not " + iterator.getClass().getName());
        }
        return (T)iterator;
    }

    public String serialize(T objectValue) {
        return objectValue.toString();
    }

    public T deserialize(String text) throws IOException {
        if (text == null) {
            return null;
        }
        if (this.type == String.class) {
            return (T)text;
        }
        if (text.length() == 0) {
            return null;
        }
        if (this.type.isArray()) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(text, " ");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                Object object2;
                object = stringTokenizer.nextToken();
                try {
                    object2 = this.type.getComponentType() == String.class ? object : this.parse((String)object);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Throwable throwable) {
                    throw new IOException("Problem creating " + this.type.getName() + " from '" + text + "'", throwable);
                }
                arrayList.add(object2);
            }
            object = Array.newInstance(this.type.getComponentType(), arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                Array.set(object, i, arrayList.get(i));
            }
            return (T)object;
        }
        try {
            return this.parse(text);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException("Problem creating " + this.type.getName() + " from '" + text + "'", throwable);
        }
    }

    private T parse(String text) throws Throwable {
        Constructor<T> constructor;
        try {
            constructor = this.type.getConstructor(String.class);
        }
        catch (SecurityException securityException) {
            throw new IOException("Could not create " + this.type.getName() + " from text");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Could not create " + this.type.getName() + " from text");
        }
        try {
            return constructor.newInstance(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Could not create " + this.type.getName() + ": from '" + text + "'", illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Could not create " + this.type.getName() + ": from '" + text + "'", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Could not create " + this.type.getName() + ": from '" + text + "'", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<parameter>");
        stringBuilder.append("<name>");
        stringBuilder.append(this.name);
        stringBuilder.append("</name>");
        stringBuilder.append("<type>");
        stringBuilder.append(this.type.getName());
        stringBuilder.append("</type>");
        stringBuilder.append("<essential>");
        stringBuilder.append(this.essential);
        stringBuilder.append("</essential>");
        stringBuilder.append("<desc>");
        stringBuilder.append(this.desc);
        stringBuilder.append("</desc>");
        stringBuilder.append("</parameter>");
        return stringBuilder.toString();
    }

    public static Parameter fromString(String text) throws Exception {
        if (text == null || text.isEmpty()) {
            return null;
        }
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(text.getBytes()));
        NodeList nodeList = document.getElementsByTagName("parameter");
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        String string = "";
        String string2 = "";
        Class<?> clazz = null;
        boolean bl = false;
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (node2.getNodeName().equals("name")) {
                string = node2.getTextContent();
                continue;
            }
            if (node2.getNodeName().equals("type")) {
                clazz = Class.forName(node2.getTextContent());
                continue;
            }
            if (node2.getNodeName().equals("essential")) {
                bl = Boolean.valueOf(node2.getTextContent());
                continue;
            }
            if (!node2.getNodeName().equals("desc")) continue;
            string2 = node2.getTextContent();
        }
        return new Parameter(string, clazz, string2, bl, null);
    }
}

