/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BufferImageNative;
import com.supermap.data.DatasetType;
import com.supermap.data.Enum;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.Workspace;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

class InternalBufferImage
extends InternalHandleDisposable {
    private Image m_memoryImage = null;
    private int m_width;
    private int m_height;
    private int[] m_buffer;

    public InternalBufferImage(int width, int height) throws IllegalArgumentException {
        this.m_width = width;
        this.m_height = height;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        if ((long)height > l / (long)width) {
            throw new IllegalArgumentException();
        }
        this.m_buffer = new int[width * height];
        long l2 = BufferImageNative.jni_New(width, height);
        this.setHandle(l2, true);
    }

    public void resize(int width, int height) {
        if (width > 0 && height > 0 && (this.m_width != width || this.m_height != height)) {
            BufferImageNative.jni_Resize(this.getHandle(), width, height);
            this.m_width = width;
            this.m_height = height;
            this.m_buffer = new int[width * height];
        }
    }

    @Override
    public void dispose() {
        long l = this.getHandle();
        if (l != 0L) {
            BufferImageNative.jni_Delete(l);
            this.setHandle(0L);
        }
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public Image getMemoryImage() {
        BufferImageNative.jni_GetImage(this.getHandle(), this.m_buffer);
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.m_width, this.m_height, this.m_buffer, 0, this.m_width);
        this.m_memoryImage = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        return this.m_memoryImage;
    }

    private void onDraw(Graphics g, int x, int y) {
        Image image = this.getMemoryImage();
        g.drawImage(image, x, y, null);
    }

    static int getSymbolItemIndex(int ID, DatasetType datasetType, Workspace workspace) {
        if (datasetType == null) {
            String string = InternalResource.loadString("datasetType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(datasetType);
        int n2 = BufferImageNative.jni_GetSymbolItemIndex(l, n, ID);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return n2;
    }

    static double getMarkerSymbolDefaultSize(Workspace workspace, int ID) {
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = BufferImageNative.jni_GetSymbolDefaultSize(l, ID);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return d;
    }

    static boolean drawRegion(Graphics g, Point2Ds points, GeoStyle style, Workspace workspace) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(workspace);
        if (l2 == 0L) {
            String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            Object object;
            int n;
            InternalBufferImage internalBufferImage;
            GeoRegion geoRegion = new GeoRegion(points);
            Rectangle2D rectangle2D = geoRegion.getBounds();
            int n2 = rectangle2D.getWidth() > rectangle2D.getHeight() ? (int)rectangle2D.getWidth() : (int)rectangle2D.getHeight();
            if (InternalBufferImage.getSymbolItemIndex(style.getFillSymbolID(), DatasetType.REGION, workspace) < 0) {
                int n3 = points.getCount();
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3];
                for (int i = 0; i < points.getCount(); ++i) {
                    nArray[i] = (int)points.getItem(i).getX();
                    nArray2[i] = (int)points.getItem(i).getY();
                }
                g.setColor(style.getFillForeColor());
                g.fillPolygon(nArray, nArray2, n3);
                InternalHandleDisposable.makeSureNativeObjectLive(style);
                InternalHandleDisposable.makeSureNativeObjectLive(workspace);
                return true;
            }
            try {
                internalBufferImage = new InternalBufferImage(n2 + 1, n2 + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            for (n = 0; n < points.getCount(); ++n) {
                object = points.getItem(n);
                ((Point2D)object).setX(((Point2D)object).getX() - rectangle2D.getLeft());
                ((Point2D)object).setY(((Point2D)object).getY() - rectangle2D.getBottom());
                points.setItem(n, (Point2D)object);
            }
            geoRegion.dispose();
            geoRegion = null;
            n = points.getCount();
            object = new double[n];
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                object[i] = points.getItem(i).getX();
                dArray[i] = points.getItem(i).getY();
            }
            if (BufferImageNative.jni_DrawFillSymbol(internalBufferImage.getHandle(), l2, l, (double[])object, dArray)) {
                internalBufferImage.onDraw(g, (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom());
                internalBufferImage.dispose();
                internalBufferImage = null;
                InternalHandleDisposable.makeSureNativeObjectLive(style);
                InternalHandleDisposable.makeSureNativeObjectLive(workspace);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return false;
    }

    static boolean drawLine(Graphics g, Point2Ds points, GeoStyle style, Workspace workspace) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(workspace);
        if (l2 == 0L) {
            String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            Object object;
            int n;
            InternalBufferImage internalBufferImage;
            int n2;
            GeoLine geoLine = new GeoLine(points);
            Rectangle2D rectangle2D = geoLine.getBounds();
            int n3 = 0;
            int n4 = 0;
            if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                n2 = (int)rectangle2D.getWidth();
                n4 = (int)rectangle2D.getWidth() / 2;
            } else {
                n2 = (int)rectangle2D.getHeight();
                n3 = (int)rectangle2D.getHeight() / 2;
            }
            if (InternalBufferImage.getSymbolItemIndex(style.getLineSymbolID(), DatasetType.LINE, workspace) < 0) {
                int n5 = points.getCount();
                int[] nArray = new int[n5];
                int[] nArray2 = new int[n5];
                for (int i = 0; i < points.getCount(); ++i) {
                    nArray[i] = (int)points.getItem(i).getX();
                    nArray2[i] = (int)points.getItem(i).getY();
                }
                Graphics2D graphics2D = (Graphics2D)g;
                int n6 = (int)style.getLineWidth();
                if (n6 > 3) {
                    n6 = 3;
                }
                graphics2D.setStroke(new BasicStroke(n6));
                graphics2D.setColor(style.getLineColor());
                graphics2D.drawPolyline(nArray, nArray2, n5);
                InternalHandleDisposable.makeSureNativeObjectLive(style);
                InternalHandleDisposable.makeSureNativeObjectLive(workspace);
                return true;
            }
            try {
                internalBufferImage = new InternalBufferImage(n2 + 1, n2 + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            for (n = 0; n < points.getCount(); ++n) {
                object = points.getItem(n);
                ((Point2D)object).setX(((Point2D)object).getX() - rectangle2D.getLeft() + (double)n3);
                ((Point2D)object).setY(((Point2D)object).getY() - rectangle2D.getBottom() + (double)n4);
                points.setItem(n, (Point2D)object);
            }
            geoLine.dispose();
            geoLine = null;
            n = points.getCount();
            object = new double[n];
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                object[i] = points.getItem(i).getX();
                dArray[i] = points.getItem(i).getY();
            }
            if (BufferImageNative.jni_DrawLineSymbol(internalBufferImage.getHandle(), l2, l, (double[])object, dArray)) {
                internalBufferImage.onDraw(g, (int)rectangle2D.getLeft() - n3, (int)rectangle2D.getBottom() - n4);
                internalBufferImage.dispose();
                internalBufferImage = null;
                InternalHandleDisposable.makeSureNativeObjectLive(style);
                InternalHandleDisposable.makeSureNativeObjectLive(workspace);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return false;
    }

    static boolean drawPoint(Graphics g, int x, int y, GeoStyle style, Workspace workspace) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(workspace);
        if (l2 == 0L) {
            String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            InternalBufferImage internalBufferImage;
            int n;
            Size2D size2D = style.getMarkerSize();
            if (size2D.getHeight() < 0.0 || size2D.getWidth() < 0.0) {
                return false;
            }
            double d = size2D.getWidth();
            if (size2D.getWidth() <= 1.0E-7) {
                d = InternalBufferImage.getMarkerSymbolDefaultSize(workspace, style.getMarkerSymbolID());
            }
            if ((n = (int)(d * 82.0 / 25.4)) == 0) {
                n = 1;
            }
            if (InternalBufferImage.getSymbolItemIndex(style.getMarkerSymbolID(), DatasetType.POINT, workspace) < 0) {
                g.setColor(style.getLineColor());
                g.fillArc(x, y, n, n, 0, 360);
                InternalHandleDisposable.makeSureNativeObjectLive(style);
                InternalHandleDisposable.makeSureNativeObjectLive(workspace);
                return true;
            }
            try {
                internalBufferImage = new InternalBufferImage(n, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            if (BufferImageNative.jni_DrawMarkerSymbol(internalBufferImage.getHandle(), l2, l, x, y)) {
                internalBufferImage.onDraw(g, x, y);
                internalBufferImage.dispose();
                internalBufferImage = null;
                InternalHandleDisposable.makeSureNativeObjectLive(style);
                InternalHandleDisposable.makeSureNativeObjectLive(workspace);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return false;
    }
}

